/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.cal;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.common.cal.eval.Parser;
import kd.taxc.common.cal.eval.tokenizer.ParseException;
import kd.taxc.common.metadata.domain.EntityField;
import kd.taxc.common.util.DataFormatUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.velocity.VelocityUtils;

public class CalculateService {
    private static Log logger = LogFactory.getLog(CalculateService.class);
    private static final Double EPSILON = 1.0E-11;
    private static Map<String, String> swapMap = new HashMap<String, String>(){
        {
            this.put("790466954983902210", "790466954983902208");
            this.put("790468283538082820", "790468283538082816");
        }
    };

    public static String calculate(String formula) {
        return CalculateService.calculate(formula, "1");
    }

    public static String calculate(String formula, String formulatype) {
        try {
            return CalculateService.numberToString(formula, null);
        }
        catch (Exception e) {
            logger.error("CalculateService calculate", (Throwable)e);
            return "0";
        }
    }

    public static String calculate(String formula, String formulatype, EntityField fieldType) {
        String result = null;
        if (formula.startsWith("#") || "4".equals(formulatype)) {
            try {
                result = VelocityUtils.velocityEngine(null, formula).toString();
            }
            catch (Exception e) {
                logger.error("\u5f02\u5e38\u65e5\u5fd7\u4e3a: " + e.getMessage());
            }
            if ("4".equals(formulatype)) {
                if ("0".equals(result) && "Text".equals(fieldType.getFieldType())) {
                    return "";
                }
                return StringUtil.trim((String)result);
            }
            try {
                return CalculateService.numberToString(result, fieldType);
            }
            catch (Exception e) {
                logger.error("CalculateService calculate", (Throwable)e);
                return "0";
            }
        }
        try {
            return CalculateService.numberToString(formula, fieldType);
        }
        catch (Exception e) {
            logger.error("CalculateService calculate", (Throwable)e);
            return "0";
        }
    }

    public static boolean check(String formula) {
        try {
            double values = Parser.parse(formula.replaceAll(" ", "")).evaluate();
            return values > 0.0;
        }
        catch (Exception e) {
            logger.error("check method error by formula:" + formula, (Throwable)e);
            return false;
        }
    }

    private static String numberToString(String formula, EntityField fieldType) {
        if (StringUtil.isBlank((CharSequence)formula)) {
            return "0";
        }
        try {
            double values = Parser.parse(formula.replaceAll(" ", "")).evaluate();
            if (Math.abs(values) <= EPSILON) {
                return "0";
            }
            BigDecimal b = BigDecimal.valueOf(values);
            String s = DataFormatUtils.decimalFormat(b, fieldType);
            return null == swapMap.get(s) ? s : swapMap.get(s);
        }
        catch (ParseException e) {
            logger.error("numberToString error by formula:" + formula, (Throwable)e);
            return "0";
        }
    }
}

