/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.cal.eval.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import kd.taxc.common.cal.eval.tokenizer.Char;
import kd.taxc.common.cal.eval.tokenizer.Lookahead;
import kd.taxc.common.cal.eval.tokenizer.ParseError;

public class LookaheadReader
extends Lookahead<Char> {
    private Reader input;
    private int line = 1;
    private int pos = 0;

    public LookaheadReader(Reader input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        this.input = new BufferedReader(input);
    }

    @Override
    protected Char endOfInput() {
        return new Char('\u0000', this.line, this.pos);
    }

    @Override
    protected Char fetch() {
        try {
            int character = this.input.read();
            if (character == -1) {
                return null;
            }
            if (character == 10) {
                ++this.line;
                this.pos = 0;
            }
            ++this.pos;
            return new Char((char)character, this.line, this.pos);
        }
        catch (IOException e) {
            this.problemCollector.add(ParseError.error(new Char('\u0000', this.line, this.pos), e.getMessage()));
            return null;
        }
    }

    public String toString() {
        if (this.itemBuffer.isEmpty()) {
            return this.line + ":" + this.pos + ": Buffer empty";
        }
        if (this.itemBuffer.size() < 2) {
            return this.line + ":" + this.pos + ": " + this.current();
        }
        return this.line + ":" + this.pos + ": " + this.current() + ", " + this.next();
    }
}

