/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.cal.eval.tokenizer;

import java.util.ArrayList;
import java.util.List;
import kd.taxc.common.cal.eval.tokenizer.ParseError;

public class ParseException
extends Exception {
    private static final long serialVersionUID = -5618855459424320517L;
    private transient List<ParseError> errors;

    private ParseException(String message, List<ParseError> errors) {
        super(message);
        this.errors = new ArrayList<ParseError>(errors);
    }

    public static ParseException create(List<ParseError> errors) {
        if (errors.size() == 1) {
            return new ParseException(errors.get(0).getMessage(), errors);
        }
        if (errors.size() > 1) {
            return new ParseException(String.format("%d errors occured. First: %s", errors.size(), errors.get(0).getMessage()), errors);
        }
        return new ParseException("An unknown error occured", errors);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ParseError error : this.errors) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(error);
        }
        return sb.toString();
    }
}

