/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.constant;

import kd.taxc.common.util.StringUtil;

public enum DraftTypeEnum {
    TCVAT("tcvat", null, new String[]{"draft_zzsybnsr", "draft_zzsxgmnsr", "draft_zzsybnsr_ybhz"}),
    TCCIT_QYSDSNB("tccit", "qysdsnb", new String[]{"draft_qysdsnb"}),
    TCCIT_QYSDSJB("tccit", "qysdsjb", new String[]{"draft_qysdsjb"}),
    TCCT("tcct", null, new String[]{"draft_xfs", "draft_xfsjypf"}),
    TCSD("tcsd", null, new String[]{"draft_yhs"});

    private String appId;
    private String type;
    private String[] templates;

    private DraftTypeEnum(String appId, String type, String[] templates) {
        this.appId = appId;
        this.type = type;
        this.templates = templates;
    }

    public String getAppId() {
        return this.appId;
    }

    private void setAppId(String appId) {
        this.appId = appId;
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
    }

    public String[] getTemplates() {
        return this.templates;
    }

    private void setTemplates(String[] templates) {
        this.templates = templates;
    }

    public static DraftTypeEnum valueOfAppId(String appId, String type) {
        for (DraftTypeEnum taxTypeEnum : DraftTypeEnum.values()) {
            String enumType = taxTypeEnum.getType();
            if (!taxTypeEnum.getAppId().equals(appId) || !StringUtil.isBlank((CharSequence)enumType) && !enumType.equals(type)) continue;
            return taxTypeEnum;
        }
        return null;
    }
}

