/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.constant;

public class LicenseCheckConstant {
    public static final String PRO_TAXB = "34";
    public static final String PRO_TAXP = "35";
    public static final String t_36 = "36";
    public static final String PRO_TAXM = "37";
    public static final String TAXB = "38";
    public static final String TACT_LICENSE_FORM = "tctb_license_from";
    public static final String v_6 = "6.0";
    public static final String v_5 = "5.0";
    public static final String v_4 = "4.0";
    public static final String v_3 = "3.0";
    public static final String LICENSE_LOCK_KEY = "taxc/license/syncData";

    public static String getV6LicenseByAppid(String appid) {
        return LicenseCheckConstant.getGroup(LicenseEnum.v_6, appid);
    }

    public static String getV5LicenseByAppid(String appid) {
        return LicenseCheckConstant.getGroup(LicenseEnum.v_5, appid);
    }

    public static String getV4LicenseByAppid(String appid) {
        return LicenseCheckConstant.getGroup(LicenseEnum.v_4, appid);
    }

    public static String getV3LicenseByAppid(String appid) {
        String group = LicenseCheckConstant.getGroup(LicenseEnum.v_3_PRO_TAXB, appid);
        if ("".equals(group) && "".equals(group = LicenseCheckConstant.getGroup(LicenseEnum.v_3_PRO_TAXM, appid))) {
            group = LicenseCheckConstant.getGroup(LicenseEnum.v_3_PRO_TAXP, appid);
        }
        return group;
    }

    private static String getGroup(LicenseEnum licenseEnum, String appid) {
        String group = "";
        for (String id : licenseEnum.appid) {
            if (!id.equalsIgnoreCase(appid.toLowerCase())) continue;
            group = licenseEnum.getGroup();
        }
        return group;
    }

    public static String getTXFTLicenseByBm() {
        return txLicenseEnum.TXFT.getBm();
    }

    public static String getTCDRSLicenseByMk() {
        return txLicenseEnum.TXFT.getMk();
    }

    public static String getTXCDLicenseByBm() {
        return txLicenseEnum.TXCD.getBm();
    }

    public static String getTSDCSLicenseByMk() {
        return txLicenseEnum.TXCD.getMk();
    }

    public static String getQHZDSYLicenseByBm() {
        return txLicenseEnum.QHZDSY.getBm();
    }

    public static String getQHZDSYLicenseByMk() {
        return txLicenseEnum.QHZDSY.getMk();
    }

    public static String getTCTSALicenseByBm() {
        return txLicenseEnum.TCTSA.getBm();
    }

    public static String getTCTSALicenseByMk() {
        return txLicenseEnum.TCTSA.getMk();
    }

    public static String getTAMLicenseByBm() {
        return txLicenseEnum.TAM.getBm();
    }

    public static String getTAMLicenseByMk() {
        return txLicenseEnum.TAM.getMk();
    }

    public static enum LicenseEnum {
        v_6("6.0", new String[]{"tcvat", "tccit", "tcret", "totf", "tcvvt", "rdesd", "tcetr", "tcnfep", "tctrc"}, "38"),
        v_5("5.0", new String[]{"tcvat", "tccit", "tcret", "tctsa", "tctrc"}, "38"),
        v_4("4.0", new String[]{"tcvat", "tccit", "tcret", "tctsa", "tctrc"}, "38"),
        v_3_PRO_TAXB("3.0", new String[]{"tccit", "tcvat", "fjsf"}, "34"),
        v_3_PRO_TAXP("3.0", new String[]{"tcct", "tcsd", "tcret"}, "35"),
        v_3_PRO_TAXM("3.0", new String[]{"tctrc"}, "37");

        String version;
        String[] appid;
        String group;

        private LicenseEnum(String version, String[] appid, String group) {
            this.version = version;
            this.appid = appid;
            this.group = group;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String[] getAppid() {
            return this.appid;
        }

        public void setAppid(String[] appid) {
            this.appid = appid;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }
    }

    static enum txLicenseEnum {
        TXFT("TXFT", "TCDRS"),
        TXCD("TXCD", "TSDCS"),
        QHZDSY("PRO_QHZDSY", "QHZDSY"),
        TCTSA("PRO_TCTSA", "TCTSA"),
        TAM("PRO_TAM", "TAM");

        String bm;
        String mk;

        private txLicenseEnum(String bm, String mk) {
            this.bm = bm;
            this.mk = mk;
        }

        public String getBm() {
            return this.bm;
        }

        public String getMk() {
            return this.mk;
        }
    }
}

