/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.datasource.fi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.enums.RuleConfigEnum;

public class GetGLBalanceCommonUtil {
    private static final Map<String, String> beginToEndMap = new HashMap<String, String>();
    private static final Map<String, String> replaceMap = new HashMap<String, String>();

    public static boolean tdmBalanceNew(String fieldsubname, String amountField) {
        if (!StringUtil.equals((CharSequence)"tdm_balance_new", (CharSequence)fieldsubname)) {
            return false;
        }
        return StringUtil.equals((CharSequence)"openingamount", (CharSequence)amountField) || StringUtil.equals((CharSequence)"openinglocalcurrency", (CharSequence)amountField) || StringUtil.equals((CharSequence)"closinglocalcurrency", (CharSequence)amountField) || StringUtil.equals((CharSequence)"closingamount", (CharSequence)amountField);
    }

    public static boolean conditionCheck(String fieldsubname, String amountField) {
        if (!StringUtil.equals((CharSequence)"gl_balance", (CharSequence)fieldsubname)) {
            return false;
        }
        return StringUtil.equals((CharSequence)"beginlocal", (CharSequence)amountField) || StringUtil.equals((CharSequence)"beginqty", (CharSequence)amountField) || StringUtil.equals((CharSequence)"endlocal", (CharSequence)amountField) || StringUtil.equals((CharSequence)"endqty", (CharSequence)amountField);
    }

    public static DynamicObjectCollection queryAccountingList(String entryName, String selectFieldwithid, String amountField, String startDate, String endDate, List<QFilter> filterList) {
        if (StringUtil.startsWith((CharSequence)amountField, (CharSequence)"begin")) {
            return GetGLBalanceCommonUtil.getBeginAccountingByDate(entryName, selectFieldwithid, amountField, startDate, filterList);
        }
        if (StringUtil.startsWith((CharSequence)amountField, (CharSequence)"end")) {
            return GetGLBalanceCommonUtil.getEndAccountingByDate(entryName, selectFieldwithid, amountField, endDate, filterList);
        }
        return new DynamicObjectCollection();
    }

    public static DynamicObjectCollection queryAccountingList(String entryName, String selectFieldwithid, String advancedconf, String amountField, String startDate, String endDate, List<QFilter> filterList) {
        if (StringUtil.equals((CharSequence)RuleConfigEnum.TOBEGIN.getRuleConfigCode(), (CharSequence)advancedconf)) {
            return GetGLBalanceCommonUtil.getBeginAccountingByDate(entryName, selectFieldwithid, amountField, startDate, filterList);
        }
        if (StringUtil.equals((CharSequence)RuleConfigEnum.TOEND.getRuleConfigCode(), (CharSequence)advancedconf)) {
            return GetGLBalanceCommonUtil.getEndAccountingByDate(entryName, selectFieldwithid, amountField, endDate, filterList);
        }
        return new DynamicObjectCollection();
    }

    private static DynamicObjectCollection getBeginAccountingByDate(String entryName, String selectFieldwithid, String amountField, String queryDate, List<QFilter> filterList) {
        CopyOnWriteArrayList<QFilter> resultFilter = new CopyOnWriteArrayList<QFilter>(filterList);
        for (QFilter qFilter : resultFilter) {
            if ("period.begindate".equals(qFilter.getProperty()) && "<=".equals(qFilter.getCP())) {
                qFilter.__setProperty("endperiod.begindate");
                qFilter.__setCP(">");
                qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
                qFilter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(qFilter.getProperty()) || !">=".equals(qFilter.getCP())) continue;
            qFilter.__setProperty("period.enddate");
            qFilter.__setCP("=");
            qFilter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
        }
        DynamicObjectCollection currentAccountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        for (QFilter filter : resultFilter) {
            if (!"period.enddate".equals(filter.getProperty()) || !"=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setCP("<");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
        }
        selectFieldwithid = selectFieldwithid.replace(amountField, beginToEndMap.get(amountField));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        currentAccountingList.addAll((Collection)dynamicObjectCollection);
        return currentAccountingList;
    }

    private static DynamicObjectCollection getEndAccountingByDate(String entryName, String selectFieldwithid, String amountField, String queryDate, List<QFilter> filterList) {
        CopyOnWriteArrayList<QFilter> resultFilter = new CopyOnWriteArrayList<QFilter>(filterList);
        for (QFilter filter : resultFilter) {
            if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                filter.__setProperty("endperiod.begindate");
                filter.__setCP(">");
                filter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
                filter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(filter.getProperty()) || !"<=".equals(filter.getCP())) continue;
            filter.__setProperty("period.enddate");
            filter.__setValue((Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(queryDate)));
        }
        DynamicObjectCollection accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        if (accountingList.size() > 0) {
            return accountingList;
        }
        return new DynamicObjectCollection();
    }

    public static QFilter parseQFilter(Long orgId, String table, QFilter filter) {
        QFilter qFilter;
        if (filter == null) {
            return null;
        }
        QFilter result = filter;
        QFilter[] recombine = filter.recombine();
        QFilter appendQFilter = null;
        boolean anyMatch = false;
        ArrayList cps = Lists.newArrayList((Object[])new String[]{"=", "in", "IN"});
        if ("gl_balance".equals(table)) {
            anyMatch = Arrays.stream(recombine).anyMatch(s -> cps.contains(s.getCP()) && "account.number".equals(s.getProperty()));
            appendQFilter = new QFilter("account.isleaf", "=", (Object)Boolean.TRUE);
        } else if ("tdm_balance_new".equals(table)) {
            result = filter;
        } else if ("gl_voucher".equals(table)) {
            anyMatch = Arrays.stream(recombine).anyMatch(s -> cps.contains(s.getCP()) && "entries.account.number".equals(s.getProperty()));
            appendQFilter = new QFilter("entries.account.isleaf", "=", (Object)Boolean.TRUE);
        } else if ("tdm_recording_voucher_new".equals(table)) {
            anyMatch = Arrays.stream(recombine).anyMatch(s -> cps.contains(s.getCP()) && "balance.number".equals(s.getProperty()));
            appendQFilter = new QFilter("balance.parent", "<>", (Object)" ");
        }
        if (anyMatch && (qFilter = GetGLBalanceCommonUtil.dealQFilter(filter, null, null)) != null) {
            result = qFilter.and(appendQFilter);
        }
        return result;
    }

    public static QFilter dealQFilter(QFilter sourceQFilter, String op, QFilter targetQFilter) {
        QFilter temp;
        String property = sourceQFilter.getProperty();
        String cp = sourceQFilter.getCP();
        Object value = sourceQFilter.getValue();
        List nests = sourceQFilter.getNests(false);
        List<String> numbers = GetGLBalanceCommonUtil.getValue(value);
        if (replaceMap.containsKey(property)) {
            temp = null;
            for (String number : numbers) {
                QFilter filter = new QFilter(replaceMap.get(property), "like", (Object)("%" + number + "%"));
                temp = temp == null ? filter : temp.or(filter);
            }
            targetQFilter = targetQFilter == null ? temp : ("or".equals(op) ? targetQFilter.or(temp) : targetQFilter.and(temp));
        } else {
            temp = new QFilter(property, cp, value);
            targetQFilter = targetQFilter == null ? temp : ("or".equals(op) ? targetQFilter.or(temp) : targetQFilter.and(temp));
        }
        for (QFilter.QFilterNest nest : nests) {
            String option = nest.isAnd() ? "and" : "or";
            GetGLBalanceCommonUtil.dealQFilter(nest.getFilter(), option, targetQFilter);
        }
        return targetQFilter;
    }

    private static List<String> getValue(Object value) {
        List<String> numbers = new ArrayList<String>();
        if (value instanceof String) {
            numbers.add(value.toString());
        } else if (value instanceof List) {
            numbers = (List)value;
        }
        return numbers;
    }

    static {
        beginToEndMap.put("beginlocal", "endlocal as beginlocal");
        beginToEndMap.put("beginqty", "endqty as beginqty");
        beginToEndMap.put("endlocal", "endlocal");
        beginToEndMap.put("endqty", "endqty");
        replaceMap.put("account.number", "account.longnumber");
        replaceMap.put("entries.account.number", "entries.account.longnumber");
        replaceMap.put("balance.number", "balance.longnumber");
    }
}

