/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.db.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;

public class YbnsrService {
    private static Log logger = LogFactory.getLog(YbnsrService.class);
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    public static final String SPLITSTRING = "#";
    public static final String EWBLXH = "ewblxh";
    public static final String SBBID = "sbbid";
    private static final String ORGID = "org";
    private static final String STATUS = "declarestatus";
    private static final String PAY_STATUS = "paystatus";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String SBRQ = "sbrq";
    private static final String NSRTYPE = "type";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TEMPLATE_ID = "templateid";
    private static final String ID = "id";
    public static final String GROUP_REGISTER_TABLE = "tcvvt_clique_mcinfo";
    public static final String GROUP_REGISTER_ORIGINAL_TABLE = "tcvvt_roll_list";
    private static final String[] declareFileList = new String[]{"id"};
    private static final String[] fields = new String[]{"id", "number", "contactinformation", "maincompany", "taxorg.taxpayer as taxpayer", "taxorg.unifiedsocialcode as unifiedsocialcode", "registertype.name", "registeredcapital", "registertime", "codeandname.name", "legalpeople", "registeraddress", "actualaddress", "accountingstandards", "orgid", "registeraddrdetail", "actualaddrdetail", "entryentity.bankname", "entryentity.bankacct,taxoffice"};

    public static DynamicObject queryYbnsrDateRange(String orgid, String stype, String startData, String endData, int month, Map<String, Object> extendParams) {
        List<QFilter> qFilters = YbnsrService.getQFilters(orgid, stype, startData, endData, month, true, extendParams);
        return YbnsrService.getDynamicObjectByFilters(extendParams, qFilters);
    }

    private static DynamicObject getDynamicObjectByFilters(Map<String, Object> extendParams, List<QFilter> qFilters) {
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                Object value = entry.getValue();
                if (entry.getKey().equals("groupid")) {
                    value = Long.parseLong(value.toString());
                }
                QFilter extendFilter = new QFilter(entry.getKey(), "=", value);
                qFilters.add(extendFilter);
            }
        }
        QFilter[] qFilterArr = new QFilter[qFilters.size()];
        String allFieldString = MetadataUtil.getAllSubFieldString((String)TCVAT_NSRXX);
        DynamicObjectCollection temp = QueryServiceHelper.query((String)TCVAT_NSRXX, (String)allFieldString, (QFilter[])qFilters.toArray(qFilterArr));
        if (null != temp && temp.size() > 0) {
            return (DynamicObject)temp.get(0);
        }
        return null;
    }

    public static List<QFilter> getQFilters(String orgid, String stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (!YbnsrService.checkGroupSubmmitted(stype, extendParams)) {
            qFilters.add(new QFilter(ORGID, "=", (Object)Long.parseLong(orgid)));
        }
        qFilters.add(new QFilter(NSRTYPE, "=", (Object)stype));
        if (dateRange) {
            qFilters.add(new QFilter(SKSSQQ, ">=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        } else {
            qFilters.add(new QFilter(SKSSQQ, "=", (Object)DateUtils.addMonth(DateUtils.stringToDate(startData), month)));
        }
        qFilters.add(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endData), month))));
        qFilters.add(new QFilter(TAXLIMIT, "=", (Object)DateUtils.getTaxLimit(DateUtils.stringToDate(startData), DateUtils.stringToDate(endData))));
        return qFilters;
    }

    public static boolean checkGroupSubmmitted(String type, Map<String, Object> extendParams) {
        return StringUtils.equals((CharSequence)"qhjtbs", (CharSequence)type) && EmptyCheckUtils.isNotEmpty(extendParams) && StringUtils.isNotBlank((Object)extendParams.get("groupid"));
    }
}

