/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.formula.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.common.formula.utils.JsonUtils;
import kd.taxc.common.template.TemplateUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.StringUtil;

public class CacheUtils {
    private static Log logger = LogFactory.getLog(CacheUtils.class);
    private static CacheUtils c = new CacheUtils();
    public static final String GROUPID = "groupid";
    public static final String ORGID = "orgid";
    public static final String STARTDATA = "startDate";
    public static final String ENDDATA = "endDate";
    public static final String PRE_STARTDATA = "prestartDate";
    public static final String PRE_ENDDATA = "preendDate";
    public static final String FORMULATYPE = "formulaType";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TAXPERIOD = "taxperiod";
    public static final String YEAR = "year";
    public static final String MOTH = "moth";
    public static final String DJLX = "djlx";
    private static final String PARAM = "param";
    private static final String CACHERESULT = "cacheResult";
    private static final String ORGINALCACHERESULT = "orginalcacheresult";
    public static final String DEADLINE = "deadline";
    private static final String[] deleteKey = new String[]{"deadline", "startDate", "endDate", "prestartDate", "preendDate", "formulaType", "year", "moth", "param", "cacheResult", "orginalcacheresult", "templateid"};

    public void deleteCache(IPageCache cache) {
        for (String key : deleteKey) {
            if (key.equals(CACHERESULT) || key.equals(ORGINALCACHERESULT)) {
                key = key + this.getCacheKeySuffix(cache);
            }
            cache.remove(key);
        }
    }

    private CacheUtils() {
    }

    public static CacheUtils getInstance() {
        return c;
    }

    private void setCacheValue(IPageCache cache, String key, String value) {
        cache.put(key, value);
    }

    public void setParamsValue(IPageCache cache, String orgId, String startData, String endData, String formulaType, Map<String, String> selfParams) {
        this.setCacheValue(cache, ORGID, orgId);
        this.setCacheValue(cache, STARTDATA, startData);
        this.setCacheValue(cache, ENDDATA, endData);
        this.setCacheValue(cache, FORMULATYPE, formulaType);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(FORMULATYPE, formulaType);
        param.put(ORGID, orgId);
        param.put(STARTDATA, startData);
        param.put(ENDDATA, endData);
        String taxperiod = DateUtils.format(DateUtils.stringToDate(startData), "yyyy-MM");
        param.put(TAXPERIOD, taxperiod);
        param.put(YEAR, taxperiod.split("-")[0]);
        param.put(MOTH, taxperiod.split("-")[1]);
        String taxLimit = DateUtils.getTaxLimit(DateUtils.stringToDate(startData), DateUtils.stringToDate(endData));
        param.put(TAXLIMIT, taxLimit);
        List<Date> dates = DateUtils.getPreDate(DateUtils.stringToDate(startData), DateUtils.stringToDate(endData));
        param.put(PRE_STARTDATA, DateUtils.format(dates.get(0)));
        param.put(PRE_ENDDATA, DateUtils.format(dates.get(1)));
        if (null != selfParams) {
            for (Map.Entry<String, String> entry : selfParams.entrySet()) {
                param.put(entry.getKey(), entry.getValue());
            }
        }
        cache.put(PARAM, JsonUtils.mapToStr(param));
    }

    public void setDataAndOrginalResult(IPageCache cache, Map<String, String> map) {
        String json = JsonUtils.mapToStr(map);
        this.setDataResult(cache, map);
        this.setCacheValue(cache, ORGINALCACHERESULT + this.getCacheKeySuffix(cache), json);
    }

    public void setDataResult(IPageCache cache, Map<String, String> map) {
        long start = System.currentTimeMillis();
        DistributeSessionlessCache disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("taxc");
        String key = CACHERESULT + this.getCacheKeySuffix(cache);
        disCache.put(key, (Object)JsonUtils.mapToStr(map), 3600);
        logger.info("\u3010CacheUtils\u3011setDataResult \u8017\u65f6={}, key={},value={}", new Object[]{System.currentTimeMillis() - start, key, this.getDataResult(cache)});
    }

    public Map<String, String> getDataResult(IPageCache cache) {
        DistributeSessionlessCache disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("taxc");
        String key = CACHERESULT + this.getCacheKeySuffix(cache);
        return JsonUtils.strToMap((String)disCache.get(key));
    }

    public void setOrginalDataResult(IPageCache cache, String json) {
        this.setCacheValue(cache, ORGINALCACHERESULT + this.getCacheKeySuffix(cache), json);
    }

    public Map<String, String> getOrginalDataResult(IPageCache cache) {
        return JsonUtils.strToMap(cache.get(ORGINALCACHERESULT + this.getCacheKeySuffix(cache)));
    }

    public String getStartData(IPageCache cache) {
        return cache.get(STARTDATA);
    }

    public String getEndData(IPageCache cache) {
        return cache.get(ENDDATA);
    }

    public String getOrgid(IPageCache cache) {
        return cache.get(ORGID);
    }

    public String getTemplateId(IPageCache cache) {
        return cache.get("templateid");
    }

    public void setTemplateId(IPageCache cache, String templateId) {
        cache.put("templateid", templateId);
    }

    public String getFormulaType(IPageCache cache) {
        return cache.get(FORMULATYPE);
    }

    public Map<String, String> getParam(IPageCache cache) {
        return JsonUtils.strToMap(cache.get(PARAM));
    }

    public String getCacheKeySuffix(IPageCache cache) {
        String pageId = cache.get("rootPageId");
        if (StringUtil.isBlank((CharSequence)pageId)) {
            pageId = cache.getPageId();
        }
        String templateType = cache.get("templatetype");
        String key = String.format("%s_%s_%s_%s_%s_%s", System.getProperty("env.type"), pageId, cache.get(ORGID), templateType, cache.get("skssqq"), cache.get("skssqz"));
        return StringUtils.isBlank((CharSequence)cache.get(GROUPID)) ? key : cache.get(GROUPID) + cache.get(ORGID);
    }

    public static void buildTemplateId(IPageCache cache) {
        String templateId = CacheUtils.getInstance().getTemplateId(cache);
        if (StringUtil.isEmpty((CharSequence)templateId)) {
            String type = CacheUtils.getInstance().getFormulaType(cache);
            String startData = CacheUtils.getInstance().getStartData(cache);
            String endData = CacheUtils.getInstance().getEndData(cache);
            String orgid = CacheUtils.getInstance().getOrgid(cache);
            DynamicObject dynamicObject = TemplateUtils.getTemplateObjectByConfig(type, orgid, DateUtils.stringToDate(startData, "yyyy-MM-dd"), DateUtils.stringToDate(startData, "yyyy-MM-dd"));
            if (null == dynamicObject) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5c5e\u671f\u65e0\u53ef\u7528\u6a21\u677f", (String)"CacheUtils_0", (String)"taxc-tctb-common", (Object[])new Object[0]));
            }
            templateId = dynamicObject.getString("id");
            CacheUtils.getInstance().setTemplateId(cache, templateId);
        }
    }
}

