/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static Log logger = LogFactory.getLog(HttpUtil.class);
    private static PoolingHttpClientConnectionManager poolConnManager = null;

    public static void init() {
        int maxTotalPool = 50;
        int maxConPerRoute = 5;
        int socketTimeout = 600000;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            SSLContext sslcontext = builder.build();
            HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            poolConnManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            poolConnManager.setMaxTotal(maxTotalPool);
            poolConnManager.setDefaultMaxPerRoute(maxConPerRoute);
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(socketTimeout).build();
            poolConnManager.setDefaultSocketConfig(socketConfig);
            if (poolConnManager.getTotalStats() != null) {
                logger.info("new client pool {}", (Object)poolConnManager.getTotalStats());
            }
        }
        catch (Exception e) {
            logger.error("InterfacePhpUtilManager init Exception {}", (Object)e.getMessage());
        }
    }

    public static CloseableHttpClient getConnection() {
        int connectionRequestTimeout = 1200000;
        int connectTimeout = 600000;
        int socketTimeout = 600000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolConnManager).setDefaultRequestConfig(requestConfig).build();
        if (poolConnManager != null && poolConnManager.getTotalStats() != null) {
            logger.info("client pool info {}", (Object)poolConnManager.getTotalStats());
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> headers, Map<String, Object> params) {
        CloseableHttpClient client = HttpUtil.getConnection();
        StringBuilder sb = new StringBuilder(url).append("?");
        if (params != null) {
            for (Map.Entry<String, Object> k : params.entrySet()) {
                sb.append(k).append('=').append(k.getValue()).append('&');
            }
        }
        URI uri = URI.create(url);
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = null;
        String rs = "";
        try {
            if (headers != null) {
                for (Map.Entry<String, String> k : headers.entrySet()) {
                    get.setHeader(k.getKey(), k.getValue());
                }
            } else {
                get.setHeader("Connection", "close");
            }
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                rs = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            try {
                get.abort();
                get.releaseConnection();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> headers, HttpEntity httpEntity) {
        CloseableHttpClient client = HttpUtil.getConnection();
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        String rs = "";
        try {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    post.setHeader(k, v);
                }
            } else {
                post.setHeader("Connection", "close");
            }
            post.setEntity(httpEntity);
            response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                rs = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            try {
                post.abort();
                post.releaseConnection();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return rs;
    }

    public static String doPost(String url, Map<String, Object> params) {
        return HttpUtil.doPost(url, null, params);
    }

    public static String doPost(String url, Map<String, String> headers, String body) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        return HttpUtil.doPost(url, headers, (HttpEntity)new StringEntity(body, "UTF-8"));
    }

    public static String doPost(String url, Map<String, String> headers, Map<String, Object> params) {
        if (params != null) {
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object obj = entry.getValue();
                urlParameters.add(new BasicNameValuePair(key, obj.toString()));
            }
            try {
                if (headers == null) {
                    headers = new HashMap<String, String>();
                }
                headers.put("Content-Type", "application/x-www-form-urlencoded");
                return HttpUtil.doPost(url, headers, (HttpEntity)new UrlEncodedFormEntity(urlParameters, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        } else {
            try {
                return HttpUtil.doPost(url, null, (HttpEntity)new NullParamsHttpEntity());
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "test");
        params.put("id", 1);
        HttpUtil.doPost("http://127.0.0.1:80/test.php", params);
    }

    static {
        HttpUtil.init();
    }

    private static class NullParamsHttpEntity
    extends StringEntity {
        public NullParamsHttpEntity() throws UnsupportedEncodingException {
            super("");
        }
    }
}

