/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.TreeUtils;

public class BaseDataUtil {
    public static ArrayList<Long> getAllPermOrgs() {
        Long orgId = RequestContext.get().getOrgId();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        List permOrgs = hasPermOrgResult.getHasPermOrgs();
        ArrayList<Long> rootOrg = new ArrayList<Long>();
        rootOrg.add(orgId);
        List childOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)10L, rootOrg, (boolean)true);
        permOrgs.retainAll(childOrgs);
        DynamicObjectCollection taxorgs = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", permOrgs));
        ArrayList<Long> retOrgs = new ArrayList<Long>();
        for (int i = 0; i < taxorgs.size(); ++i) {
            retOrgs.add(((DynamicObject)taxorgs.get(i)).getLong("id"));
        }
        return retOrgs;
    }

    public static String getDefaultOrg(IFormView view) {
        String defaultOrg = "";
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        if (null == col || col.isEmpty()) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        if (!CollectionUtils.isEmpty((Collection)col)) {
            boolean useDefault = false;
            for (DynamicObject obj : col) {
                if (obj.getLong("id") != orgId) continue;
                defaultOrg = String.valueOf(orgId);
                useDefault = true;
                break;
            }
            if (!useDefault) {
                defaultOrg = ((DynamicObject)col.get(0)).getString("id");
            }
        }
        return defaultOrg;
    }
}

