/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.org;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.DateUtils;

public class OrgChangeRecordUtil {
    public static DynamicObject loadChangeRecord(String orgId, Date startDate, Date endDate) {
        DynamicObjectCollection list = OrgChangeRecordUtil.getChangeRecord(Long.valueOf(orgId), "zzs", DateUtils.format(startDate), DateUtils.format(endDate));
        return CollectionUtils.isEmpty((Collection)list) ? null : (DynamicObject)list.get(0);
    }

    public static DynamicObjectCollection getChangeRecord(Long orgid, String taxType, String startDate, String endDate) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)taxType);
        QFilter taxenddateFilter = new QFilter("entryentity.modifycontexttitleysjbs", "=", (Object)"taxenddate");
        String selectFields = "id,entryentity.modifycontexttitleysjbs as name,entryentity.modifycontexbefore as startdate,entryentity.modifycontexafter as enddate,entryentity.modifycontexbeforecode as value,entryentity.modifycontexaftercode";
        QFilter endFilter2 = new QFilter("entryentity.modifycontexafter", ">=", (Object)endDate).and(new QFilter("entryentity.modifycontexbefore", "<=", (Object)endDate).or(new QFilter("entryentity.modifycontexbefore", "is null", null)));
        DynamicObjectCollection operatorRecordCollection = QueryServiceHelper.query((String)"tctb_tax_ver_normal", (String)"id", (QFilter[])new QFilter[]{orgFilter, taxTypeFilter, taxenddateFilter, endFilter2});
        boolean useLatestRecord = false;
        if (operatorRecordCollection.size() == 0) {
            selectFields = "id,entryentity.modifycontexttitleysjbs as name,entryentity.modifycontexbefore as enddate,entryentity.modifycontexafter as startdate,entryentity.modifycontexbeforecode ,entryentity.modifycontexaftercode as value";
            operatorRecordCollection = QueryServiceHelper.query((String)"tctb_tax_ver_normal", (String)"id", (QFilter[])new QFilter[]{orgFilter, taxTypeFilter, taxenddateFilter}, (String)"entryentity.modifycontexafter desc", (int)1);
            useLatestRecord = true;
        }
        List idList = operatorRecordCollection.stream().map(o -> o.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tctb_tax_ver_normal", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)"id desc");
        Map<String, List<DynamicObject>> dynamicObjectMap = query.stream().collect(Collectors.groupingBy(o -> o.getString("id")));
        DynamicObjectCollection resultCollection = new DynamicObjectCollection();
        QFilter qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)"zzs");
        DynamicObject taxMain = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"categoryentryentity.enable as enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)orgid), qFilter});
        if (null == taxMain) {
            return resultCollection;
        }
        for (List<DynamicObject> dynamicObject : dynamicObjectMap.values()) {
            DynamicObject changeRecord = BusinessDataServiceHelper.newDynamicObject((String)"tctb_tax_change_record");
            for (DynamicObject object : dynamicObject) {
                if ("taxenddate".equals(object.getString("name"))) {
                    changeRecord.set("taxstartdate", (Object)DateUtils.stringToDate(object.getString("startdate")));
                    changeRecord.set("taxenddate", useLatestRecord ? null : DateUtils.stringToDate(object.getString("enddate")));
                    continue;
                }
                changeRecord.set(object.getString("name"), (Object)object.getString("value"));
            }
            changeRecord.set("enable", (Object)taxMain.getString("enable"));
            resultCollection.add((Object)changeRecord);
        }
        return resultCollection;
    }
}

