/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.showpage.PageShowCommon;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.license.LicenseCheckService;
import kd.taxc.license.LicenseTaxEnum;
import kd.taxc.tctb.service.TaxOrgTakeRelationServiceHelper;
import kd.taxc.tctb.service.TaxOrgUnitServiceHelper;

public class OrgCheckUtil {
    private static final String TCTB_ORG_TAKEDATA = "tctb_org_takedata";
    private static final String TCTB_TAX_MAIN = "tctb_tax_main";

    public static boolean checkById(IFormView view, String orgId, String appid, String entityid) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(appid, entityid, "4715a0df000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"OrgCheckUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckService.check(orgId, view, appid)) {
            return true;
        }
        return OrgCheckUtil.orgEnable(view, org, true);
    }

    public static boolean checkByElseForm(IFormView view, String orgId, String appid, String categoryType, String formid) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (EmptyCheckUtils.isEmpty(orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(appid, formid, "47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"OrgCheckUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckService.check(orgId, view, appid)) {
            return true;
        }
        if (OrgCheckUtil.orgEnable(view, org, true)) {
            return true;
        }
        if (OrgCheckUtil.isTaxPayerAuth(view, orgId, true)) {
            return true;
        }
        if (null != categoryType) {
            String categoryent = OrgCheckUtil.getCategoryentName(categoryType);
            QFilter qFilter = null;
            if (!LicenseTaxEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)categoryType);
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"orgid.name,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_2", (String)"taxc-tctb-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tctb-common", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public static Long setDefaultOrg(IFormView getView, Long orgid, DynamicObjectCollection permOrgs) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        if (QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{orgFilter})) {
            return orgid;
        }
        if (CollectionUtils.isEmpty((Collection)permOrgs)) {
            getView.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
            return null;
        }
        List orgList = permOrgs.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        DynamicObject[] taxOrg = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgList)}, (String)"org desc", (int)1);
        if (taxOrg.length < 1 || taxOrg[0].getDynamicObject("org") == null) {
            getView.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
            return null;
        }
        return taxOrg[0].getDynamicObject("org").getLong("id");
    }

    public static boolean check(IFormView view, String orgId, String appid, String categoryType) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (EmptyCheckUtils.isEmpty(orgId) || Objects.equals("0", orgId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
            return true;
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"OrgCheckUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return true;
        }
        if (LicenseCheckService.check(orgId, view, appid)) {
            return true;
        }
        if (OrgCheckUtil.orgEnable(view, org, true)) {
            return true;
        }
        if (OrgCheckUtil.isTaxPayerAuth(view, orgId, true)) {
            return true;
        }
        if (null != categoryType) {
            String categoryent = OrgCheckUtil.getCategoryentName(categoryType);
            QFilter qFilter = null;
            if (LicenseTaxEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                return false;
            }
            qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)categoryType);
            DynamicObjectCollection list = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"orgid.name,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_2", (String)"taxc-tctb-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    return true;
                }
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tctb-common", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private static String getCategoryentName(String categoryType) {
        switch (categoryType) {
            case "qysds": {
                return ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"OrgCheckUtil_4", (String)"taxc-tctb-common", (Object[])new Object[0]);
            }
            case "yhs": {
                return ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"OrgCheckUtil_5", (String)"taxc-tctb-common", (Object[])new Object[0]);
            }
            case "fcscztdsys": {
                return ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"OrgCheckUtil_6", (String)"taxc-tctb-common", (Object[])new Object[0]);
            }
            case "fjsf": {
                return ResManager.loadKDString((String)"\u9644\u52a0\u7a0e", (String)"OrgCheckUtil_7", (String)"taxc-tctb-common", (Object[])new Object[0]);
            }
            case "tcvat": 
            case "zzs": {
                return ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"OrgCheckUtil_8", (String)"taxc-tctb-common", (Object[])new Object[0]);
            }
            case "xfs": {
                return ResManager.loadKDString((String)"\u6d88\u8d39\u7a0e", (String)"OrgCheckUtil_9", (String)"taxc-tctb-common", (Object[])new Object[0]);
            }
        }
        return "xxxx";
    }

    public static boolean searchCheck(TreeNode node, IFormView view, boolean needErrorMsg) {
        String orgId = node.getId();
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"OrgCheckUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            }
            return false;
        }
        String appid = view.getFormShowParameter().getAppId();
        LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid(appid);
        if (null == taxEnum) {
            return true;
        }
        if (needErrorMsg ? LicenseCheckService.check(orgId, view, taxEnum.getAppid()) : LicenseCheckService.check(orgId, null, taxEnum.getAppid())) {
            return false;
        }
        if (OrgCheckUtil.orgEnable(view, org, needErrorMsg)) {
            return false;
        }
        if (null != taxEnum.getCategoryCode()) {
            QFilter qFilter = null;
            if (!LicenseTaxEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)taxEnum.getCategoryCode());
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"orgid.name,taxorg.istaxpayer as isentity,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    if (needErrorMsg) {
                        view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_2", (String)"taxc-tctb-common", (Object[])new Object[0]), dy.getString("orgid.name"), taxEnum.getName()));
                    }
                    return false;
                }
            } else {
                if (needErrorMsg) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tctb-common", (Object[])new Object[0]));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean licenseCheckByAppid(TreeNode node, String appid) {
        String orgId = node.getId();
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid(appid);
        if (null == taxEnum) {
            return true;
        }
        if (LicenseCheckService.check(orgId, null, taxEnum.getAppid())) {
            return false;
        }
        if (OrgCheckUtil.orgEnable(null, org, false)) {
            return false;
        }
        if (null != taxEnum.getCategoryCode()) {
            QFilter qFilter = null;
            if (!LicenseTaxEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)taxEnum.getCategoryCode());
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"orgid.name,maincompany,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType) {
        return OrgCheckUtil.withoutLicenseCheck(view, orgId, appid, categoryType, true);
    }

    public static boolean withoutLicenseCheck(IFormView view, String orgId, String appid, String categoryType, boolean needErrorMsg) {
        return OrgCheckUtil.checkOrgAndEnable(view, orgId, needErrorMsg) || OrgCheckUtil.isTaxPayerAuth(view, orgId, needErrorMsg) || OrgCheckUtil.taxCategoryEnable(orgId, view, appid, categoryType, needErrorMsg);
    }

    public static boolean checkOrgAndEnable(IFormView view, String orgId) {
        return OrgCheckUtil.checkOrgAndEnable(view, orgId, true);
    }

    public static boolean checkOrgAndEnable(IFormView view, String orgId, boolean needErrorMsg) {
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        if (OrgCheckUtil.orgAuth(orgId, view, org, needErrorMsg)) {
            return true;
        }
        return OrgCheckUtil.orgEnable(view, org, needErrorMsg);
    }

    public static boolean isTaxPayerAuth(IFormView view, String orgId, boolean needErrorMsg) {
        DynamicObjectCollection orgs = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgId));
        boolean contains = OrgUtils.MUST_IS_TAXPAYER.contains(PageShowCommon.getMetadataNumberByView(view));
        boolean isNotTaxPayer = false;
        if (contains) {
            isNotTaxPayer = TaxOrgUnitServiceHelper.validationTaxOrgMustInput(view, ((DynamicObject)orgs.get(0)).getLong("id"), ((DynamicObject)orgs.get(0)).getString("name"), needErrorMsg);
        }
        return isNotTaxPayer;
    }

    public static boolean orgAuth(String orgId, IFormView view, DynamicObjectCollection org) {
        return OrgCheckUtil.orgAuth(orgId, view, org, true);
    }

    public static boolean orgAuth(String orgId, IFormView view, DynamicObjectCollection org, boolean needErrorMsg) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(orgId))) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"OrgCheckUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            }
            return true;
        }
        return false;
    }

    public static boolean orgEnable(IFormView view, DynamicObjectCollection org, boolean needErrorMsg) {
        if (null != org && !org.isEmpty() && !"1".equals(OrgUtils.getOrgStatusById(((DynamicObject)org.get(0)).getString("id")))) {
            if (needErrorMsg) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_10", (String)"taxc-tctb-common", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            }
            return true;
        }
        return false;
    }

    public static boolean taxCategoryEnable(String orgId, IFormView view, String appid, String categoryType, boolean needErrorMsg) {
        if (null != categoryType) {
            String categoryent = OrgCheckUtil.getCategoryentName(categoryType);
            if (LicenseTaxEnum.TCRET.getAppid().equalsIgnoreCase(appid)) {
                return false;
            }
            QFilter qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)categoryType);
            DynamicObjectCollection list = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"orgid.name,maincompany,categoryentryentity.taxpayertype,categoryentryentity.enable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgId)), qFilter});
            if (list.size() > 0) {
                DynamicObject dy = (DynamicObject)list.get(0);
                if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                    if (needErrorMsg) {
                        view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"OrgCheckUtil_2", (String)"taxc-tctb-common", (Object[])new Object[0]), dy.getString("orgid.name"), categoryent));
                    }
                    return true;
                }
            } else {
                if (needErrorMsg) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgCheckUtil_3", (String)"taxc-tctb-common", (Object[])new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    public static DynamicObject getFJSFCategory(Long orgid) {
        QFilter qFilter = new QFilter("categoryentryentity.taxtype", "=", (Object)"fjsf");
        DynamicObjectCollection list = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"categoryentryentity.enable,categoryentryentity.dfjyffjenable,categoryentryentity.jyffjenable,categoryentryentity.cswhjssenable", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)orgid), qFilter});
        if (list.size() > 0) {
            DynamicObject dy = (DynamicObject)list.get(0);
            if (Objects.equals("0", dy.getString("categoryentryentity.enable"))) {
                return null;
            }
            return dy;
        }
        return null;
    }

    public static String findTaxOrg(IFormView view, String orgField, IPageCache pageCache) {
        Long unitOrgId = RequestContext.get().getOrgId();
        TreeNode treeNode = new TreeNode();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        pageCache.put("orgList", SerializationUtils.toJsonString((Object)col));
        if (!CollectionUtils.isEmpty((Collection)col)) {
            ArrayList<Long> orgids = new ArrayList<Long>(10);
            for (DynamicObject obj : col) {
                Long orgid = obj.getLong("id");
                treeNode.setId(String.valueOf(orgid));
                if (!OrgCheckUtil.searchCheck(treeNode, view, false)) continue;
                orgids.add(orgid);
                if (!unitOrgId.equals(orgid)) continue;
                return String.valueOf(orgid);
            }
            if (EmptyCheckUtils.isNotEmpty(orgids)) {
                return String.valueOf(orgids.get(0));
            }
        }
        return null;
    }

    public static String findTaxOrg(IFormView view, IPageCache pageCache) {
        Long unitOrgId = RequestContext.get().getOrgId();
        TreeNode treeNode = new TreeNode();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(view);
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission(hasPermOrgs, true);
        pageCache.put("orgList", SerializationUtils.toJsonString((Object)col));
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                if (!unitOrgId.equals(obj.getLong("id"))) continue;
                treeNode.setId(String.valueOf(unitOrgId));
                break;
            }
            if (treeNode.getId().length() == 0) {
                treeNode.setId(((DynamicObject)col.get(0)).getString("id"));
            }
            return OrgCheckUtil.searchCheck(treeNode, view, false) ? null : treeNode.getId();
        }
        view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgCheckUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
        return null;
    }

    public static boolean checkRelation(Long accountOrg, Date startDate, Date endDate) {
        return Objects.nonNull(OrgCheckUtil.getTaxOrgInfo(accountOrg, startDate, endDate));
    }

    public static DynamicObject getTaxOrgInfo(Long accountOrg, Date startDate, Date endDate) {
        return OrgCheckUtil.getTaxOrgInfo(accountOrg, startDate);
    }

    public static DynamicObject getTaxOrgInfo(Long accountOrg, Date startDate) {
        List<Long> taxOrgByAccountingOrg = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg(accountOrg, startDate);
        if (taxOrgByAccountingOrg.size() == 0) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)TCTB_ORG_TAKEDATA);
        DynamicObject orgStructure = new DynamicObject((DynamicObjectType)entityType);
        orgStructure.set("taxorg", (Object)taxOrgByAccountingOrg.get(0));
        return orgStructure;
    }

    public static DynamicObjectCollection getTaxOrgNsrxx(Long accountOrg, Date startDate, Date endDate, String appid) {
        DynamicObject taxOrg = OrgCheckUtil.getTaxOrgInfo(accountOrg, startDate, endDate);
        if (null == taxOrg) {
            return new DynamicObjectCollection();
        }
        LicenseTaxEnum taxEnum = LicenseTaxEnum.getEnumInstanceByAppid(appid);
        DynamicObjectCollection taxOrgObject = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"categoryentryentity.taxpayertype as taxpayertype, orgid", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)taxOrg.getLong("taxorg")), new QFilter("categoryentryentity.taxtype", "=", (Object)taxEnum.getCategoryCode())});
        return taxOrgObject;
    }

    public static boolean isTaxPayer(Long orgid) {
        QFilter qFilter = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
        QFilter qFilter2 = new QFilter("org", "=", (Object)orgid);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{qFilter, qFilter2});
        return EmptyCheckUtils.isNotEmpty(dynamicObjects);
    }
}

