/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.FieldProp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;

public class ParamUtil {
    public static String getViewType(String appid) {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("id", "=", (Object)appid);
        DynamicObject bizApp = orm.queryOne("bos_devportal_bizapp", new QFilter[]{qFilter});
        String viewType = "15";
        if (bizApp != null && StringUtils.isNotBlank((Object)bizApp.get("orgfunc"))) {
            viewType = bizApp.get("orgfunc").toString();
        }
        return viewType;
    }

    public static Map<String, List<String>> getTaxcParamAppIDs() {
        QFilter taxcFilter = new QFilter("bizcloud.number", "=", (Object)"TAXC");
        DynamicObject[] taxcApps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id", (QFilter[])taxcFilter.toArray());
        List appIDs = Stream.of(taxcApps).map(item -> item.getString("id")).collect(Collectors.toList());
        StringBuffer taxcParamFilter = new StringBuffer();
        taxcParamFilter.append('(');
        for (int i = 0; i < appIDs.size(); ++i) {
            taxcParamFilter.append('\'');
            taxcParamFilter.append((String)appIDs.get(i));
            taxcParamFilter.append('\'');
            if (i == appIDs.size() - 1) continue;
            taxcParamFilter.append(',');
        }
        taxcParamFilter.append(')');
        String sql = "select FID,FAPPID,FFORMID from t_bas_sysparaconsole where FENABLED ='1' and FAPPID in " + taxcParamFilter;
        DynamicObjectCollection taxcParamApps = SingleORM.query(null, (String)sql, null);
        ArrayList<String> taxcParamAppIDs = new ArrayList<String>();
        ArrayList<String> taxcParamFormIDs = new ArrayList<String>();
        ArrayList<String> taxcParamIDs = new ArrayList<String>();
        for (DynamicObject i : taxcParamApps) {
            String fappid = i.getString("FAPPID");
            String fformid = i.getString("FFORMID");
            String fid = i.getString("FID");
            taxcParamAppIDs.add(fappid);
            taxcParamFormIDs.add(fformid);
            taxcParamIDs.add(fid);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("taxcParamAppIDs", taxcParamAppIDs);
        map.put("taxcParamFormIDs", taxcParamFormIDs);
        map.put("taxcParamIDs", taxcParamIDs);
        return map;
    }

    public static Boolean isGroupControl(String formID, String paramKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formID);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        FieldProp prop = (FieldProp)properties.get((Object)paramKey);
        return prop.isGroupControl();
    }

    public static String getParamValue(DynamicObject param) {
        String val;
        DynamicObjectCollection values;
        String isMul = param.getString("paramname.ismultiple");
        if (EmptyCheckUtils.isEmpty(isMul)) {
            isMul = param.getString("ismultiple");
        }
        if (EmptyCheckUtils.isEmpty(values = param.getDynamicObjectCollection("paramvalue"))) {
            return null;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)isMul, (CharSequence)"1")) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(',');
            for (DynamicObject value : values) {
                buffer.append(value.getDynamicObject(1).getString("key"));
                buffer.append(',');
            }
            val = buffer.toString();
        } else {
            val = ((DynamicObject)values.get(0)).getDynamicObject(1).getString("key");
        }
        return val;
    }
}

