/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BaseInvoiceTypePlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bd_invoicetype".equals(args.getRefEntityId())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String invoiceType = (String)customParams.get("invoiceType");
            QFilter q = new QFilter("number", "in", Arrays.asList(invoiceType.split(",")));
            args.getCustomQFilters().add(q);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn column : args.getCommonFilterColumns()) {
            if (!"baseinvoicetype.name".equals(column.getFieldName())) continue;
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String invoiceType = String.valueOf(customParams.get("invoiceType"));
            if (!StringUtils.isNotBlank((CharSequence)invoiceType)) continue;
            QFilter q = new QFilter("number", "in", Arrays.asList(invoiceType.split(",")));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id", (QFilter[])new QFilter[]{q}, (String)"number");
            List comboItems = Arrays.stream(dynamicObjects).map(o -> {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(o.getString("name")));
                item.setValue(o.getString("id"));
                return item;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(comboItems) && comboItems.size() > 1) {
                Collections.swap(comboItems, 0, comboItems.size() - 1);
            }
            typeColumn.setComboItems(comboItems);
        }
    }
}

