/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.common.constant.CompareTypeAndValDto;
import kd.taxc.common.json.JsonUtil;
import kd.taxc.common.metadata.MetadataUtil;
import kd.taxc.common.metadata.domain.EntityField;
import kd.taxc.common.metadata.domain.EntityInfo;
import kd.taxc.common.util.StringUtil;
import kd.taxc.enums.InvoiceTypeEnum;

public class BillFilterOperPlugin
extends AbstractFormPlugin
implements BeforeFilterF7SelectListener {
    public static final String BillFilter_entityNumber = "entityNumber";
    public static final String BillFilter_entityId = "entityId";
    public static final String CustParamKey_FilterJson = "filterJson";
    public static final String KEY_FILTERDESCRIPTION = "filterdescription";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    private static final String Key_filtergridap = "filtergridap";
    private static final String BD_INVOICETYPE = "bd_invoicetype";
    private static final String BOS_ORG = "bos_org";
    private static final Set<String> ref_entity_ids = new HashSet<String>(){
        {
            this.add("bd_accountview");
        }
    };
    public static final String INVOICE_TYPE = "invoice_type";
    private static Map<String, String> replaceMap = new HashMap<String, String>();
    private static final Set<String> compareTypes_need_merge = new HashSet<String>(){
        {
            this.add(BillFilterOperPlugin.EQUEAL);
            this.add(BillFilterOperPlugin.NOT_EQUEAL);
            this.add(BillFilterOperPlugin.CONTAIN);
            this.add(BillFilterOperPlugin.NOT_CONTAIN);
            this.add(BillFilterOperPlugin.START_WITH);
            this.add(BillFilterOperPlugin.END_WITH);
        }
    };
    private static final Set<String> compareTypes_stay_same = new HashSet<String>(){
        {
            this.add(BillFilterOperPlugin.IN);
            this.add(BillFilterOperPlugin.NOT_IN);
        }
    };
    private static final Map<String, String> cnNameToSymbol = new LinkedHashMap<String, String>(){
        {
            this.put(BillFilterOperPlugin.getNotInCn(), BillFilterOperPlugin.NOT_IN);
            this.put(BillFilterOperPlugin.getInCn(), BillFilterOperPlugin.IN);
            this.put(BillFilterOperPlugin.getNotEqualCn(), BillFilterOperPlugin.NOT_EQUEAL);
            this.put(BillFilterOperPlugin.getEqualCn(), BillFilterOperPlugin.EQUEAL);
            this.put(BillFilterOperPlugin.getNotContainCn(), BillFilterOperPlugin.NOT_CONTAIN);
            this.put(BillFilterOperPlugin.getContainCn(), BillFilterOperPlugin.CONTAIN);
            this.put(BillFilterOperPlugin.getStartWithCn(), BillFilterOperPlugin.START_WITH);
            this.put(BillFilterOperPlugin.getEndWithCn(), BillFilterOperPlugin.END_WITH);
        }
    };
    private static final String EQUEAL = "67";
    private static final String NOT_EQUEAL = "83";
    private static final String IN = "17";
    private static final String NOT_IN = "34";
    private static final String START_WITH = "60";
    private static final String END_WITH = "211";
    private static final String CONTAIN = "59";
    private static final String NOT_CONTAIN = "58";
    private static final String PERCENT = "%";
    private static final String GL_VOUCHER = "gl_voucher";
    private static final String GL_BALANCE = "gl_balance";
    private static final String ACCOUNT_TYPE = "bd_accountbookstype";
    private static final String BOOK_TYPE_DEFAULT_VALUE = "1";
    private static final String STATUS_DEFAULT_VALUE = "C";
    private static final List<String> jsNumbers = Lists.newArrayList((Object[])new String[]{"701020601", "701020602", "701020603", "701020604", "701020605", "701020606", "701020607", "701020608", "701020609", "701020610", "701020611", "701020612", "701020613"});
    private static final List<String> suzclbNumber = Lists.newArrayList((Object[])new String[]{"701020101", "701020102", "701020103", "701020104", "701020105", "701020106", "701020201", "701020202", "701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308", "701020401", "701020402", "701020403", "701020404", "701020405", "701020501", "701020502"});

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldName = evt.getFieldName();
        HashMap hashMap = Maps.newHashMap();
        if ("jszjtxlx.number".equals(fieldName) || "jszjtxlx.name".equals(fieldName)) {
            Object entityNumber = this.getView().getFormShowParameter().getCustomParams().get(BillFilter_entityNumber);
            if ("tccit_tax_acce_diff".equals(entityNumber)) {
                hashMap.put("type", "acce");
            } else {
                hashMap.put("type", "zcajust");
                hashMap.put("ptNumbers", jsNumbers);
                hashMap.put("isSpeed", "yes");
            }
            evt.setCustomParams((Map)hashMap);
        }
        if ("taxassetstype.number".equals(fieldName) || "taxassetstype.name".equals(fieldName)) {
            hashMap.put("type", "zcajust");
            hashMap.put("suzclbNumber", suzclbNumber);
            evt.setCustomParams((Map)hashMap);
        }
        if (fieldName.endsWith("assettype.number") || fieldName.endsWith("assettype.projectname")) {
            hashMap.put("parentNum", BOOK_TYPE_DEFAULT_VALUE);
            evt.setCustomParams((Map)hashMap);
        } else if (fieldName.endsWith("investtype.number") || fieldName.endsWith("investtype.projectname")) {
            hashMap.put("parentNum", "2");
            evt.setCustomParams((Map)hashMap);
        } else if (fieldName.endsWith("transtype.number") || fieldName.endsWith("transtype.projectname")) {
            hashMap.put("parentNum", "3");
            hashMap.put("containParent", Boolean.TRUE);
            hashMap.put("caption", ResManager.loadKDString((String)"\u6295\u8d44\u8d44\u4ea7\u5904\u7f6e\u4ea4\u6613\u7c7b\u578b", (String)"BillFilterOperPlugin_0", (String)"taxc-tctb-common", (Object[])new Object[0]));
            evt.setCustomParams((Map)hashMap);
        }
        Object ruletype = this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if ("public".equals(ruletype) && "tdm_account".equals(evt.getRefEntityId())) {
            evt.setRefEntityId("tdm_account_summary");
        }
        if (BD_INVOICETYPE.equals(evt.getRefEntityId())) {
            QFilter q = new QFilter("number", "in", Arrays.asList(this.getPageCache().get(INVOICE_TYPE).split(",")));
            String no_special = (String)this.getView().getFormShowParameter().getCustomParam("NO_SPECIAL");
            if (Objects.equals(no_special, "true")) {
                q.and("number", "not in", Arrays.asList("2", "4"));
            }
            evt.addCustomQFilter(q);
        }
        this.addExtendFilter(evt, ruletype);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        int rowIndex = evt.getRowIndex();
        if (rowIndex > filteList.size()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u4e4b\u524d\u5b58\u5728\u914d\u7f6e\u884c\u672a\u914d\u7f6e\u6570\u636e\u7684\u60c5\u51b5\uff0c\u8bf7\u5148\u914d\u7f6e\u597d\u3002", (String)"BillFilterOperPlugin_1", (String)"taxc-tctb-common", (Object[])new Object[0]), rowIndex + 1));
            evt.setCancel(true);
        } else {
            SimpleFilterRow simpleFilterRow = null;
            try {
                simpleFilterRow = (SimpleFilterRow)filteList.get(rowIndex);
            }
            catch (Exception e2) {
                return;
            }
            List value = simpleFilterRow.getValue();
            QFilter q1 = new QFilter(evt.getRefPropKey(), "in", value.stream().map(FilterValue::getValue).collect(Collectors.toList()));
            QFilter q2 = null;
            String refEntityId = evt.getRefEntityId();
            if (!ref_entity_ids.contains(refEntityId)) {
                EntityInfo entityById = MetadataUtil.getEntityById(refEntityId);
                List<EntityField> fieldList = entityById.getFieldList();
                for (EntityField entityField : fieldList) {
                    if (!BOS_ORG.equals(entityField.getBaseEntityId())) continue;
                    String orgid = (String)this.getView().getFormShowParameter().getCustomParam("orgid");
                    q2 = new QFilter(entityField.getFieldId(), "=", (Object)Long.parseLong(orgid));
                    evt.addCustomQFilter(q2);
                    break;
                }
            }
            DynamicObjectCollection ids = QueryServiceHelper.query((String)refEntityId, (String)"id", (QFilter[])new QFilter[]{q1, q2});
            evt.setSelectedIds(ids.stream().map(e -> e.get("id")).toArray());
        }
    }

    private void addExtendFilter(BeforeFilterF7SelectEvent evt, Object ruletype) {
        if (ref_entity_ids.contains(evt.getRefEntityId())) {
            QFilter userQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("orgid")));
            evt.getCustomQFilters().add(userQfilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        this.getPageCache().put(INVOICE_TYPE, InvoiceTypeEnum.getEnumByEntityId(entityNumber));
        Long entityid = (Long)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityId);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        this.initFilterCondition(entityid, entityNumber);
        String filterJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_FilterJson);
        if ((GL_VOUCHER.equals(entityNumber) || GL_BALANCE.equals(entityNumber)) && StringUtils.isBlank((CharSequence)filterJson)) {
            FilterCondition filterCondition = new FilterCondition();
            ArrayList<SimpleFilterRow> filteList = new ArrayList<SimpleFilterRow>(2);
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)this.getMainBookId());
            filteList.add(new SimpleFilterRow("", EQUEAL, "booktype.number", "", "0", Collections.singletonList(filterValue)));
            if (GL_VOUCHER.equals(entityNumber)) {
                FilterValue filterValue1 = new FilterValue();
                filterValue1.setValue((Object)STATUS_DEFAULT_VALUE);
                filteList.add(new SimpleFilterRow("", "105", "billstatus", "", "0", Collections.singletonList(filterValue1)));
            }
            String modelType = "DynamicFormModel";
            DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
            DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
            binder.setWriteInheritFlag(true);
            filterCondition.setFilterRow(filteList);
            Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
            filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        }
        if (!StringUtils.isBlank((CharSequence)filterJson)) {
            this.setDataFilter(filterJson, entityNumber);
        }
    }

    private void initFilterCondition(Long entityid, String entityNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (GL_BALANCE.equals(entityNumber)) {
            ((DynamicProperty)entityType.getFields().get("org")).setAlias("forgid");
            ((DynamicProperty)entityType.getFields().get("booktype")).setAlias("fbooktypeid");
            ((DynamicProperty)entityType.getFields().get("period")).setAlias("FPERIODID");
            ((DynamicProperty)entityType.getFields().get("endperiod")).setAlias("FENDPERIODID");
            ((DynamicProperty)entityType.getFields().get("accounttable")).setAlias("faccounttableid");
            ((DynamicProperty)entityType.getFields().get("account")).setAlias("FACCOUNTID");
            ((DynamicProperty)entityType.getFields().get("assgrp")).setAlias("fassgrpid");
            ((DynamicProperty)entityType.getFields().get("currency")).setAlias("FCURRENCYID");
            ((DynamicProperty)entityType.getFields().get("measureunit")).setAlias("FMEASUREUNITID");
        }
        List list = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        QFilter tableid = new QFilter("tableid", "=", (Object)entityid);
        QFilter wherestate = new QFilter("wherestate", "=", (Object)BOOK_TYPE_DEFAULT_VALUE);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_datasource_entry", (String)"fieldname,bizsubname", (QFilter[])new QFilter[]{tableid, wherestate});
        ArrayList filterColumns = new ArrayList();
        list.parallelStream().forEach(filterColumn -> {
            String type = (String)filterColumn.get("type");
            String fieldName = (String)filterColumn.get("fieldName");
            dynamicObjects.parallelStream().forEach(dynamicObject -> {
                String bizsubname = dynamicObject.getString("bizsubname");
                if ("basedata".equals(type) || "enum".equals(type)) {
                    if (fieldName.equals(dynamicObject.getString("fieldname")) || fieldName.split("\\.").length == 2 && fieldName.split("\\.")[0].equals(dynamicObject.getString("fieldname"))) {
                        String oldCaption = (String)filterColumn.get("fieldCaption");
                        if (entityNumber.equals("tccit_invest_dispose")) {
                            String newCaption = fieldName.startsWith("transtype.") || fieldName.startsWith("assetlosstype.") ? oldCaption.split("\\.")[1] : oldCaption.split("\\.")[0];
                            boolean anyMatch = filterColumns.stream().anyMatch(s -> s.get("fieldCaption").equals(newCaption));
                            if (!anyMatch) {
                                filterColumn.put("fieldCaption", newCaption);
                                filterColumns.add(filterColumn);
                            }
                        } else {
                            if ("assetdata.assetclass".equals(filterColumn.get("fieldName")) || "assetdata.assetcode".equals(filterColumn.get("fieldName"))) {
                                return;
                            }
                            String newCaption = oldCaption.replace(".", "");
                            if (newCaption.startsWith(ResManager.loadKDString((String)"\u5206\u5f55\u4f53", (String)"BillFilterOperPlugin_2", (String)"taxc-tctb-common", (Object[])new Object[0])) || newCaption.startsWith(ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"BillFilterOperPlugin_3", (String)"taxc-tctb-common", (Object[])new Object[0]))) {
                                newCaption = newCaption.substring(3);
                            }
                            if (entityNumber.equals("sim_vatinvoice") && "taxrate".equals(dynamicObject.getString("fieldname"))) {
                                if (Objects.equals(this.getView().getFormShowParameter().getCustomParam("NO_TAXRATE"), "true")) {
                                    return;
                                }
                                newCaption = ResManager.loadKDString((String)"\u7a0e\u7387", (String)"BillFilterOperPlugin_4", (String)"taxc-tctb-common", (Object[])new Object[0]);
                            }
                            filterColumn.put("fieldCaption", newCaption);
                            replaceMap.put(oldCaption, newCaption);
                            filterColumns.add(filterColumn);
                        }
                    }
                } else if (fieldName.equals(dynamicObject.getString("fieldname"))) {
                    replaceMap.put((String)filterColumn.get("fieldCaption"), bizsubname);
                    filterColumn.put("fieldCaption", bizsubname);
                    if (fieldName.equals("assgrp") && (GL_VOUCHER.equals(entityNumber) || GL_BALANCE.equals(entityNumber))) {
                        ((List)filterColumn.get("compareTypes")).removeIf(dto -> !dto.getId().equals(CONTAIN) && !dto.getId().equals(NOT_CONTAIN));
                    }
                    if (fieldName.equals("swczsyss") && "tccit_invest_dispose".equals(entityNumber)) {
                        Map customParams = this.getView().getFormShowParameter().getCustomParams();
                        if (customParams.get("ruleCode").equals("RULE-CIT-HJ-SRTZ-TZZCCZSY")) {
                            ((List)filterColumn.get("items")).removeIf(s -> !s.getValue().equals(BOOK_TYPE_DEFAULT_VALUE));
                        } else if (customParams.get("ruleCode").equals("RULE-CIT-HJ-ZCTZ-ZCSS-01")) {
                            ((List)filterColumn.get("items")).removeIf(s -> !s.getValue().equals("2"));
                        }
                    }
                    filterColumns.add(filterColumn);
                }
            });
        });
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNumber);
        filterGrid.SetValue(fc);
        this.getView().updateView(Key_filtergridap);
    }

    private void setDataFilter(String dataFilter, String entityNumber) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        this.updateAssgrpToOrigin(filterCondition, entityNumber);
        filterGrid.SetValue(filterCondition);
    }

    private void updateAssgrpToOrigin(FilterCondition filterCondition, String entityNumber) {
        if (!GL_VOUCHER.equals(entityNumber) && !GL_BALANCE.equals(entityNumber)) {
            return;
        }
        String description = (String)this.getView().getFormShowParameter().getCustomParam("description");
        List<CompareTypeAndValDto> dtos = this.getCompareTypeAndValDtos(description, filterCondition.getFilterRow());
        int i = 0;
        for (SimpleFilterRow filterRow : filterCondition.getFilterRow()) {
            if (!"assgrp".equals(filterRow.getFieldName()) || i >= dtos.size()) continue;
            CompareTypeAndValDto dto = dtos.get(i);
            filterRow.setValue(dto.getValue());
            filterRow.setCompareType(dto.getCompareType());
            ++i;
        }
    }

    private List<CompareTypeAndValDto> getCompareTypeAndValDtos(String description, List<SimpleFilterRow> filterRows) {
        if (null == description) {
            return new ArrayList<CompareTypeAndValDto>();
        }
        LinkedList<CompareTypeAndValDto> result = new LinkedList<CompareTypeAndValDto>();
        String[] filterDescs = description.split(ResManager.loadKDString((String)"\u6216\u8005|\u5e76\u4e14", (String)"BillFilterOperPlugin_5", (String)"taxc-tctb-common", (Object[])new Object[0]));
        block0: for (int i = 0; i < filterDescs.length; ++i) {
            if (!filterDescs[i].contains(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"BillFilterOperPlugin_6", (String)"taxc-tctb-common", (Object[])new Object[0])) && !filterDescs[i].contains(ResManager.loadKDString((String)"\u6838\u7b97\u9879\u76ee", (String)"BillFilterOperPlugin_7", (String)"taxc-tctb-common", (Object[])new Object[0]))) continue;
            String desc = this.getTrimedDesc(filterDescs[i], filterRows.get(i));
            for (Map.Entry<String, String> entry : cnNameToSymbol.entrySet()) {
                if (!desc.contains(entry.getKey())) continue;
                String[] parts = desc.split(entry.getKey());
                if (parts.length != 2) continue block0;
                CompareTypeAndValDto dto = new CompareTypeAndValDto();
                dto.setCompareType(entry.getValue());
                ArrayList<FilterValue> filterValues = new ArrayList<FilterValue>();
                dto.setValue(filterValues);
                String input = parts[1].trim();
                if (input.contains(";") && (entry.getValue().equals(NOT_IN) || entry.getValue().equals(IN))) {
                    String[] vals;
                    for (String val : vals = input.split(";")) {
                        FilterValue filterValue = new FilterValue();
                        filterValue.setValue((Object)val);
                        filterValues.add(filterValue);
                    }
                } else {
                    FilterValue filterValue = new FilterValue();
                    filterValue.setValue((Object)input);
                    filterValues.add(filterValue);
                }
                result.add(dto);
                continue block0;
            }
        }
        return result;
    }

    private String getTrimedDesc(String filterDesc, SimpleFilterRow filterRow) {
        String leftBracket = filterRow.getLeftBracket();
        String rightBracket = filterRow.getRightBracket();
        filterDesc = filterDesc.trim();
        return filterDesc.substring(leftBracket.length(), filterDesc.length() - rightBracket.length()).trim();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        this.getView().returnDataToParent(ret);
        this.getView().close();
    }

    private Map<String, Object> getConfig() {
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(KEY_FILTER_VALUE, "");
        data.put(KEY_FILTERDESCRIPTION, "");
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        List filteList = filterCondition.getFilterRow();
        this.setDefaultFilter(filterGrid, filteList, errors);
        if (errors.size() != 0) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)((String)errors.get(0)), (String)"BillFilterOperPlugin_2", (String)"BillFilterOperPlugin_8", (Object[])new Object[0]));
        }
        if (filteList == null || filteList.isEmpty()) {
            return data;
        }
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(BillFilter_entityNumber);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        for (FilterRow f : filterBuilder.getFilterObject().getFilterRows()) {
            if (!f.getFilterField().getFieldName().equals("assgrp")) continue;
            f.getFilterField().setFieldType(-9);
        }
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        String filter = filterBuilder.getFilterObject().getFilter();
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(replaceMap.entrySet());
        entryList.sort((e1, e2) -> ((String)e2.getKey()).length() - ((String)e1.getKey()).length());
        for (Map.Entry entry : entryList) {
            String msg = ResManager.loadKDString((String)"\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b", (String)"BillFilterOperPlugin_9", (String)"taxc-tctb-common", (Object[])new Object[0]);
            if (filter.contains(msg)) {
                filter = filter.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                break;
            }
            filter = filter.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        replaceMap.clear();
        data.put(KEY_FILTER_VALUE, filterJson);
        data.put(KEY_FILTERDESCRIPTION, filter);
        return data;
    }

    private void setDefaultFilter(FilterGrid filterGrid, List<SimpleFilterRow> filteList, List<String> errors) {
        if (GL_VOUCHER.equals(filterGrid.getEntityNumber()) || GL_BALANCE.equals(filterGrid.getEntityNumber())) {
            FilterValue filterValue;
            boolean isSetBookType = false;
            boolean isSetBillStatus = false;
            for (SimpleFilterRow filterRow : filteList) {
                if (null == filterRow.getFieldName()) continue;
                if (filterRow.getFieldName().startsWith("booktype")) {
                    isSetBookType = true;
                    continue;
                }
                if (GL_VOUCHER.equals(filterGrid.getEntityNumber()) && filterRow.getFieldName().startsWith("billstatus")) {
                    isSetBillStatus = true;
                    continue;
                }
                if (!GL_BALANCE.equals(filterGrid.getEntityNumber()) && !GL_VOUCHER.equals(filterGrid.getEntityNumber()) || !filterRow.getFieldName().equals("assgrp")) continue;
                this.packageFilter(filterRow, errors);
            }
            if (!isSetBookType) {
                filterValue = new FilterValue();
                filterValue.setValue((Object)this.getMainBookId());
                filteList.add(new SimpleFilterRow("", EQUEAL, "booktype.number", "", "0", Collections.singletonList(filterValue)));
            }
            if (!isSetBillStatus && GL_VOUCHER.equals(filterGrid.getEntityNumber())) {
                filterValue = new FilterValue();
                filterValue.setValue((Object)STATUS_DEFAULT_VALUE);
                filteList.add(new SimpleFilterRow("", "105", "billstatus", "", "0", Collections.singletonList(filterValue)));
            }
        }
    }

    private String getMainBookId() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ACCOUNT_TYPE, (String)"number", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)BOOK_TYPE_DEFAULT_VALUE)});
        return null == dynamicObject ? null : dynamicObject.getString("number");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void packageFilter(SimpleFilterRow filterRow, List<String> errors) {
        String compareType = filterRow.getCompareType();
        if (!compareTypes_need_merge.contains(compareType) && !compareTypes_stay_same.contains(compareType)) {
            return;
        }
        List content = filterRow.getValue();
        ArrayList<FilterValue> cache = new ArrayList<FilterValue>();
        HashSet<String> oldCaptionSet = new HashSet<String>();
        StringBuilder values = new StringBuilder();
        Iterator iterator = content.iterator();
        block2: while (true) {
            if (!iterator.hasNext()) {
                if (oldCaptionSet.size() == 0) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\u3002", (String)"BillFilterOperPlugin_13", (String)"taxc-tctb-common", (Object[])new Object[0]));
                }
                return;
            }
            FilterValue filter = (FilterValue)iterator.next();
            String inputValue = (String)filter.getValue();
            String[] subAssgrp = inputValue.split(";");
            int index = 0;
            while (true) {
                String valusSource;
                if (index >= subAssgrp.length) continue block2;
                values.append(subAssgrp[index]).append(";");
                if (!subAssgrp[index].contains(":")) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"BillFilterOperPlugin_12", (String)"taxc-tctb-common", (Object[])new Object[0]));
                    return;
                }
                String[] assgrpAndDetail = subAssgrp[index].split(":");
                if (assgrpAndDetail.length != 2) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u6761\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\uff0c\u6b63\u786e\u683c\u5f0f\u5982:\u7269\u6599:\u6253\u5370\u673a.", (String)"BillFilterOperPlugin_12", (String)"taxc-tctb-common", (Object[])new Object[0]));
                    return;
                }
                String leftAssgrpName = assgrpAndDetail[0];
                String detailName = assgrpAndDetail[1];
                DynamicObject leftAssgrp = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield,valuesource,disprops,valuetype", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)leftAssgrpName)});
                if (null == leftAssgrp) {
                    filterRow.setValue(cache);
                    errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"BillFilterOperPlugin_10", (String)"taxc-tctb-common", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection rightAssgrp = null;
                String string = valusSource = leftAssgrp.getString("valuetype").equals("2") ? "bos_assistantdata_detail" : leftAssgrp.getString("valuesource");
                if (!StringUtil.isEmpty((CharSequence)valusSource)) {
                    block18: {
                        QFilter qFilter = this.getFilterByDisplayproperty(leftAssgrp.getString("disprops"), detailName);
                        try {
                            rightAssgrp = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            if (null != rightAssgrp && rightAssgrp.size() != 0) break block18;
                            if (qFilter.getProperty().equals("fullname")) {
                                qFilter = new QFilter("name", "=", (Object)detailName);
                                rightAssgrp = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                                break block18;
                            }
                            if (!qFilter.getProperty().equals("longnumber")) break block18;
                            String[] subs = detailName.split(",");
                            if (subs.length == 2) {
                                qFilter = new QFilter("number", "=", (Object)subs[0]);
                                rightAssgrp = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            } else {
                                qFilter = new QFilter("number", "=", (Object)detailName);
                                rightAssgrp = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                        }
                        catch (Throwable e) {
                            if (qFilter.getProperty().equals("fullname")) {
                                qFilter = new QFilter("name", "=", (Object)detailName);
                                rightAssgrp = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                            if (!qFilter.getProperty().equals("longnumber")) {
                                filterRow.setValue(cache);
                                errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u5de6\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a.", (String)"BillFilterOperPlugin_10", (String)"taxc-tctb-common", (Object[])new Object[0]));
                                return;
                            }
                            String[] subs = detailName.split(",");
                            if (subs.length == 2) {
                                qFilter = new QFilter("number", "=", (Object)subs[0]);
                                rightAssgrp = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                            }
                            qFilter = new QFilter("number", "=", (Object)detailName);
                            rightAssgrp = QueryServiceHelper.query((String)valusSource, (String)"id", (QFilter[])new QFilter[]{qFilter});
                        }
                    }
                    if (null == rightAssgrp || rightAssgrp.size() == 0) {
                        filterRow.setValue(cache);
                        errors.add(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6838\u7b97\u7ef4\u5ea6\u5192\u53f7\u53f3\u4fa7\u6761\u4ef6\u65e0\u5339\u914d\u503c\uff0c\u6838\u7b97\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u5df2\u7f6e\u7a7a\u3002", (String)"BillFilterOperPlugin_11", (String)"taxc-tctb-common", (Object[])new Object[0]));
                        return;
                    }
                }
                this.upDateCacheByAssgrpIds(rightAssgrp, leftAssgrp, CONTAIN, filterRow, detailName, oldCaptionSet, cache, index);
                ++index;
            }
            break;
        }
    }

    private void upDateCacheByAssgrpIds(DynamicObjectCollection rightAssgrp, DynamicObject leftAssgrp, String compareType, SimpleFilterRow filterRow, String detailName, Set<String> oldCaptionSet, List<FilterValue> cache, int index) {
        DynamicObjectCollection assgrpAssists;
        String Qcp = this.getQcp(filterRow, compareType);
        switch (leftAssgrp.getString("valuetype")) {
            case "1": 
            case "2": {
                LinkedHashMap<String, Long> queryJson = new LinkedHashMap<String, Long>();
                QFilter qFilter = null;
                if (null == rightAssgrp) {
                    return;
                }
                for (DynamicObject dynamicObject : rightAssgrp) {
                    queryJson.put(leftAssgrp.getString("flexfield"), dynamicObject.getLong("id"));
                    String tempJson = this.packageQueryJson(queryJson, compareType);
                    if (null == qFilter) {
                        qFilter = new QFilter("assvals", Qcp, (Object)tempJson);
                    } else {
                        qFilter.or(new QFilter("assvals", Qcp, (Object)tempJson));
                    }
                    queryJson.clear();
                }
                String propertyName = "id,assvals";
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist", (String)propertyName, (QFilter[])new QFilter[]{qFilter});
                List idList = rightAssgrp.stream().map(d -> d.getString("id")).collect(Collectors.toList());
                assgrpAssists = assgrpAssists.parallelStream().filter(a -> {
                    String assvals = a.getString("assvals");
                    String[] kvArray = assvals.substring(1, assvals.length() - 1).split(",");
                    for (int i = 0; i < kvArray.length; ++i) {
                        String s = kvArray[i].split(":")[1];
                        if (!idList.contains(s)) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toCollection(DynamicObjectCollection::new));
                break;
            }
            case "3": {
                QFilter nameFilter = new QFilter("asstype", Qcp, (Object)leftAssgrp.getString("flexfield"));
                QFilter valFilter = new QFilter("assval", Qcp, (Object)detailName);
                String propertyName = "hg as id";
                assgrpAssists = QueryServiceHelper.query((String)"gl_assist_txt", (String)propertyName, (QFilter[])new QFilter[]{nameFilter, valFilter});
                break;
            }
            default: {
                return;
            }
        }
        if (null != assgrpAssists && assgrpAssists.size() != 0) {
            HashSet<String> currentIds = new HashSet<String>();
            for (DynamicObject dynamicObject : assgrpAssists) {
                currentIds.add(String.valueOf(dynamicObject.getLong("id")));
            }
            if (index > 0) {
                oldCaptionSet.retainAll(currentIds);
            } else {
                oldCaptionSet.addAll(currentIds);
            }
        }
    }

    private QFilter getFilterByDisplayproperty(String displayproperty, String value) {
        String disprop;
        QFilter qFilter = new QFilter("fullname", "=", (Object)value);
        if (StringUtil.isEmpty((CharSequence)displayproperty)) {
            return qFilter;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)displayproperty, Map.class);
        if (null == map || null == map.get("disp") || null == ((Map)map.get("disp")).get("dispprop")) {
            return qFilter;
        }
        switch (disprop = (String)((Map)map.get("disp")).get("dispprop")) {
            case "1": {
                qFilter = new QFilter("longnumber", "=", (Object)value);
                break;
            }
            case "2": {
                qFilter = new QFilter("fullname", "=", (Object)value);
                break;
            }
            case "3": {
                String[] subs = value.split(",");
                if (subs.length != 2) break;
                qFilter = new QFilter("longnumber", "=", (Object)subs[0]);
            }
        }
        return qFilter;
    }

    private String packageQueryJson(Map<String, Long> map, String compareType) {
        String json = JsonUtil.toJson(map);
        if (START_WITH.equals(compareType)) {
            json = json.substring(0, json.length() - 1);
            return json + PERCENT;
        }
        if (END_WITH.equals(compareType)) {
            json = json.substring(1);
            return PERCENT + json;
        }
        if (CONTAIN.equals(compareType) || NOT_CONTAIN.equals(compareType)) {
            json = json.substring(1, json.length() - 1);
            return PERCENT + json + PERCENT;
        }
        return JsonUtil.toJson(map);
    }

    private String getQcp(SimpleFilterRow filterRow, String compareType) {
        switch (compareType) {
            case "17": {
                return "=";
            }
            case "34": {
                return "=";
            }
            case "67": {
                return "=";
            }
            case "83": {
                return "=";
            }
            case "58": {
                return "not like";
            }
            case "59": {
                return "like";
            }
            case "60": {
                return "like";
            }
            case "211": {
                return "like";
            }
        }
        return null;
    }

    private static String getEqualCn() {
        return ResManager.loadKDString((String)" \u7b49\u4e8e", (String)"BillFilterOperPlugin_14", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getNotEqualCn() {
        return ResManager.loadKDString((String)" \u4e0d\u7b49\u4e8e", (String)"BillFilterOperPlugin_15", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getContainCn() {
        return ResManager.loadKDString((String)" \u5305\u542b", (String)"BillFilterOperPlugin_16", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getNotContainCn() {
        return ResManager.loadKDString((String)" \u4e0d\u5305\u542b", (String)"BillFilterOperPlugin_17", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getStartWithCn() {
        return ResManager.loadKDString((String)" \u4ee5\u2026\u2026\u5f00\u59cb", (String)"BillFilterOperPlugin_18", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getEndWithCn() {
        return ResManager.loadKDString((String)" \u4ee5\u2026\u2026\u7ed3\u675f", (String)"BillFilterOperPlugin_19", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getInCn() {
        return ResManager.loadKDString((String)" \u5728\u2026\u2026\u4e2d", (String)"BillFilterOperPlugin_20", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getNotInCn() {
        return ResManager.loadKDString((String)" \u4e0d\u5728\u2026\u2026\u4e2d", (String)"BillFilterOperPlugin_21", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }
}

