/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.plugin;

import java.util.List;
import java.util.Map;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.common.util.PermissionUtils;

public class ReportOrgBeforeF7SelectPlugin
extends AbstractReportFormPlugin {
    private static final String[] EXCLUDE_FORMS = new String[]{"tcvat_invoice_identity", "tcvat_rollout_report", "tcvat_apportion_report", "tcvat_rollout_query", "tcvat_in_invoice_sign"};

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            HasPermOrgResult result = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (result == null || result.hasAllOrgPerm()) {
                return;
            }
            OrgUtils.addFilterByConditionBeforeF7Select(args, (IFormView)this.getView(), EXCLUDE_FORMS, null, null);
        }
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        this.initDefaultOrg(contInitEvent.getCommonFilterColumns());
    }

    private void initDefaultOrg(List<FilterColumn> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            CommonFilterColumn commFilter = (CommonFilterColumn)filters.get(i);
            String fieldName = commFilter.getFieldName();
            if (!"orgs".equals(fieldName) && !"orgid".equals(fieldName) && !"org".equals(fieldName)) continue;
            List<ComboItem> comboItemList = this.createComboItems();
            if (CollectionUtils.isEmpty(comboItemList)) {
                return;
            }
            commFilter.setComboItems(comboItemList);
            commFilter.setDefaultValue(comboItemList.get(0).getValue());
        }
    }

    private List<ComboItem> createComboItems() {
        List<Map<String, String>> orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), EXCLUDE_FORMS, null, null);
        return OrgUtils.getComboItems(orgList);
    }
}

