/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.plugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.common.dto.AdvanceConfDefaultDto;
import kd.taxc.common.dto.AdvanceConfDto;
import kd.taxc.common.service.RuleTemplateService;
import kd.taxc.common.util.StringUtil;

public class RuleTemplateNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String[] DISABLEBUTTON = new String[]{"name", "item", "entryentity", "itemchoicename", "fs_baseinfo"};
    private static final String[] INVISABLEBUTTON = new String[]{"bar_disable", "bar_save"};

    public void initialize() {
        BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield");
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        String parentform = this.getView().getFormShowParameter().getParentFormId();
        if (null != parentform && "tccit_yj_rule_query".equals(parentform)) {
            this.getView().setEnable(Boolean.valueOf(false), DISABLEBUTTON);
            this.getView().setVisible(Boolean.valueOf(false), INVISABLEBUTTON);
        }
        BasedataEdit tablefield = (BasedataEdit)this.getControl("table");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object ruletype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        if (!ObjectUtils.isEmpty(orgid)) {
            this.getModel().setValue("org", orgid);
        }
        if (null == (ruletype = customParams.get("ruletype"))) {
            this.getModel().setValue("ruletype", (Object)"private");
        } else {
            this.getModel().setValue("ruletype", ruletype);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            if (!"setting".equals(key) && !"setadvancedconf".equals(key)) {
                return;
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table", focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateNewPlugin_0", (String)"taxc-tctb-common", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long tableEntityId = tabletype.getLong("id");
            if ("setting".equals(key)) {
                String ischild = tabletype.getString("ischild");
                String entityNumber = tabletype.getString("name");
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY, KEY_CONDITIONJSON, "setting");
            }
            if ("setadvancedconf".equals(key)) {
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield", focusRow);
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson", focusRow);
                String datatype = (String)this.getModel().getValue("datatype", focusRow);
                BigDecimal vatrate = BigDecimal.ZERO;
                if (datatype.equals("jsflqs") || datatype.equals("cysldsqs")) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
                }
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate);
                RuleTemplateService.operationConfigClick(advanceConfDto, args, entryentity, amountfield, tableEntityId, this.getView(), focusRow, ENTRY_ENTITY, (IFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        super.closedCallBack(evt);
        if ("setting".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(KEY_FILTERCONDITION, filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, filterData.get("filtervalue"), currentRowIndex);
        }
        if ("setadvancedconf".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue("advancedconf", filterData.get("advancedconf"), currentRowIndex);
            this.getModel().setValue("advancedconfjson", filterData.get("advancedconfjson"), currentRowIndex);
            if (this.getModel().getValue("datatype", currentRowIndex).equals("jsflqs") || this.getModel().getValue("datatype", currentRowIndex).equals("cysldsqs")) {
                this.getModel().setValue("vatrate", filterData.get("vatrate"), currentRowIndex);
            }
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tctb_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object ruleType = this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        RuleTemplateService.setRuleConfig(evt, this.getModel(), this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (e.getProperty().getName().equals("table")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue("amountfield", null, rowIndex);
            this.getModel().setValue(KEY_FILTERCONDITION, null, rowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, null, rowIndex);
            this.getModel().setValue("absolute", (Object)Boolean.FALSE, rowIndex);
        } else if ("amountfield".equals(eventName)) {
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            BiPredicate<String, String> tdmBalance = RuleTemplateNewPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
            BiPredicate<String, String> glBalance = RuleTemplateNewPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
            if (tdmBalance.test(table, amountValue) || glBalance.test(table, amountValue)) {
                this.getModel().setValue("absolute", (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("absolute", (Object)Boolean.FALSE, rowIndex);
            }
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table", rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield", rowIndex);
            AdvanceConfDefaultDto dto = new AdvanceConfDefaultDto(this.getModel(), rowIndex, tabletype, amountfield, "advancedconf", "advancedconfjson");
            RuleTemplateService.setAdvanceConfDefaultValue(this.getModel(), rowIndex, tabletype, amountfield, "advancedconf", "advancedconfjson");
        } else if (eventName.equals("datatype")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            BigDecimal vatrate = BigDecimal.ZERO;
            String datatype = (String)e.getChangeSet()[0].getNewValue();
            if (!datatype.equals("jsflqs") && !datatype.equals("cysldsqs")) {
                this.getModel().setValue("vatrate", (Object)vatrate, rowIndex);
            }
        }
    }

    public static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }
}

