/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.plugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class SameNumberTreePlugin
extends TemplateTreePlugin {
    public void refreshNode(RefreshNodeEvent e) {
        String orgId = this.getPageCache().get("CACHE_DEFAULT_ORG");
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            TreeListModel source = (TreeListModel)e.getSource();
            source.getTreeFilter().add(new QFilter("org", "=", (Object)Long.parseLong(orgId)));
        }
    }

    public DynamicObjectCollection getChildrenDynamicObject(BeforeDoOperationEventArgs args, BasedataEntityType entityType) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        Object[] ids = new Object[listSelectedRowCollection.size()];
        for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
            ids[i] = listSelectedRowCollection.get(i).getPrimaryKeyValue();
        }
        return this.getChildrenDynamicObject(ids, entityType);
    }

    private DynamicObjectCollection getChildrenDynamicObject(Object[] ids, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty("longnumber") != null) {
            String entityName = entityType.getName();
            String selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
            String orderBy = "longnumber desc";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                if (dynamicObject.getString("longnumber") == null || "".equals(dynamicObject.getString("longnumber").trim())) continue;
                list.add(dynamicObject.getString("longnumber"));
            }
            selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
            QFilter baseQfilter = null;
            ParentBasedataProp parentProp = null;
            DataEntityPropertyCollection props = entityType.getProperties();
            for (Object[] prop : props) {
                if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
                parentProp = (ParentBasedataProp)prop;
                break;
            }
            String longNumberDLM = ".";
            if (parentProp != null) {
                longNumberDLM = parentProp.getLongNumberDLM();
            }
            for (Object id : ids) {
                if (baseQfilter == null) {
                    baseQfilter = new QFilter("id", "=", id);
                    continue;
                }
                baseQfilter.or(new QFilter("id", "=", id));
            }
            for (int i = 0; i < list.size(); ++i) {
                if (baseQfilter == null) {
                    baseQfilter = new QFilter("longnumber", "like", (Object)((String)list.get(i) + longNumberDLM + "%"));
                    continue;
                }
                baseQfilter.or(new QFilter("longnumber", "like", (Object)((String)list.get(i) + longNumberDLM + "%")));
            }
            if (baseQfilter == null) {
                return collection;
            }
            String orgId = this.getPageCache().get("CACHE_DEFAULT_ORG");
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                return orm.query(entityName, selectFields, new QFilter[]{baseQfilter, new QFilter("org", "=", (Object)Long.parseLong(orgId))}, orderBy);
            }
            return orm.query(entityName, selectFields, new QFilter[]{baseQfilter}, orderBy);
        }
        return null;
    }
}

