/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.taxc.enums.RuleConfigEnum;

public class TctbAdvanceConfForm
extends AbstractFormPlugin {
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    public static final String ADVANCED_CONF = "advancedconf";
    public static final String ADVANCED_CONF_JSON = "advancedconfjson";
    public static final String ADVANCED_CONF_DATA = "advancedConfData";
    public static final String ADVANCED_CONF_VALUE = "advancedConfValue";
    public static final String DATA_TYPE = "datatype";
    public static final String VATRATE = "vatrate";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String data = (String)customParams.get(ADVANCED_CONF_DATA);
        String[] itemStr = data.split(",");
        ArrayList<ComboItem> selctItem = new ArrayList<ComboItem>();
        for (int i = 0; i < itemStr.length; ++i) {
            if (!StringUtils.isNotEmpty((String)itemStr[i])) continue;
            selctItem.add(new ComboItem(new LocaleString(RuleConfigEnum.getRuleConfigName(itemStr[i])), itemStr[i]));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        comboEdit.setComboItems(selctItem);
        String value = (String)customParams.get(ADVANCED_CONF_VALUE);
        String dataType = (String)customParams.get(DATA_TYPE);
        boolean vatrateVisible = false;
        BigDecimal vatrateValue = BigDecimal.ZERO;
        this.getModel().setValue("combofield", (Object)new ComboItem(new LocaleString(RuleConfigEnum.getRuleConfigName(value)), value).getValue());
        if (null != dataType && (dataType.equals("jsflqs") || dataType.equals("cysldsqs"))) {
            vatrateVisible = true;
            vatrateValue = new BigDecimal(customParams.get(VATRATE).toString());
        }
        this.getModel().setValue(VATRATE, (Object)vatrateValue);
        this.getView().setVisible(Boolean.valueOf(vatrateVisible), new String[]{VATRATE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        }
        if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        Map<String, Object> ret = this.getConfig();
        this.getView().returnDataToParent(ret);
        this.getView().close();
    }

    private Map<String, Object> getConfig() {
        String combofield = (String)this.getModel().getValue("combofield");
        BigDecimal vatrate = (BigDecimal)this.getModel().getValue(VATRATE);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(ADVANCED_CONF, RuleConfigEnum.getRuleConfigName(combofield));
        data.put(ADVANCED_CONF_JSON, combofield);
        data.put(VATRATE, vatrate);
        return data;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String combofield = (String)this.getModel().getValue("combofield");
        if (StringUtils.isBlank((String)combofield)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u6570\u903b\u8f91", (String)"TctbAdvanceConfForm_0", (String)"taxc-tctb-common", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            super.beforeClosed(e);
        }
    }
}

