/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.threadpools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.taxc.common.threadpools.Task;

public class ThreadPoolsService {
    private static Log logger = LogFactory.getLog(ThreadPoolsService.class);
    private static ThreadPoolsService threadPoolsService = new ThreadPoolsService();
    private static ExecutorService dispatch = ThreadPools.newExecutorService((String)"threadPoolsService-dispatch", (int)20);
    private static ExecutorService ex = ThreadPools.newExecutorService((String)"threadPoolsService", (int)40);

    private ThreadPoolsService() {
    }

    public static ThreadPoolsService getInstance() {
        return threadPoolsService;
    }

    public Future<Integer> submitFutrue(Task call) {
        long time = System.currentTimeMillis();
        Future<Integer> future = dispatch.submit(new ExecutorTaskInteger(RequestContext.getOrCreate(), ex, call));
        logger.info("\u6267\u884c\u4efb\u52a1\u82b1\u8d39\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return future;
    }

    public Future<Object> submitFutrue(Callable call) {
        long time = System.currentTimeMillis();
        Future<Object> future = dispatch.submit(new SingleExecutorTask(RequestContext.getOrCreate(), ex, call));
        logger.info("\u6267\u884c\u4efb\u52a1\u82b1\u8d39\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return future;
    }

    public boolean submit(Task call) {
        long time = System.currentTimeMillis();
        Future<Boolean> future = dispatch.submit(new ExecutorTask(RequestContext.getOrCreate(), ex, call));
        try {
            future.get();
        }
        catch (Exception e) {
            logger.error("ThreadPoolsService submit", (Throwable)e);
        }
        logger.info("\u6267\u884c\u4efb\u52a1\u82b1\u8d39\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return true;
    }

    public boolean submitAsync(Task call) {
        dispatch.submit(new ExecutorTask(RequestContext.getOrCreate(), ex, call));
        return true;
    }

    public List<Future<Object>> submitReturnFuture(Task call) {
        Future future = dispatch.submit(new FutureTask(RequestContext.getOrCreate(), ex, call));
        try {
            return (List)future.get();
        }
        catch (Exception e) {
            logger.error("ThreadPoolsService submit", (Throwable)e);
            return new ArrayList<Future<Object>>();
        }
    }

    public Future<Future<Map<String, Object>>> submitCountFuture(Task call) {
        logger.info("\u7ebf\u7a0b\u5f00\u59cb\u6267\u884c:" + Thread.currentThread().getName());
        long time = System.currentTimeMillis();
        Future<Future<Map<String, Object>>> future = dispatch.submit(new ExecutorTaskCount(RequestContext.getOrCreate(), ex, call));
        logger.info("\u7ebf\u7a0b\u7ed3\u675f\u6267\u884c:" + Thread.currentThread().getName());
        logger.info("\u6267\u884c\u4efb\u52a1\u82b1\u8d39\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return future;
    }

    static class ExecutorTaskCount
    implements Callable<Future<Map<String, Object>>> {
        private RequestContext rc;
        protected ExecutorService ex;
        private Task call;

        public ExecutorTaskCount(RequestContext rc, ExecutorService ex, Task call) {
            this.ex = ex;
            this.rc = rc;
            this.call = call;
        }

        @Override
        public Future<Map<String, Object>> call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.rc);
            Future<Object> resultFuture = this.ex.submit(this.call.call(this.rc, null));
            return resultFuture;
        }
    }

    static class FutureTask<T>
    implements Callable<List<Future<T>>> {
        private RequestContext rc;
        protected ExecutorService ex;
        private Task<T> call;

        public FutureTask(RequestContext rc, ExecutorService ex, Task<T> call) {
            this.ex = ex;
            this.rc = rc;
            this.call = call;
        }

        @Override
        public List<Future<T>> call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.rc);
            List<T> values = this.call.getValue();
            ArrayList<Future<T>> list = new ArrayList<Future<T>>(values.size());
            for (T object : values) {
                list.add(this.ex.submit(this.call.call(this.rc, object)));
            }
            return list;
        }
    }

    static class SingleExecutorTask
    implements Callable<Object> {
        private RequestContext rc;
        protected ExecutorService ex;
        private Callable call;

        public SingleExecutorTask(RequestContext rc, ExecutorService ex, Callable call) {
            this.ex = ex;
            this.rc = rc;
            this.call = call;
        }

        @Override
        public Object call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.rc);
            Future f = this.ex.submit(this.call);
            Object object = f.get(5000L, TimeUnit.SECONDS);
            return object;
        }
    }

    static class ExecutorTask
    implements Callable<Boolean> {
        private RequestContext rc;
        protected ExecutorService ex;
        private Task call;

        public ExecutorTask(RequestContext rc, ExecutorService ex, Task call) {
            this.ex = ex;
            this.rc = rc;
            this.call = call;
        }

        @Override
        public Boolean call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.rc);
            List values = this.call.getValue();
            ArrayList list = new ArrayList(values.size());
            for (Object t : values) {
                list.add(this.ex.submit(this.call.call(this.rc, t)));
            }
            for (Future future : list) {
                future.get(5000L, TimeUnit.SECONDS);
            }
            return Boolean.TRUE;
        }
    }

    static class ExecutorTaskInteger
    implements Callable<Integer> {
        private RequestContext rc;
        protected ExecutorService ex;
        private Task call;

        public ExecutorTaskInteger(RequestContext rc, ExecutorService ex, Task call) {
            this.ex = ex;
            this.rc = rc;
            this.call = call;
        }

        @Override
        public Integer call() throws Exception {
            RequestContext.copyAndSet((RequestContext)this.rc);
            List values = this.call.getValue();
            ArrayList list = new ArrayList(values.size());
            for (Object object : values) {
                list.add(this.ex.submit(this.call.call(this.rc, object)));
            }
            Integer size = 0;
            for (Future future : list) {
                List resList = (List)future.get(5000L, TimeUnit.SECONDS);
                if (CollectionUtils.isEmpty((Collection)resList)) continue;
                size = size + resList.size();
            }
            return size;
        }
    }
}

