/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.util;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.taxc.common.util.EmptyCheckUtils;

public class BeanCopyUtils {
    public static void copyDynamicObject(DynamicObject source, DynamicObject target) {
        DynamicObjectType dynamicObjectType = source.getDynamicObjectType();
        DataEntityPropertyCollection dataEntityProperties = dynamicObjectType.getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            String propertyName = dataEntityProperty.getName();
            if (dataEntityProperty instanceof EntryProp) {
                DataEntityPropertyCollection subproperties = ((EntryProp)dataEntityProperty).getDynamicCollectionItemPropertyType().getProperties();
                DynamicObjectCollection sourceEntryentity = source.getDynamicObjectCollection(propertyName);
                DynamicObjectCollection targetEntryentity = target.getDynamicObjectCollection(propertyName);
                for (DynamicObject sourceEntry : sourceEntryentity) {
                    DynamicObject targetEntry = targetEntryentity.addNew();
                    for (IDataEntityProperty subproperty : subproperties) {
                        targetEntry.set(subproperty.getName(), sourceEntry.get(subproperty.getName()));
                    }
                }
                continue;
            }
            target.set(propertyName, source.get(propertyName));
        }
    }

    public static void copyDynamicObjectWithoutEntityid(DynamicObject source, DynamicObject target) {
        BeanCopyUtils.copyDynamicObjectWithoutEntityid(source, target, Arrays.asList("pkid", "id"));
    }

    public static void copyDynamicObjectWithoutEntityid(DynamicObject source, DynamicObject target, List<String> excludeFields) {
        DynamicObjectType dynamicObjectType = source.getDynamicObjectType();
        DataEntityPropertyCollection dataEntityProperties = dynamicObjectType.getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            if (BeanCopyUtils.isExcludeField(excludeFields, dataEntityProperty.getName())) continue;
            if (dataEntityProperty instanceof MulBasedataProp) {
                DynamicObjectCollection sourceSubList = source.getDynamicObjectCollection(dataEntityProperty.getName());
                if (EmptyCheckUtils.isEmpty(sourceSubList)) continue;
                DynamicObjectCollection targetSubList = target.getDynamicObjectCollection(dataEntityProperty.getName());
                for (DynamicObject sourceSubDynamicObject : sourceSubList) {
                    DynamicObject targetSubDynamicObject = targetSubList.addNew();
                    BeanCopyUtils.copyDynamicObjectWithoutEntityid(sourceSubDynamicObject, targetSubDynamicObject);
                }
                continue;
            }
            target.set(dataEntityProperty.getName(), source.get(dataEntityProperty.getName()));
        }
    }

    private static boolean isExcludeField(List<String> excludeFields, String name) {
        for (String excludeField : excludeFields) {
            if (!name.equalsIgnoreCase(excludeField)) continue;
            return true;
        }
        return false;
    }
}

