/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.util;

import java.io.Reader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import oracle.sql.CLOB;

public class DBUtils {
    private static final String DBKEY = "taxc";

    public static List<Map<String, Object>> query(String sql) {
        return DBUtils.query(DBKEY, sql);
    }

    public static List<Map<String, Object>> query(String sql, Object[] params) {
        return DBUtils.query(DBKEY, sql, params);
    }

    public static List<Map<String, Object>> query(String dbKey, String sql, Object[] params) {
        List list = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                while (rs.next()) {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    for (int i = 0; i < columnCount; ++i) {
                        String columnName = rsmd.getColumnName(i + 1);
                        Object columnValue = rs.getObject(columnName);
                        if (columnValue instanceof CLOB) {
                            hm.put(columnName.toUpperCase(), DBUtils.readOracleClob((CLOB)columnValue));
                            continue;
                        }
                        hm.put(columnName.toUpperCase(), columnValue);
                    }
                    list.add(hm);
                }
                return list;
            }
        });
        return list;
    }

    public static List<Map<String, Object>> query(String dbKey, String sql) {
        List list = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                while (rs.next()) {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    for (int i = 0; i < columnCount; ++i) {
                        String columnName = rsmd.getColumnName(i + 1);
                        Object columnValue = rs.getObject(columnName);
                        if (columnValue instanceof CLOB) {
                            hm.put(columnName.toUpperCase(), DBUtils.readOracleClob((CLOB)columnValue));
                            continue;
                        }
                        hm.put(columnName.toUpperCase(), columnValue);
                    }
                    list.add(hm);
                }
                return list;
            }
        });
        return list;
    }

    private static String readOracleClob(CLOB clob) throws Exception {
        int len;
        Reader reader = clob.getCharacterStream();
        StringBuilder buff = new StringBuilder();
        int blockSize = 1024;
        char[] block = new char[blockSize];
        do {
            len = reader.read(block);
            if (len <= 0) continue;
            buff.append(block, 0, len);
        } while (len == blockSize);
        return buff.toString();
    }

    public static boolean execute(String sql) {
        return DB.execute((DBRoute)DBRoute.of((String)DBKEY), (String)sql);
    }

    public static long getLongId(String tableName) {
        return DB.genLongId((String)tableName);
    }

    public static long[] getLongIds(String tableName, int count) {
        return DB.genLongIds((String)tableName, (int)count);
    }

    public static int[] executeBatch(String dbKey, String sql, List<Object[]> paramList) {
        return DB.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)sql, paramList);
    }

    public static int[] executeBatch(String sql, List<Object[]> paramList) {
        return DBUtils.executeBatch(DBKEY, sql, paramList);
    }
}

