/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.util;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;

public class DynamicObjectUtils {
    public static boolean isValueChange(DynamicObject oldObj, DynamicObject newObj, List<String> excludeFields) {
        DynamicObjectType dynamicObjectType = oldObj.getDynamicObjectType();
        DataEntityPropertyCollection dataEntityProperties = dynamicObjectType.getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            String propertyName = dataEntityProperty.getName();
            if (DynamicObjectUtils.isExcludeField(excludeFields, propertyName)) continue;
            if (dataEntityProperty instanceof EntryProp) {
                DynamicObjectCollection oldEntryEntity = oldObj.getDynamicObjectCollection(propertyName);
                DynamicObjectCollection newEntryEntity = newObj.getDynamicObjectCollection(propertyName);
                if (oldEntryEntity == null && newEntryEntity == null) continue;
                if (oldEntryEntity == null || newEntryEntity == null) {
                    return true;
                }
                if (oldEntryEntity.size() != newEntryEntity.size()) {
                    return true;
                }
                DynamicObject oldEntry = null;
                DynamicObject newEntry = null;
                int size = oldEntryEntity.size();
                for (int i = 0; i < size; ++i) {
                    oldEntry = (DynamicObject)oldEntryEntity.get(i);
                    if (!DynamicObjectUtils.isValueChange(oldEntry, newEntry = (DynamicObject)newEntryEntity.get(i), excludeFields)) continue;
                    return true;
                }
                continue;
            }
            if (dataEntityProperty instanceof MulBasedataProp) {
                DynamicObjectCollection oldBaseDataColl = oldObj.getDynamicObjectCollection(dataEntityProperty.getName());
                DynamicObjectCollection newBaseDataColl = newObj.getDynamicObjectCollection(dataEntityProperty.getName());
                if (oldBaseDataColl == null && newBaseDataColl == null) continue;
                if (oldBaseDataColl == null || newBaseDataColl == null) {
                    return true;
                }
                if (oldBaseDataColl.size() != newBaseDataColl.size()) {
                    return true;
                }
                List oldList = oldBaseDataColl.stream().map(x -> x.getString("fbasedataid_id")).collect(Collectors.toList());
                List newList = newBaseDataColl.stream().map(x -> x.getString("fbasedataid_id")).collect(Collectors.toList());
                oldList.retainAll(newList);
                if (oldList.size() == newList.size()) continue;
                return true;
            }
            if (DynamicObjectUtils.isEquals(oldObj.get(dataEntityProperty.getName()), newObj.get(dataEntityProperty.getName()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            if (obj2 == null && obj1 instanceof String) {
                return StringUtils.isBlank((Object)obj1);
            }
            if (obj1 == null && obj2 instanceof String) {
                return StringUtils.isBlank((Object)obj2);
            }
            return false;
        }
        if (obj1.getClass().equals(obj2.getClass())) {
            if (obj1 instanceof BigDecimal) {
                return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
            }
            if (obj1 instanceof DynamicObject) {
                return ((DynamicObject)obj1).getPkValue().equals(((DynamicObject)obj2).getPkValue());
            }
            return obj1.equals(obj2);
        }
        return false;
    }

    private static boolean isExcludeField(List<String> excludeFields, String name) {
        for (String excludeField : excludeFields) {
            if (!name.equalsIgnoreCase(excludeField)) continue;
            return true;
        }
        return false;
    }
}

