/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.session.EncreptSessionUtils;

public class FileUploadUtils {
    private static final Log logger = LogFactory.getLog(FileUploadUtils.class);

    public static String upload(String storePath, String fileName, InputStream in) {
        logger.info("fileName:" + fileName);
        fileName = fileName.replaceAll("\\\\", "/");
        int index = -1;
        index = fileName.lastIndexOf(47);
        if (index != -1) {
            fileName = fileName.substring(index + 1);
        }
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            FileItem fileItem = new FileItem(fileName, storePath, in);
            fileService.delete(storePath);
            return fileService.upload(fileItem);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + storePath, (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static void uploadAttachment(String fileName, InputStream in, String formId, Object pkId, String appId) {
        logger.info("fileName:" + fileName);
        try {
            int size = in.available();
            fileName = fileName.replaceAll("\\\\", "/");
            int index = -1;
            index = fileName.lastIndexOf(47);
            if (index != -1) {
                fileName = fileName.substring(index + 1);
            }
            String tempUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 5000);
            tempUrl = RequestContext.getOrCreate().getClientFullContextPath() + EncreptSessionUtils.encryptSession((String)tempUrl);
            HashMap attachmentMap = new HashMap();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", fileName);
            map.put("size", size);
            map.put("status", "success");
            map.put("uid", DB.genStringId((String)"bos_attachment"));
            map.put("url", tempUrl);
            map.put("entityNum", formId);
            map.put("client", "web");
            map.put("endProgress", true);
            attachmentMap.put("attachmentpanel", Collections.singletonList(map));
            AttachmentServiceHelper.saveTempAttachments((String)formId, (Object)pkId, (String)appId, attachmentMap);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
    }

    public static List<String> getFilePaths(String formId, List<Object> pkIds, String attachKey, boolean enableTempAccess) {
        ArrayList<String> urls = new ArrayList<String>();
        for (Object pkId : pkIds) {
            List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey, (boolean)enableTempAccess);
            for (Map map : attachments) {
                urls.add((String)map.get("url"));
            }
        }
        return urls;
    }
}

