/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.common.showpage.PageShowCommon;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.TreeUtils;

public class OrgUtils {
    private static Comparator<Object> CHINA_COMPARATOR;
    private static final boolean DISABLED_FILTER = true;
    public static final String FORM_ORG_GROUP = "tctb_org_group_latest";
    public static final String TCCIT_NSSB_POLICY = "tccit_seasonal_policy";
    public static final String FORM_ORG = "tctb_org_entity";
    public static final String FORM_ORG_GROUP_ENTRY = "orgrow";
    private static final String FIELD_EFFECTDATE = "effectdate";
    private static final String FIELD_INVALIDDATE = "invaliddate";
    public static final Set<String> MUST_IS_TAXPAYER;
    private static final String BASTAX_TAXORG = "bastax_taxorg";

    public static Boolean checkOrgDeclaration(Long orgid, Date startDate, Date endDate, String declaration) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter summaryorgtype = new QFilter("summaryorgtype", "=", (Object)"1");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q3 = new QFilter("orgrow.declaration", "=", (Object)declaration);
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        return QueryServiceHelper.exists((String)FORM_ORG_GROUP, (QFilter[])new QFilter[]{statusFilter, summaryorgtype, q1, q2, q3, q4, q5});
    }

    public static DynamicObject getOrgDeclarePlan(Long orgid, Date startDate, Date endDate) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q4 = new QFilter(FIELD_EFFECTDATE, "<=", (Object)startDate);
        QFilter q5 = new QFilter(FIELD_INVALIDDATE, "is null", null).or(new QFilter(FIELD_INVALIDDATE, ">=", (Object)endDate));
        QFilter q6 = new QFilter("status", "=", (Object)"2");
        return BusinessDataServiceHelper.loadSingle((String)FORM_ORG_GROUP, (String)"id, summaryorgtype, summaryway,orgrow.orgid,orgrow.orgname,orgrow.declaration", (QFilter[])new QFilter[]{statusFilter, q1, q2, q4, q5, q6});
    }

    public static StringBuilder getfzybqyMessage(String orgid, String skssqq, String skssqz, StringBuilder message) {
        DynamicObject orgDeclarePlan = OrgUtils.getOrgDeclarePlan(Long.valueOf(orgid), DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz));
        if (null == orgDeclarePlan) {
            return message;
        }
        DynamicObjectCollection orgrow = orgDeclarePlan.getDynamicObjectCollection(FORM_ORG_GROUP_ENTRY);
        String declareType = null;
        String hzOrgName = "";
        String currentOrgName = "";
        for (DynamicObject object : orgrow) {
            if (orgid.equals(object.getDynamicObject("orgid").getString("id"))) {
                declareType = object.getString("declaration");
                currentOrgName = object.getString("orgname");
            }
            if (!"2".equals(object.getString("declaration"))) continue;
            hzOrgName = object.getString("orgname");
        }
        if ("3".equals(declareType)) {
            message.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"OrgUtils_0", (String)"taxc-tctb-common", (Object[])new Object[0]), currentOrgName, hzOrgName)).append("\r\n");
        }
        return message;
    }

    public static void buildOrgGroupDetailTree(IFormView view, TreeView treeView, IPageCache pageCache, String type) {
        OrgUtils.buildOrgGroupDetailTree(view, treeView, pageCache, Boolean.TRUE, type);
    }

    public static void buildOrgGroupDetailTree(IFormView view, TreeView treeView, IPageCache pageCache, Boolean checkFirst, String type) {
        List<TreeNode> nodeList = OrgUtils.getOrgGroupAllNodeList(type);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            ArrayList<TreeNode> nodeList2 = new ArrayList<TreeNode>();
            for (TreeNode node : nodeList) {
                if (!hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(node.getId()))) continue;
                nodeList2.add(node);
            }
            if (nodeList.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u57fa\u7840\u8d44\u6599>\u7a0e\u52a1\u7ec4\u7ec7\u201d\u4e2d\u5bfc\u5165\u7ec4\u7ec7\u3002", (String)"OrgUtils_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
            }
            if (!nodeList.isEmpty() && nodeList2.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u7ec4\u7ec7\u6388\u6743", (String)"OrgUtils_2", (String)"taxc-tctb-common", (Object[])new Object[0]));
            }
            TreeUtils.build(treeView, nodeList2, pageCache, true);
        } else {
            TreeUtils.build(treeView, nodeList, pageCache, true);
        }
        if (checkFirst.booleanValue()) {
            TreeUtils.checkFirstNode(pageCache, treeView);
        }
    }

    public static void buildOrgTree(IFormView view, TreeView treeView, IPageCache pageCache) {
        List<TreeNode> nodeList = OrgUtils.getOrgNodeList();
        if (nodeList.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u201c\u57fa\u7840\u8d44\u6599>\u7a0e\u52a1\u7ec4\u7ec7\u201d\u4e2d\u5bfc\u5165\u7ec4\u7ec7\u3002", (String)"OrgUtils_1", (String)"taxc-tctb-common", (Object[])new Object[0]));
        }
        TreeUtils.build(treeView, nodeList, pageCache, true);
    }

    public static List<TreeNode> getOrgNodeList() {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = TreeUtils.getOrgLists();
        if (collection != null) {
            for (DynamicObject entry : collection) {
                String orgId = entry.getString("id");
                String orgName = entry.getString("name");
                String parentid = entry.getString("parentid");
                String status = entry.getString("status");
                TreeNode leftRoot = new TreeNode();
                leftRoot.setParentid(parentid);
                leftRoot.setId(orgId);
                leftRoot.setText(orgName);
                leftRoot.setType(status);
                HashMap<String, String> data = new HashMap<String, String>(8);
                data.put("number", entry.getString("number").toLowerCase());
                leftRoot.setData(data);
                nodeList.add(leftRoot);
            }
        }
        return nodeList;
    }

    public static List<TreeNode> getAllPermNodes(String appNumber, String entityId, String type) {
        List<TreeNode> nodeList = OrgUtils.getOrgGroupAllNodeList(type);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(appNumber, entityId, "47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            ArrayList<TreeNode> nodeList2 = new ArrayList<TreeNode>();
            for (TreeNode node : nodeList) {
                if (!hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(node.getId()))) continue;
                nodeList2.add(node);
            }
            return nodeList2;
        }
        return nodeList;
    }

    public static List<TreeNode> getOrgGroupAllNodeList(String type) {
        List<TreeNode> nodeList = OrgUtils.getOrgGroupDetailNodeList(type);
        Map<String, String> orgMap = OrgUtils.queryOrgMap();
        for (TreeNode node : nodeList) {
            if ("2".endsWith(node.getType())) continue;
            orgMap.remove(node.getId());
        }
        ArrayList<TreeNode> nodeList2 = new ArrayList<TreeNode>(orgMap.size());
        for (Map.Entry<String, String> entry : orgMap.entrySet()) {
            TreeNode node = new TreeNode();
            node.setId(entry.getKey());
            node.setText(entry.getValue());
            nodeList2.add(node);
        }
        return nodeList2;
    }

    public static List<TreeNode> getOrgGroupDetailNodeList(String type) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = OrgUtils.queryOrgGroupDetailList(type);
        if (collection != null) {
            for (DynamicObject entry : collection) {
                String orgId = entry.getString("orgid");
                String orgName = entry.getString("orgname");
                String parentid = entry.getString("parentid");
                String declaration = entry.getString("declaration");
                TreeNode leftRoot = new TreeNode();
                leftRoot.setParentid(parentid);
                leftRoot.setId(orgId);
                leftRoot.setText(orgName);
                leftRoot.setType(declaration);
                nodeList.add(leftRoot);
            }
        }
        return nodeList;
    }

    public static DynamicObjectCollection queryOrgGroupDetailList(String type) {
        String fields = "id,status,number,name,orgrow.orgid as orgid,orgrow.orgcode as orgcode,orgrow.orgname as orgname,orgrow.parentid as parentid,orgrow.declaration as declaration";
        Date now = new Date();
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter filteType = new QFilter("taxtype", "=", (Object)type);
        QFilter[] filters = new QFilter[]{statusFilter, filteType, OrgUtils.getQFilter(now)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)fields, (QFilter[])filters);
        return collection;
    }

    public static DynamicObjectCollection queryOrgGroupDetailForCollected(String type) {
        String fields = "orgrow.orgid as orgid";
        Date now = new Date();
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter declaration = new QFilter("orgrow.declaration", "=", (Object)"3");
        QFilter[] filters = new QFilter[]{statusFilter, typeFilter, declaration, OrgUtils.getQFilter(now)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)fields, (QFilter[])filters);
        return collection;
    }

    public static DynamicObjectCollection queryOrgGroupDetailForCollectedOrg(String type, String orgid, String enddate) {
        String fields = "orgrow.orgid as orgid, orgrow.declaration as declaration";
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter collectorg = new QFilter("orgrow.collectorg", "=", (Object)orgid);
        QFilter[] filters = new QFilter[]{statusFilter, typeFilter, collectorg, OrgUtils.getQFilter(DateUtils.stringToDate(enddate))};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)fields, (QFilter[])filters, (String)"orgrow.declaration asc");
        return collection;
    }

    public static String queryOrgGroupDetailForAggregator(String type, String shareid, String orgid, Date startdate, Date enddate) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)type);
        QFilter declaration = new QFilter("orgrow.declaration", "=", (Object)"3");
        QFilter shareFilter = new QFilter("orgrow.shareid", "=", (Object)shareid);
        QFilter ziorgidFilter = new QFilter("orgrow.orgid", "=", (Object)Long.parseLong(orgid));
        QFilter[] filters = new QFilter[]{statusFilter, typeFilter, declaration, shareFilter, ziorgidFilter, OrgUtils.getQFilter(enddate)};
        DynamicObjectCollection object = QueryServiceHelper.query((String)FORM_ORG_GROUP, (String)"orgrow.collectorg as collectorg", (QFilter[])filters, (String)"orgrow.orgid");
        if (null != object && object.size() > 0) {
            return ((DynamicObject)object.get(0)).getString("collectorg");
        }
        return null;
    }

    public static Map<String, String> queryOrgMap() {
        DynamicObjectCollection collection = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("status", "1"));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (DynamicObject obj : collection) {
            map.put(obj.getString("id"), obj.getString("name"));
        }
        return map;
    }

    public static String getOrgNameById(String orgid) {
        DynamicObjectCollection dispatchorder = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("id", orgid));
        if (dispatchorder != null && dispatchorder.size() > 0) {
            return ((DynamicObject)dispatchorder.get(0)).getString("name");
        }
        return "";
    }

    public static String getOrgStatusById(String orgid) {
        DynamicObjectCollection org = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"status", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgid))});
        if (org != null && org.size() > 0) {
            return ((DynamicObject)org.get(0)).getString("status");
        }
        return "";
    }

    public static Long getDefaultViewSchemaInfoId() {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id", (QFilter[])OrgUtils.getDefaultViewSchemaQFilter());
        return EmptyCheckUtils.isEmpty(coll) ? 0L : ((DynamicObject)coll.get(0)).getLong("id");
    }

    public static QFilter[] getDefaultViewSchemaQFilter() {
        QFilter f = new QFilter("isdefault", "=", (Object)"1");
        QFilter qf = new QFilter("treetype", "=", (Object)"40");
        return new QFilter[]{f, qf};
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId) {
        return OrgUtils.getAllOrgByViewId(orgViewSchemaId, null);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, Map<String, String>> orgTreeMap = new HashMap<String, Map<String, String>>();
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"kd.tmc.fbd.formplugin.companysys.CompanySysViewEdit.getAllOrgByViewId()", (String)"bos_org_structure", (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, DynamicObject> getAllOrgByView(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgIdFilter;
        DynamicObject[] ordDynamicObjects;
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, DynamicObject> orgTreeMap = new HashMap<String, DynamicObject>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id,org", (QFilter[])new QFilter[]{orgViewIdFilter}, (String)"longnumber");
        ArrayList<Long> ids = new ArrayList<Long>();
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                ids.add(dynamicObject.getLong("org.id"));
            }
        }
        if (Objects.nonNull(ordDynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,uniformsocialcreditcode,orgpattern,registeredcapital,establishmentdate,frepresentative", (QFilter[])new QFilter[]{orgIdFilter = new QFilter("id", "in", ids)})) && ordDynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : ordDynamicObjects) {
                String orgId = dynamicObject.getString("id");
                orgTreeMap.put(orgId, dynamicObject);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, List<Map<String, String>>> getOrgTreeMap(Map<String, Map<String, String>> orgMap) {
        HashMap<String, List<Map<String, String>>> orgTreeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map.Entry<String, Map<String, String>> orgId : orgMap.entrySet()) {
            OrgUtils.buildOrgTree(orgId.getValue(), orgMap, orgTreeMap);
        }
        return orgTreeMap;
    }

    public static void buildOrgTree(Map<String, String> org, Map<String, Map<String, String>> orgMap, Map<String, List<Map<String, String>>> orgTreeMap) {
        List<Map<String, String>> parentList;
        String orgid = org.get("id");
        if (orgid == null || orgid.equalsIgnoreCase("0")) {
            return;
        }
        String parentid = org.get("parentid");
        Map<String, String> parentOrg = orgMap.get(parentid);
        if (orgTreeMap.get(orgid) == null) {
            orgTreeMap.put(orgid, new ArrayList());
        }
        if (parentOrg == null) {
            return;
        }
        if (orgTreeMap.get(parentid) == null) {
            OrgUtils.buildOrgTree(parentOrg, orgMap, orgTreeMap);
        }
        if ((parentList = orgTreeMap.get(parentid)) == null) {
            return;
        }
        if (!parentList.contains(org)) {
            parentList.add(org);
        }
    }

    public static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap) {
        Map<String, Map> rootIdMap = orgTreeMap.entrySet().stream().filter(v -> "0".equals(((Map)v.getValue()).get("parentid"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        Set<String> rootIdSet = rootIdMap.keySet();
        if (rootIdSet.isEmpty()) {
            return null;
        }
        String rootId = rootIdSet.toArray(new String[0])[0];
        String rootName = orgTreeMap.get(rootId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(rootId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root) {
        if (orgTreeMap == null || rootId == null || orgTreeMap.size() == 0 || root == null) {
            return null;
        }
        OrgUtils.buildTreeNode(orgTreeMap, rootId, root);
        return root;
    }

    public static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        HashMap dataMap = (HashMap)treeNode.getData();
        if (childList == null || childList.size() == 0) {
            dataMap.put("isleaf", "1");
            return;
        }
        String parentLongNumber = treeNode.getLongNumber();
        int parentLevel = Integer.parseInt((String)dataMap.get("level"));
        String parentName = (String)dataMap.get("fullname");
        for (Map<String, String> org : childList) {
            TreeNode childrenTree = new TreeNode();
            String orgid = org.get("id");
            if ("0".equals(orgid) || StringUtils.isEmpty((CharSequence)org.get("name"))) continue;
            childrenTree.setParentid(org.get("parentid"));
            childrenTree.setId(orgid);
            childrenTree.setText(org.get("name"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentLongNumber + "!" + orgid);
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "0");
            childDataMap.put("level", String.valueOf(parentLevel + 1));
            childDataMap.put("fullname", parentName + "_" + org.get("name"));
            childrenTree.setData(childDataMap);
            treeNode.addChild(childrenTree);
            OrgUtils.buildTreeNode(orgTreeMap, orgid, childrenTree);
        }
        OrgUtils.sortTreeNode(treeNode.getChildren());
    }

    public static void sortTreeNode(List<TreeNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            Collections.sort(nodes, (node1, node2) -> CHINA_COMPARATOR.compare(node1.getText(), node2.getText()));
        }
    }

    public static TreeNode getTreeNodeById(String nodeId, TreeNode unitTreeNode) {
        int j = unitTreeNode.getNodeLevel(nodeId, 0);
        return unitTreeNode.getTreeNode(nodeId, j);
    }

    public static List<TreeNode> buildTreeNodeByList(TreeNode parentTreeNode, List<Map<String, Object>> leftNodes) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(leftNodes.size());
        HashMap parentData = (HashMap)parentTreeNode.getData();
        for (Map<String, Object> treeNode : leftNodes) {
            if (parentTreeNode.getId().equals(treeNode.get("id"))) continue;
            TreeNode childrenTree = new TreeNode();
            childrenTree.setParentid(parentTreeNode.getId());
            childrenTree.setId((String)treeNode.get("id"));
            childrenTree.setText((String)treeNode.get("text"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentTreeNode.getLongNumber() + "!" + treeNode.get("id"));
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "1");
            int level = Integer.parseInt((String)parentData.get("level")) + 1;
            childDataMap.put("level", String.valueOf(level));
            childDataMap.put("fullname", parentTreeNode.getText() + "_" + treeNode.get("text"));
            childrenTree.setData(childDataMap);
            treeNodes.add(childrenTree);
        }
        return treeNodes;
    }

    public static Long getLocalDefaultViewId() {
        return Long.valueOf("40");
    }

    public static QFilter getQFilter(Date enddate) {
        QFilter q = new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(FIELD_INVALIDDATE, ">=", (Object)DateUtils.getLastDateOfMonth1(enddate));
        q = q.or(new QFilter(FIELD_EFFECTDATE, "<=", (Object)DateUtils.getLastDateOfMonth1(enddate)).and(QFilter.isNull((String)FIELD_INVALIDDATE)));
        return q;
    }

    public static final List<String> getOrgIdByStructurePkids(List<String> structureIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", structureIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()))});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("org")).collect(Collectors.toList());
    }

    public static final List<String> getStructurePkidsByOrgId(List<String> orgIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())), OrgUtils.getDefaultTaxOrgStructureViewQfilter()});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("id")).distinct().collect(Collectors.toList());
    }

    public static List<Long> mergeOrgIds(List<Long> idList, String status) {
        if (StringUtils.equals((CharSequence)status, (CharSequence)"2")) {
            status = "1";
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"3")) {
            status = "0";
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        QFilter orgFilter = new QFilter("org.id", "in", idList);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id,org.id as orgid", (QFilter[])new QFilter[]{statusFilter, orgFilter});
        List disabledOrgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        List<Long> mergeOrgIds = idList.stream().filter(v -> !disabledOrgList.contains(v)).collect(Collectors.toList());
        return mergeOrgIds;
    }

    public static List<Long> queryTaxOrgListByStatus(String status) {
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"org.id as orgid", (QFilter[])new QFilter[]{statusFilter});
        List<Long> orgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        return orgList;
    }

    public static void addFilterByConditionBeforeF7Select(Object event, IFormView view, String[] excludeFormArray, String permissionEntiyId, String permissionConstant) {
        if (BeforeF7SelectEvent.class.isAssignableFrom(event.getClass())) {
            BeforeF7SelectEvent beforeF7SelectEvent = (BeforeF7SelectEvent)event;
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            formShowParameter.getCustomParams().put("orgFuncId", "40");
            List<Long> orgList = new ArrayList<Long>();
            if (MUST_IS_TAXPAYER.contains(PageShowCommon.getMetadataNumberByView(view))) {
                List<Long> notTaxPayerOrgList = OrgUtils.filterByIsTaxpayer(Boolean.FALSE);
                orgList.addAll(notTaxPayerOrgList);
                orgList = orgList.stream().distinct().collect(Collectors.toList());
            }
            QFilter idsFilter = new QFilter("id", "not in", orgList);
            TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIds();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", listTaxResult.getData()));
            formShowParameter.getListFilterParameter().getQFilters().add(idsFilter);
        }
        if (BeforeFilterF7SelectEvent.class.isAssignableFrom(event.getClass())) {
            QFilter idsFilter;
            HasPermOrgResult permOrgResult;
            BeforeFilterF7SelectEvent beforeFilterF7SelectEvent = (BeforeFilterF7SelectEvent)event;
            List<Long> orgList = new ArrayList<Long>();
            if (ReportView.class.isAssignableFrom(view.getClass()) && EmptyCheckUtils.isNotEmpty(permOrgResult = PermissionUtils.getAllPermOrgs(view)) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty(permOrgResult.getHasPermOrgs())) {
                orgList = permOrgResult.getHasPermOrgs();
            }
            if (EmptyCheckUtils.isNotEmpty(excludeFormArray) && Arrays.stream(excludeFormArray).anyMatch(v -> v.equals(PageShowCommon.getMetadataNumberByView(view)))) {
                orgList = ReportView.class.isAssignableFrom(view.getClass()) ? OrgUtils.mergeOrgIds(orgList, "3") : OrgUtils.queryTaxOrgListByStatus("0");
            } else {
                QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
                beforeFilterF7SelectEvent.getCustomQFilters().add(statusFilter);
            }
            if (ReportView.class.isAssignableFrom(view.getClass())) {
                idsFilter = new QFilter("id", "in", orgList);
                beforeFilterF7SelectEvent.getCustomQFilters().add(idsFilter);
            } else {
                idsFilter = new QFilter("id", "not in", orgList);
                beforeFilterF7SelectEvent.getCustomQFilters().add(idsFilter);
            }
        }
    }

    private static List<Long> filterByIsTaxpayer(Boolean istaxpayer) {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"org.id as id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)istaxpayer)});
        return CollectionUtils.isEmpty((Collection)taxOrgs) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList) {
        List<Long> orgIds = OrgUtils.filterByIsTaxpayer(Boolean.FALSE);
        orgList.removeIf(s -> orgIds.contains(s));
        return orgList;
    }

    public static List<Map<String, String>> queryOrgListForInitOrgComboItems(IFormView view, String[] excludeFormArray, String permissionEntiyId, String permissionConstant) {
        DynamicObjectCollection collection;
        ArrayList<Map<String, String>> orgItems = new ArrayList<Map<String, String>>();
        HasPermOrgResult hasPermOrgResult = StringUtils.isBlank((CharSequence)permissionEntiyId) ? PermissionUtils.getAllPermOrgs(view) : PermissionUtils.getAllPermOrgs(view, permissionEntiyId, permissionConstant);
        if (EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            List<Long> orgList = hasPermOrgResult.getHasPermOrgs();
            HashMap<String, List<Object>> convertParam = new HashMap<String, List<Object>>(2);
            if (EmptyCheckUtils.isNotEmpty(excludeFormArray) && Arrays.stream(excludeFormArray).anyMatch(v -> v.equals(PageShowCommon.getMetadataNumberByView(view)))) {
                orgList = OrgUtils.mergeOrgIds(orgList, "3");
            }
            TreeUtils.convertParam("id", orgList, convertParam);
            collection = TreeUtils.queryOrgListByCondition(convertParam);
        } else {
            collection = TreeUtils.getOrgLists();
        }
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            collection.stream().forEach(v -> {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", v.getString("id"));
                item.put("number", v.getString("number"));
                item.put("name", v.getString("name"));
                item.put("parentid", v.getString("parentid"));
                item.put("status", v.getString("status"));
                item.put("longnumber", v.getString("longnumber"));
                orgItems.add(item);
            });
        }
        return orgItems;
    }

    public static List<ComboItem> getComboItems(List<Map<String, String>> orgList) {
        String orgID = String.valueOf(RequestContext.get().getOrgId());
        int index = -1;
        int orgIndex = -1;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
        for (Map<String, String> map : orgList) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(map.get("name")));
            item.setValue(map.get("id"));
            combos.add(item);
            if (!orgID.equals(item.getValue())) continue;
            orgIndex = index;
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }

    public static QFilter getDefaultTaxOrgStructureViewQfilter() {
        return new QFilter("view.treetype", "=", (Object)String.valueOf(OrgUtils.getDefaultViewSchemaInfoId())).and("view.number", "=", (Object)"40");
    }

    public static DynamicObjectCollection queryEnableOrgs(String selectFields, QFilter filter) {
        QFilter filters = new QFilter("status", "=", (Object)"1");
        filters.and(new QFilter("istaxpayer", "=", (Object)Boolean.TRUE));
        if (filter != null) {
            filters.and(filter);
        }
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)selectFields, (QFilter[])new QFilter[]{filters});
        return taxOrgs;
    }

    static {
        MUST_IS_TAXPAYER = new HashSet<String>(Arrays.asList("tccit_seasonal_declare", "tccit_seasonal_declare2", "tccit_mainpage", "tccit_newmainpage", "tcvat_draft_page", "tcvat_draft_page_sjjt", "tcvat_declare_home", "tcvat_declare_edit", "tcret_pbt_declare_home", "tcct_draft_edit", "tcct_declare_new", "tcvat_apphome", "tccit_apphome", "tcret_apphome_new", "tcct_apphome", "tsate_declare_config", "tcret_yhs_acccrual", "tcret_fcs_accrual_draft", "tcret_hbs_accrual_draft", "tcret_ccs_accrual_draft", "itp_papers_edit", "itp_accrual_declare_than", "totf_ghjfsljs_declare", "tcnfep_dkdj_declare", "tcnfep_kjqysds_declare", "tcwat_declare_home", "totf_tyfsssr_declare", "totf_whsyjsf_declare", "tcret_wp_declare", "tcret_yj_declare", "tcret_qs_declare"));
        CHINA_COMPARATOR = Collator.getInstance(Locale.CHINA);
    }
}

