/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.address.AddressUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.enums.TaxTypeComboEnum;
import kd.taxc.enums.TaxTypeEndDateEnum;

public class RegisterAddressUtil {
    public static final List<Long> PLAN_SINGLE_CITY_LIST = Lists.newArrayList((Object[])new Long[]{3135L, 407L, 2676L, 194L, 2530L, 3547L, 2232L, 142L, 124L});
    private static final String METHODS_MONTH = "2";
    private static final String METHODS_SEAON = "1";
    private static final String METHODS_YEAR = "3";
    private static final String ENTITY_CALENDAR = "tpo_tax_calendar";
    private static Map<Integer, String> monthMap = new HashMap<Integer, String>();

    public static final Date findZZSMonthApplyEndDate(Object orgid) {
        return RegisterAddressUtil.findOrgApplyTypeTaxTypeEndDate(orgid, METHODS_MONTH, METHODS_SEAON);
    }

    public static final List<Map<String, Object>> findOrgApplyTypeTaxTypeEndDate(Object orgid, String taxType, Date date) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(10);
        DynamicObject taxmain = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)"id,taxorg.istaxpayer,orgid,registeraddress,categoryentryentity,categoryentryentity.taxtype,categoryentryentity.deadline", (QFilter[])new QFilter[]{orgFilter});
        if (taxmain == null) {
            String orgname = OrgUtils.getOrgNameById(String.valueOf(orgid));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u7684\u4fe1\u606f\u3002", (String)"RegisterAddressUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
        }
        Boolean isentity = taxmain.getBoolean("taxorg.istaxpayer");
        isentity = EmptyCheckUtils.isEmpty(isentity) ? Boolean.TRUE : isentity;
        String orgname = taxmain.getDynamicObject("orgid").getString("name");
        DynamicObjectCollection categoryentryentity = taxmain.getDynamicObjectCollection("categoryentryentity");
        if (EmptyCheckUtils.isEmpty(categoryentryentity)) {
            if (isentity.booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u91cc\u7684\u201c\u7a0e\u79cd\u5361\u7247\u201d\u5185\u5bb9\u3002", (String)"RegisterAddressUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
            }
            return null;
        }
        List<String> applyTypes = RegisterAddressUtil.getApplyType(taxType, orgid, categoryentryentity, date, isentity);
        if (!isentity.booleanValue() && EmptyCheckUtils.isEmpty(applyTypes)) {
            return null;
        }
        TaxTypeEndDateEnum taxTypeEndDateEnum = TaxTypeEndDateEnum.getEnumByCode(taxType);
        if (applyTypes.contains(METHODS_YEAR) && taxTypeEndDateEnum == TaxTypeEndDateEnum.QYSDS) {
            HashMap<String, Object> resMap = new HashMap<String, Object>(16);
            resMap.put("orgid", orgid);
            Date lastYear = DateUtils.addYear(date, -1);
            Date startdate = DateUtils.getFirstDateOfYear(lastYear);
            Date enddate = DateUtils.getLastDateOfYear(lastYear);
            resMap.put("startdate", startdate);
            resMap.put("enddate", enddate);
            resMap.put("taxlimit", "year");
            mapList.add(resMap);
        }
        for (String applyType : applyTypes) {
            Date endDate;
            if (METHODS_YEAR.equalsIgnoreCase(applyType) && TaxTypeComboEnum.QYSDS == taxTypeEndDateEnum.getTaxEnum() || null == (endDate = RegisterAddressUtil.findOrgApplyTypeTaxTypeWithQueryDateEndDate(orgid, applyType, taxTypeEndDateEnum.getCalendarTaxType(), date))) continue;
            HashMap<String, Object> resMap = new HashMap<String, Object>(16);
            resMap.put("orgid", orgid);
            resMap.put("taxlimit", "month");
            Date sqDate = DateUtils.addMonth(endDate, -1);
            Date startdate = DateUtils.getFirstDateOfMonth(sqDate);
            Date enddate = DateUtils.getLastDateOfMonth(sqDate);
            if (METHODS_SEAON.equalsIgnoreCase(applyType)) {
                int month = DateUtils.getMonthOfDate(date);
                if (month != 1 && month != 4 && month != 7 && month != 10) {
                    return mapList;
                }
                startdate = DateUtils.getFirstDateOfSeason(sqDate);
                enddate = DateUtils.getLastDateOfSeason(sqDate);
                resMap.put("taxlimit", "season");
            } else if (METHODS_YEAR.equalsIgnoreCase(applyType)) {
                startdate = DateUtils.getFirstDateOfYear(sqDate);
                enddate = DateUtils.getLastDateOfYear(sqDate);
                resMap.put("taxlimit", "year");
            }
            resMap.put("startdate", startdate);
            resMap.put("enddate", enddate);
            mapList.add(resMap);
        }
        return mapList;
    }

    private static List<String> getApplyType(String taxType, Object orgid, DynamicObjectCollection categoryentryentity, Date date, Boolean isentity) {
        DynamicObjectCollection taxtypeColls;
        QFilter taxtypeqFilter;
        QFilter qFilter;
        HashSet<String> applyTypes = new HashSet<String>(10);
        TaxTypeEndDateEnum taxTypeEndDateEnum = TaxTypeEndDateEnum.getEnumByCode(taxType);
        TaxTypeComboEnum taxTypeComboEnum = taxTypeEndDateEnum.getTaxEnum();
        Date lastMonth = DateUtils.addMonth(date, -1);
        if (taxTypeComboEnum == TaxTypeComboEnum.QYSDS) {
            Date endDate;
            QFilter taxtypeQf = new QFilter("taxtype", "=", (Object)"qysds");
            QFilter effectdateQ = new QFilter("effectdate", "<=", (Object)DateUtils.getFirstDateOfYear(DateUtils.addYear(date, -1)));
            QFilter enableQf = new QFilter("status", "=", (Object)METHODS_MONTH);
            QFilter orgQf = new QFilter("orgrow.orgid", "=", orgid);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"id,orgrow.shareid", (QFilter[])new QFilter[]{taxtypeQf, effectdateQ, enableQf, orgQf});
            boolean isByYear = true;
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (null == dynamicObject.get("orgrow.shareid") || dynamicObject.getBoolean("orgrow.shareid")) continue;
                isByYear = false;
                break;
            }
            if (isByYear && null != (endDate = RegisterAddressUtil.findOrgApplyTypeTaxTypeWithQueryDateEndDate(orgid, METHODS_YEAR, taxTypeEndDateEnum.getCalendarTaxType(), date))) {
                applyTypes.add(METHODS_YEAR);
            }
        }
        String formid = taxTypeEndDateEnum.getTaxEnum().getFormId();
        QFilter orgqFilter = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        QFilter modfiydateqFilter = new QFilter("modifydate", "<=", (Object)DateUtils.getLastDateOfMonth(lastMonth));
        DynamicObject lastOne = null;
        if (taxTypeEndDateEnum.getTaxEnum() == TaxTypeComboEnum.ZZS || taxTypeEndDateEnum.getTaxEnum() == TaxTypeComboEnum.FJSF) {
            qFilter = new QFilter("entryentity.modifycontexttitleysjbs", "in", Arrays.asList("deadline", "taxenddate"));
            taxtypeqFilter = new QFilter("taxtype", "=", (Object)TaxTypeComboEnum.ZZS.getCode());
            taxtypeColls = QueryServiceHelper.query((String)formid, (String)"id,entryentity.modifycontexafter,entryentity.modifycontexbefore,entryentity.modifycontexbeforecode,entryentity.modifycontexaftercode,entryentity.modifycontexttitle,entryentity.modifycontexttitleysjbs", (QFilter[])new QFilter[]{orgqFilter, taxtypeqFilter, qFilter}, (String)" modifydate desc");
            lastOne = RegisterAddressUtil.getTaxVer(taxtypeColls, DateUtils.getLastDateOfMonth(lastMonth));
        } else if (taxTypeEndDateEnum.getTaxEnum() == TaxTypeComboEnum.QYSDS) {
            taxtypeqFilter = new QFilter("taxtype", "=", (Object)taxTypeEndDateEnum.getTaxEnum().getCode());
            taxtypeColls = QueryServiceHelper.query((String)formid, (String)"entryentity.modifycontexbeforecode,entryentity.modifycontexaftercode,entryentity.modifycontexttitle,entryentity.modifycontexttitleysjbs", (QFilter[])new QFilter[]{orgqFilter, taxtypeqFilter, modfiydateqFilter, qFilter = new QFilter("entryentity.modifycontexttitleysjbs", "=", (Object)"deadline")}, (String)" modifydate desc");
            if (EmptyCheckUtils.isNotEmpty(taxtypeColls)) {
                lastOne = (DynamicObject)taxtypeColls.get(0);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u524d\u4ec5\u652f\u6301\u4f01\u4e1a\u6240\u5f97\u7a0e\u3001\u589e\u503c\u7a0e\u3001\u9644\u52a0\u7a0e\u8d39\uff0c\u5176\u4ed6\u7a0e\u79cd\u6682\u4e0d\u652f\u6301\u3002", (String)"RegisterAddressUtil_2", (String)"taxc-tctb-common", (Object[])new Object[0]));
        }
        if (EmptyCheckUtils.isNotEmpty(taxtypeColls)) {
            if (lastOne != null) {
                String sbtype = lastOne.getString("entryentity.modifycontexaftercode");
                if ("aysb".equalsIgnoreCase(sbtype)) {
                    applyTypes.add(METHODS_MONTH);
                } else {
                    applyTypes.add(METHODS_SEAON);
                }
            }
        } else {
            TaxTypeComboEnum filterEnum = null;
            if (taxTypeEndDateEnum.getTaxEnum() == TaxTypeComboEnum.ZZS || taxTypeEndDateEnum.getTaxEnum() == TaxTypeComboEnum.FJSF) {
                filterEnum = TaxTypeComboEnum.ZZS;
            } else if (taxTypeEndDateEnum.getTaxEnum() == TaxTypeComboEnum.QYSDS) {
                filterEnum = TaxTypeComboEnum.QYSDS;
            }
            if (null != filterEnum) {
                String filtercode = filterEnum.getCode();
                List dynamicObjects = categoryentryentity.stream().filter(v -> v.getString("taxtype").equalsIgnoreCase(filtercode)).collect(Collectors.toList());
                if (EmptyCheckUtils.isEmpty(dynamicObjects)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u91cc\u7684\u201c\u7a0e\u79cd\u5361\u7247\u201d\u5185\u5bb9", (String)"RegisterAddressUtil_3", (String)"taxc-tctb-common", (Object[])new Object[0]));
                }
                String sbtype = ((DynamicObject)dynamicObjects.get(0)).getString("deadline");
                if ("aysb".equalsIgnoreCase(sbtype)) {
                    applyTypes.add(METHODS_MONTH);
                } else {
                    applyTypes.add(METHODS_SEAON);
                }
            }
        }
        if (EmptyCheckUtils.isNotEmpty(applyTypes)) {
            return new ArrayList<String>(applyTypes);
        }
        if (!isentity.booleanValue()) {
            return null;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5168", (String)"RegisterAddressUtil_4", (String)"taxc-tctb-common", (Object[])new Object[0]));
    }

    private static DynamicObject getTaxVer(DynamicObjectCollection taxtypeColls, Date lastDateOfMonth) {
        if (null == taxtypeColls || 0 == taxtypeColls.size()) {
            return null;
        }
        ArrayList resList = new ArrayList(10);
        taxtypeColls.stream().collect(Collectors.groupingBy(v -> v.getString("id"))).entrySet().stream().forEach(e -> {
            boolean isFilter = false;
            DynamicObject temp = null;
            for (DynamicObject dynamicObject : (List)e.getValue()) {
                if ("deadline".equalsIgnoreCase(dynamicObject.getString("entryentity.modifycontexttitleysjbs"))) {
                    temp = dynamicObject;
                    continue;
                }
                if (!"taxenddate".equalsIgnoreCase(dynamicObject.getString("entryentity.modifycontexttitleysjbs")) || !DateUtils.isEffectiveDate(lastDateOfMonth, DateUtils.getFirstDateOfMonth(EmptyCheckUtils.isEmpty(dynamicObject.get("entryentity.modifycontexbefore")) ? DateUtils.stringToDateInAnyFormat("2018-01-01") : DateUtils.stringToDateInAnyFormat(dynamicObject.getString("entryentity.modifycontexbefore"))), DateUtils.getFirstDateOfMonth(EmptyCheckUtils.isEmpty(dynamicObject.get("entryentity.modifycontexafter")) ? DateUtils.stringToDateInAnyFormat("2018-01-01") : DateUtils.stringToDateInAnyFormat(dynamicObject.getString("entryentity.modifycontexafter"))))) continue;
                isFilter = true;
            }
            if (null != temp && isFilter && resList.size() == 0) {
                resList.add(temp);
            }
        });
        return EmptyCheckUtils.isEmpty(resList) ? taxtypeColls.stream().filter(v -> "deadline".equalsIgnoreCase(v.getString("entryentity.modifycontexttitleysjbs"))).findFirst().get() : (DynamicObject)resList.get(0);
    }

    public static final Date findOrgApplyTypeTaxTypeWithQueryDateEndDate(Object orgid, String applyType, String taxType, Date date) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        DynamicObject taxmain = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,taxorg.istaxpayer as isentity,orgid.name, registeraddress", (QFilter[])new QFilter[]{orgFilter});
        if (taxmain == null) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(String.valueOf(orgid)))});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u7684\u4fe1\u606f\u3002", (String)"RegisterAddressUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), dynamicObjects.length > 0 ? dynamicObjects[0].getString("name") : ""));
        }
        Long admindivision = taxmain.getLong("registeraddress");
        return RegisterAddressUtil.getTaxCalenderDate(orgid, applyType, taxType, date, admindivision);
    }

    public static Date getTaxCalenderDate(Object orgid, String applyType, String taxType, Date date, Long admindivision) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        DynamicObject taxmain = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id,taxorg.istaxpayer as isentity,orgid.name, registeraddress", (QFilter[])new QFilter[]{orgFilter});
        if (taxmain == null) {
            String orgname = OrgUtils.getOrgNameById(String.valueOf(orgid));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u7684\u4fe1\u606f\u3002", (String)"RegisterAddressUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
        }
        Boolean isentity = taxmain.getBoolean("isentity");
        isentity = EmptyCheckUtils.isEmpty(isentity) ? Boolean.TRUE : isentity;
        String orgname = taxmain.getString("orgid.name");
        DynamicObject registerAddress = AddressUtils.getAdmindivision(admindivision);
        if (EmptyCheckUtils.isEmpty(registerAddress)) {
            if (isentity.booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u91cc\u7684\u201c\u6ce8\u518c\u767b\u8bb0\u533a\u57df\u201d\u5185\u5bb9\u3002", (String)"RegisterAddressUtil_5", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
            }
            return null;
        }
        long level = registerAddress.getLong("basedatafield.level");
        long provinceid = 0L;
        Long cityid = 0L;
        if (level == 1L) {
            provinceid = registerAddress.getLong("id");
        } else if (level == 2L) {
            cityid = registerAddress.getLong("id");
            provinceid = registerAddress.getLong("parent");
        } else if (level == 3L) {
            cityid = registerAddress.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision(cityid);
            if (null == city) {
                if (isentity.booleanValue()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201c\u6ce8\u518c\u767b\u8bb0\u5730\u4e0d\u5728\u4e2d\u56fd\u5927\u9646\uff0c\u6682\u4e0d\u652f\u6301\u3002", (String)"RegisterAddressUtil_6", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
                }
                return null;
            }
            provinceid = city.getLong("parent");
        } else if (level > 3L) {
            long streetid = registerAddress.getLong("parent");
            DynamicObject area = AddressUtils.getAdmindivision(streetid);
            if (null == area) {
                if (isentity.booleanValue()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201c\u6ce8\u518c\u767b\u8bb0\u5730\u4e0d\u5728\u4e2d\u56fd\u5927\u9646\uff0c\u6682\u4e0d\u652f\u6301\u3002", (String)"RegisterAddressUtil_6", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
                }
                return null;
            }
            cityid = area.getLong("parent");
            DynamicObject city = AddressUtils.getAdmindivision(cityid);
            if (null == city) {
                if (isentity.booleanValue()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201c\u6ce8\u518c\u767b\u8bb0\u5730\u4e0d\u5728\u4e2d\u56fd\u5927\u9646\uff0c\u6682\u4e0d\u652f\u6301\u3002", (String)"RegisterAddressUtil_6", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
                }
                return null;
            }
            provinceid = city.getLong("parent");
        }
        boolean isPlanSingleCity = RegisterAddressUtil.isPlanSingleCity(cityid);
        int month = DateUtils.getMonthOfDate(date);
        int year = DateUtils.getYearOfDate(date);
        QFilter provinceFilter = new QFilter("entryentity.provinces", "=", (Object)provinceid);
        QFilter cityFilter = new QFilter("entryentity.city", "=", (Object)cityid);
        QFilter taxFilter = new QFilter("entryentity.taxtype", "=", (Object)taxType);
        QFilter methodsFilter = new QFilter("entryentity.methods", "=", (Object)applyType);
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        String monthEndDateStr = monthMap.get(month);
        if (EmptyCheckUtils.isEmpty(monthEndDateStr)) {
            throw new KDBizException("month is error month = " + month);
        }
        DynamicObjectCollection calendars = isPlanSingleCity ? RegisterAddressUtil.queryCalender(provinceFilter, cityFilter, taxFilter, methodsFilter, yearFilter, month) : RegisterAddressUtil.queryCalender(provinceFilter, null, taxFilter, methodsFilter, yearFilter, month);
        if (EmptyCheckUtils.isEmpty(calendars)) {
            calendars = RegisterAddressUtil.queryCalendarByName(provinceid, cityid, taxFilter, methodsFilter, yearFilter, month);
        }
        if (EmptyCheckUtils.isEmpty(calendars)) {
            if (isentity.booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4>\u7a0e\u52a1\u65e5\u5386\u201d\u4e2d\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7a0e\u52a1\u65e5\u5386\u3002", (String)"RegisterAddressUtil_7", (String)"taxc-tctb-common", (Object[])new Object[0]), orgname));
            }
            return null;
        }
        return RegisterAddressUtil.getCalendarDate(year, calendars);
    }

    public static Date getCalendarDate(int year, DynamicObjectCollection calendars) {
        if (EmptyCheckUtils.isEmpty(calendars)) {
            return null;
        }
        String endDateStr = ((DynamicObject)calendars.get(0)).getString("date");
        if ("\u2014\u2014".equalsIgnoreCase(endDateStr)) {
            return null;
        }
        StringBuilder date = new StringBuilder();
        date.append(year);
        String regex = "(\\d+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(endDateStr);
        while (matcher.find()) {
            String str = matcher.group();
            String newstr = Integer.parseInt(str) < 10 ? "0" + str : str;
            date.append("-").append(newstr);
        }
        return DateUtils.stringToDateInAnyFormat(date.toString());
    }

    public static final Date findOrgApplyTypeTaxTypeEndDate(Object orgid, String applyType, String taxType) {
        return RegisterAddressUtil.findOrgApplyTypeTaxTypeWithQueryDateEndDate(orgid, applyType, taxType, new Date());
    }

    public static boolean isPlanSingleCity(Long cityid) {
        return PLAN_SINGLE_CITY_LIST.contains(cityid);
    }

    public static DynamicObjectCollection queryCalender(QFilter provinceFilter, QFilter cityFilter, QFilter taxtypeFilter, QFilter methodsFilter, QFilter yearFilter, int month) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (EmptyCheckUtils.isNotEmpty(provinceFilter)) {
            qFilterList.add(provinceFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(cityFilter)) {
            qFilterList.add(cityFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(taxtypeFilter)) {
            qFilterList.add(taxtypeFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(methodsFilter)) {
            qFilterList.add(methodsFilter);
        }
        if (EmptyCheckUtils.isNotEmpty(yearFilter)) {
            qFilterList.add(yearFilter);
        }
        return QueryServiceHelper.query((String)ENTITY_CALENDAR, (String)("entryentity." + monthMap.get(month) + " as date"), (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
    }

    public static DynamicObjectCollection queryCalendarByName(Long provinceid, Long cityid, QFilter taxtypeFilter, QFilter methodsFilter, QFilter yearFilter, int month) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObject province = AddressUtils.getAdmindivision(provinceid);
        DynamicObject city = AddressUtils.getAdmindivision(cityid);
        QFilter provinceNameFilter = null;
        QFilter cityNameFilter = null;
        if (EmptyCheckUtils.isNotEmpty(province)) {
            provinceNameFilter = new QFilter("entryentity.provinces.name", "like", (Object)(province.getString("name") + "%"));
        }
        if (EmptyCheckUtils.isNotEmpty(city)) {
            cityNameFilter = new QFilter("entryentity.city.name", "like", (Object)("%" + city.getString("name") + "%"));
        }
        if (EmptyCheckUtils.isNotEmpty(provinceNameFilter)) {
            collection = EmptyCheckUtils.isNotEmpty(cityNameFilter) ? RegisterAddressUtil.queryCalender(provinceNameFilter, cityNameFilter, taxtypeFilter, methodsFilter, yearFilter, month) : RegisterAddressUtil.queryCalender(provinceNameFilter, null, taxtypeFilter, methodsFilter, yearFilter, month);
        }
        return collection;
    }

    static {
        monthMap.put(1, "january");
        monthMap.put(2, "february");
        monthMap.put(3, "march");
        monthMap.put(4, "april");
        monthMap.put(5, "may");
        monthMap.put(6, "june");
        monthMap.put(7, "july");
        monthMap.put(8, "august");
        monthMap.put(9, "september");
        monthMap.put(10, "october");
        monthMap.put(11, "november");
        monthMap.put(12, "december");
    }
}

