/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.license;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.license.LicenseDataSyn;
import kd.taxc.license.LicenseGroupUtil;

public class LicenseCheckService {
    private static String TCTB_LICENSE = "tctb_license";
    private static String TCTB_LICENSE_FROM = "tctb_license_from";
    private static String BASTAX_TAXORG = "bastax_taxorg";
    public static final String PRO_TAXB = "34";
    public static final String PRO_TAXP = "35";
    public static final String t_36 = "36";
    public static final String PRO_TAXM = "37";
    public static final String TAXB = "38";

    private static String getMsgA() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u6fc0\u6d3b\u201c%s\u201d\u7ec4\u7ec7\u7684\u8bb8\u53ef\u3002", (String)"LicenseCheckService_0", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getMsgB() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u8bb8\u53ef\u5df2\u6ce8\u9500\uff0c\u4e0d\u80fd\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)"LicenseCheckService_1", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getMsgC() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u6388\u6743\u7684\u4e0d\u4e00\u81f4\u3002", (String)"LicenseCheckService_2", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static String getMsgD() {
        return ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u76f8\u5173\u4fe1\u606f\u5df2\u88ab\u4fee\u6539\u3002", (String)"LicenseCheckService_3", (String)"taxc-tctb-common", (Object[])new Object[0]);
    }

    private static boolean checkProTaxb(Object orgid, IFormView e, String ver) {
        return LicenseCheckService.check(orgid, e, PRO_TAXB, LicenseGroupUtil.getTAXB(), ver);
    }

    private static boolean checkProTaxp(Object orgid, IFormView e, String ver) {
        return LicenseCheckService.check(orgid, e, PRO_TAXP, LicenseGroupUtil.getTaxcp(), ver);
    }

    private static boolean checkProTaxm(Object orgid, IFormView e, String ver) {
        return LicenseCheckService.check(orgid, e, PRO_TAXM, LicenseGroupUtil.getTaxcm(), ver);
    }

    private static boolean checkTaxb(Object orgid, IFormView e, String ver) {
        return LicenseCheckService.check(orgid, e, TAXB, true, ver);
    }

    public static boolean check(Object orgid, IFormView e, String appid) {
        if (LicenseGroupUtil.getVersion().startsWith("4")) {
            if (appid.equalsIgnoreCase("tcdrs")) {
                return false;
            }
            return LicenseCheckService.check4(orgid, e, appid, "4.0");
        }
        if (LicenseGroupUtil.getVersion().startsWith("5")) {
            if (appid.equalsIgnoreCase("tcdrs")) {
                return false;
            }
            return LicenseCheckService.check5(orgid, e, appid, "5.0");
        }
        return LicenseCheckService.check3(orgid, e, appid, "3.0");
    }

    private static boolean check5(Object orgid, IFormView e, String appid, String ver) {
        boolean result1 = false;
        if (null == appid || "".equals(appid)) {
            return result1;
        }
        switch (appid) {
            case "tcvat": 
            case "tccit": 
            case "tcret": 
            case "tctrc": {
                LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup(appid);
                if (!result.getHasLicense().booleanValue()) {
                    if (null != e) {
                        e.showConfirm(result.getMsg(), null);
                    }
                    result1 = true;
                    break;
                }
                DynamicObjectCollection doc = QueryServiceHelper.query((String)TCTB_LICENSE_FROM, (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(TAXB)), new QFilter("ver", "=", (Object)ver)});
                if (doc.isEmpty()) {
                    DynamicObjectCollection doc1 = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id,unifiedsocialcode", null);
                    HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
                    for (DynamicObject d : doc1) {
                        map.put(d.getString("id"), d);
                    }
                    DynamicObjectCollection tctb = QueryServiceHelper.query((String)TCTB_LICENSE, (String)"orgfield,licensestatus,activeuserid,canceluserid,activedate,canceldate", (QFilter[])new QFilter[]{new QFilter("status", "!=", (Object)"1")});
                    DynamicObjectCollection dos = TreeUtils.getOrgLists();
                    LicenseDataSyn.sysData(TAXB, map, tctb, dos);
                }
                result1 = LicenseCheckService.checkTaxb(orgid, e, ver);
                break;
            }
        }
        return result1;
    }

    private static boolean check4(Object orgid, IFormView e, String appid, String ver) {
        boolean result1 = false;
        if (null == appid || "".equals(appid)) {
            return result1;
        }
        switch (appid) {
            case "tcvat": 
            case "tccit": 
            case "tcret": 
            case "tctrc": {
                LicenseCheckResult result = LicenseGroupUtil.checkTAXBPerformGroup(appid);
                if (!result.getHasLicense().booleanValue()) {
                    if (null != e) {
                        e.showConfirm(result.getMsg(), null);
                    }
                    result1 = true;
                    break;
                }
                DynamicObjectCollection doc = QueryServiceHelper.query((String)TCTB_LICENSE_FROM, (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(TAXB)), new QFilter("ver", "=", (Object)ver)});
                if (doc.isEmpty()) {
                    DynamicObjectCollection doc1 = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"id,unifiedsocialcode", null);
                    HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
                    for (DynamicObject d : doc1) {
                        map.put(d.getString("id"), d);
                    }
                    DynamicObjectCollection tctb = QueryServiceHelper.query((String)TCTB_LICENSE, (String)"orgfield,licensestatus,activeuserid,canceluserid,activedate,canceldate", (QFilter[])new QFilter[]{new QFilter("status", "!=", (Object)"1")});
                    DynamicObjectCollection dos = TreeUtils.getOrgLists();
                    LicenseDataSyn.sysData(TAXB, map, tctb, dos);
                }
                result1 = LicenseCheckService.checkTaxb(orgid, e, ver);
                break;
            }
        }
        return result1;
    }

    private static boolean check3(Object orgid, IFormView e, String appid, String ver) {
        boolean result = false;
        if (null == appid || "".equals(appid)) {
            return result;
        }
        switch (appid) {
            case "tcvvt": {
                break;
            }
            case "tctrc": {
                result = LicenseCheckService.checkProTaxm(orgid, e, ver);
                break;
            }
            case "tccit": 
            case "tcvat": 
            case "fjsf": {
                result = LicenseCheckService.checkProTaxb(orgid, e, ver);
                break;
            }
            case "tcct": 
            case "tcsd": 
            case "tcret": {
                result = LicenseCheckService.checkProTaxp(orgid, e, ver);
                break;
            }
        }
        return result;
    }

    public static boolean check(Object orgid, IFormView e, String taxb, boolean isCheck, String ver) {
        if (isCheck) {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)TCTB_LICENSE_FROM, (String)"id,orgid,orgid.name,licensestatus", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.parseLong(orgid.toString())), new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("ver", "=", (Object)ver)});
            if (doc.size() > 0) {
                if (((DynamicObject)doc.get(0)).getString("licensestatus").equals("A")) {
                    if (null != e) {
                        e.showConfirm(String.format(LicenseCheckService.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), null);
                    }
                } else if (((DynamicObject)doc.get(0)).getString("licensestatus").equals("C")) {
                    if (null != e) {
                        e.showConfirm(String.format(LicenseCheckService.getMsgB(), ((DynamicObject)doc.get(0)).getString("orgid.name")), null);
                    }
                } else if (((DynamicObject)doc.get(0)).getString("licensestatus").equals("B")) {
                    DynamicObjectCollection unifiedsocialcode = QueryServiceHelper.query((String)BASTAX_TAXORG, (String)"unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()))});
                    if (unifiedsocialcode.size() > 0) {
                        DynamicObjectCollection org = QueryServiceHelper.query((String)TCTB_LICENSE_FROM, (String)"id,unifiedsocialcode,orgid,licensestatus,group,password", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Long.parseLong(taxb)), new QFilter("orgid", "=", (Object)Long.parseLong(orgid.toString())), new QFilter("unifiedsocialcode", "=", ((DynamicObject)unifiedsocialcode.get(0)).get("unifiedsocialcode"))});
                        if (org.size() > 0) {
                            return false;
                        }
                        if (null != e) {
                            e.showConfirm(String.format(LicenseCheckService.getMsgC(), ((DynamicObject)doc.get(0)).getString("orgid.name")), null);
                        }
                    } else if (null != e) {
                        e.showConfirm(String.format(LicenseCheckService.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), null);
                    }
                } else if (null != e) {
                    e.showConfirm(String.format(LicenseCheckService.getMsgA(), ((DynamicObject)doc.get(0)).getString("orgid.name")), null);
                }
            } else {
                DynamicObjectCollection dcs = TreeUtils.getOrgLists();
                DynamicObject orgId = null;
                for (DynamicObject temp : dcs) {
                    if (temp.getLong("id") != Long.parseLong(orgid.toString())) continue;
                    orgId = temp;
                    break;
                }
                if (null != orgId && null != e) {
                    e.showConfirm(String.format(LicenseCheckService.getMsgA(), orgId.get("name")), null);
                }
            }
            return true;
        }
        return isCheck;
    }
}

