/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.license;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.taxc.common.constant.LicenseCheckConstant;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.MD5;

public class LicenseGroupUtil {
    private static final Log LOGGER = LogFactory.getLog(LicenseGroupUtil.class);
    public static final int license_1 = 50;
    private static final String P_WORD = "";
    private static boolean TAXCB = true;
    private static boolean TAXCP = true;
    private static boolean TAXCM = true;
    private static Date date = DateUtils.stringToDate("2021-12-31");

    public static TreeNode getLicenseNum(TreeNode treeNode) {
        String groupId = treeNode.getId();
        if (null == groupId) {
            return null;
        }
        DynamicObjectCollection group = QueryServiceHelper.query((String)"tctb_license_group", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Integer.parseInt(groupId))});
        DynamicObjectCollection assignedCount = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Integer.parseInt(groupId)), new QFilter("licensestatus", "=", (Object)"B"), new QFilter("ver", "=", (Object)LicenseGroupUtil.getVersion())});
        int totalCount = LicenseGroupUtil.getTotalNumber(groupId + P_WORD);
        if (LicenseGroupUtil.isVer(LicenseGroupUtil.getVersion())) {
            if (group.size() > 0 && "38".equals(groupId)) {
                treeNode.setText(((DynamicObject)group.get(0)).getString("name") + "(" + assignedCount.size() + "/" + totalCount + ")");
            } else {
                String text = treeNode.getText();
                treeNode.setText(text);
            }
        } else if (group.size() > 0) {
            treeNode.setText(((DynamicObject)group.get(0)).getString("name") + "(" + assignedCount.size() + "/" + totalCount + ")");
        } else {
            treeNode.setText(treeNode.getText() + "(" + assignedCount.size() + "/" + totalCount + ")");
        }
        return treeNode;
    }

    public static String password(DynamicObject dos, String group) {
        String temp = group + P_WORD + dos.getString("orgid") + P_WORD + dos.getString("unifiedsocialcode") + P_WORD + dos.getString("licensestatus") + P_WORD;
        String md5 = MD5.md5(temp);
        return md5;
    }

    public static boolean getTAXB() {
        return TAXCB;
    }

    public static boolean getTaxcp() {
        return TAXCP;
    }

    public static boolean getTaxcm() {
        return TAXCM;
    }

    private static boolean isTime() {
        return new Date().getTime() > date.getTime();
    }

    public static String changeGruopid(String groupId) {
        if ("35".equals(groupId)) {
            return "87";
        }
        if ("37".equals(groupId)) {
            return "88";
        }
        if ("38".equals(groupId)) {
            return "406";
        }
        if ("39".equals(groupId)) {
            return "407";
        }
        return groupId;
    }

    public static int getTotalNumber(String groupId) {
        int sum = LicenseServiceHelper.getTotalNumber((Object)LicenseGroupUtil.changeGruopid(groupId + P_WORD));
        if ("1.0".equals(LicenseGroupUtil.getVersion()) && sum == 0) {
            sum = 50;
        }
        return sum;
    }

    public static LicenseCheckResult checkTxftPerformGroup() {
        return LicenseServiceHelper.checkPerformGroup((String)LicenseCheckConstant.getTXFTLicenseByBm());
    }

    public static LicenseCheckResult checkTxcdPerformGroup() {
        return LicenseServiceHelper.checkPerformGroup((String)LicenseCheckConstant.getTXCDLicenseByBm());
    }

    public static LicenseCheckResult checkQHZDSYPerformGroup() {
        return LicenseServiceHelper.checkPerformGroup((String)LicenseCheckConstant.getQHZDSYLicenseByBm());
    }

    public static LicenseCheckResult checkTCTSAPerformGroup() {
        return LicenseServiceHelper.checkPerformGroup((String)LicenseCheckConstant.getTCTSALicenseByBm());
    }

    public static LicenseCheckResult checkTamPerformGroup() {
        return LicenseServiceHelper.checkPerformGroup((String)LicenseCheckConstant.getTAMLicenseByBm());
    }

    public static LicenseCheckResult checkTAXBPerformGroup(String code) {
        if (LicenseGroupUtil.isVer(LicenseGroupUtil.getVersion())) {
            return LicenseGroupUtil.getLicenseCheckResult(code);
        }
        if ("3.0".equals(LicenseGroupUtil.getVersion())) {
            if (LicenseCheckConstant.getV3LicenseByAppid(code).equals("37")) {
                return LicenseServiceHelper.checkPerformGroup((String)"PRO_TAXM");
            }
            if (LicenseCheckConstant.getV3LicenseByAppid(code).equals("34")) {
                return LicenseServiceHelper.checkPerformGroup((String)"PRO_TAXB");
            }
            if (LicenseCheckConstant.getV3LicenseByAppid(code).equals("35")) {
                return LicenseServiceHelper.checkPerformGroup((String)"PRO_TAXP");
            }
            LicenseCheckResult s = new LicenseCheckResult();
            s.setHasLicense(Boolean.valueOf(true));
            return s;
        }
        LicenseCheckResult s = new LicenseCheckResult();
        s.setHasLicense(Boolean.valueOf(true));
        return s;
    }

    private static LicenseCheckResult getLicenseCheckResult(String code) {
        LicenseCheckResult s = LicenseServiceHelper.checkPerformGroup((String)"TAXB");
        if (s.getHasLicense().booleanValue()) {
            LOGGER.info("taxc-ProductVersion-code:" + code);
            String appid = P_WORD;
            if (StringUtils.isNotBlank((CharSequence)code)) {
                appid = BizAppServiceHelp.getAppIdByAppNumber((String)code.toUpperCase());
                LOGGER.info("taxc-ProductVersion-code1:" + appid);
                if (null == appid || P_WORD.equals(appid)) {
                    appid = BizAppServiceHelp.getAppIdByAppNumber((String)code);
                }
                LOGGER.info("taxc-ProductVersion-code2:" + appid);
            }
            return LicenseServiceHelper.checkLicenseModules((String)appid);
        }
        return s;
    }

    public static String getVersion() {
        int modetype = 3;
        try {
            modetype = LicenseServiceHelper.getModeType();
        }
        catch (Exception e) {
            LOGGER.error(" LicenseServiceHelper.getModeType():" + e);
        }
        String ver = LicenseServiceHelper.getProductVersion();
        LOGGER.info("taxc-ProductVersion-:" + modetype + ";ver:" + ver);
        if (modetype == 4 || modetype == 2) {
            String finalVer = ver;
            ver = LicenseServiceHelper.getProductInfos().stream().peek(LicenseGroupUtil.getMapConsumer()).filter(s -> ((String)s.get("softwarename")).contains(ResManager.loadKDString((String)"\u661f\u7a7a", (String)"LicenseGroupUtil_0", (String)"taxc-tctb-common", (Object[])new Object[0]))).map(s -> (String)s.get("productversion")).findFirst().orElseGet(() -> finalVer);
            if ("1.0".equals(ver)) {
                return "4.0";
            }
            if ("2.0".equals(ver)) {
                return "5.0";
            }
            if ("2.1".equals(ver) || "2.2".equals(ver)) {
                return "6.0";
            }
            return "4.0";
        }
        if (modetype == 3) {
            String finalVer = ver;
            ver = LicenseServiceHelper.getProductInfos().stream().peek(LicenseGroupUtil.getMapConsumer()).filter(s -> ((String)s.get("softwarename")).contains(ResManager.loadKDString((String)"\u661f\u701a", (String)"LicenseGroupUtil_1", (String)"taxc-tctb-common", (Object[])new Object[0]))).map(s -> (String)s.get("productversion")).findFirst().orElseGet(() -> finalVer);
            if (LicenseGroupUtil.isVer(ver)) {
                return ver;
            }
            return "3.0";
        }
        return ver;
    }

    public static Consumer<Map<String, String>> getMapConsumer() {
        return s -> LOGGER.info("softwarename=" + (String)s.get("softwarename") + ",productversion=" + (String)s.get("productversion"));
    }

    public static Map<String, String> getGmLicense() {
        String ver = LicenseGroupUtil.getVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        if (LicenseGroupUtil.isVer(ver)) {
            HashMap<String, String> groupName = new HashMap<String, String>();
            HashMap<String, String> bizlist = new HashMap<String, String>();
            Set set = LicenseServiceHelper.getLicenseModules();
            HashMap<String, String> setmap = new HashMap<String, String>();
            LOGGER.info("taxc-ProductVersion-set:" + set);
            if (null != set) {
                LOGGER.info("taxc-ProductVersion-set:" + set.size());
                for (Object s : set) {
                    setmap.put(((String)s).toLowerCase(), ((String)s).toLowerCase());
                    LOGGER.info("taxc-LicenseGroupUtil-s:" + ((String)s).toLowerCase());
                }
            }
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_license_group", (String)"id,number", null);
            for (Object d : doc) {
                if (!d.getString("id").toLowerCase().startsWith("38")) continue;
                LOGGER.info("taxc-LicenseGroupUtil-groupName:" + d.getString("number").toLowerCase() + ";" + d.getString("id").toLowerCase());
                groupName.put(d.getString("number").toLowerCase(), d.getString("id").toLowerCase());
            }
            if (groupName.size() > 0) {
                DynamicObjectCollection bizap = BizAppServiceHelp.getAllBizApps();
                for (DynamicObject biz : bizap) {
                    LOGGER.info("taxc-LicenseGroupUtil-number:" + biz.getString("number").toLowerCase() + ";" + biz.getString("id").toLowerCase());
                    if (null == groupName.get(biz.getString("number").toLowerCase())) continue;
                    bizlist.put(biz.getString("id").toLowerCase(), biz.getString("number").toLowerCase());
                }
            }
            for (Map.Entry s : bizlist.entrySet()) {
                String value;
                LOGGER.info("taxc-LicenseGroupUtil:" + (String)s.getKey() + ";" + (String)s.getValue());
                if (null == setmap.get(s.getKey()) || null == (value = (String)groupName.get(s.getValue()))) continue;
                LOGGER.info("taxc-LicenseGroupUtil:" + value);
                map.put(value, value);
            }
        }
        return map;
    }

    public static boolean isVer(String ver) {
        return ver.equals("4.0") || ver.equals("5.0") || ver.equals("6.0");
    }
}

