/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.DateUtils;

public class NrslxUpdateTask
extends AbstractTask {
    String NORMAL_SELECT_FIELD = "org.id,modifydate,entryentity.modifycontexttitle,entryentity.modifycontexttitleysjbs,entryentity.modifycontexbefore,entryentity.modifycontexbeforecode,entryentity.modifycontexafter,entryentity.modifycontexaftercode,modifier";

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        Date firstDate = DateUtils.getFirstDateOfMonth(new Date());
        String firstDateStr = DateUtils.format(firstDate);
        QFilter q1 = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter q2 = new QFilter("entryentity.modifycontexttitleysjbs", "=", (Object)"taxenddate");
        QFilter q3 = new QFilter("entryentity.modifycontexafter", "=", (Object)firstDateStr);
        DynamicObject[] versionList = BusinessDataServiceHelper.load((String)"tctb_tax_ver_normal", (String)this.NORMAL_SELECT_FIELD, (QFilter[])new QFilter[]{q1, q2, q3});
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>(versionList.length);
        for (DynamicObject dynamicObject : versionList) {
            DynamicObjectCollection entityList = dynamicObject.getDynamicObjectCollection("entryentity");
            OrgParam orgParam = new OrgParam();
            HashMap<String, String> propertyMap = new HashMap<String, String>(8);
            for (DynamicObject entity : entityList) {
                String effectiveDate;
                if (Objects.equals("taxenddate", entity.getString("modifycontexttitleysjbs")) && Objects.equals(firstDateStr, effectiveDate = entity.getString("modifycontexafter"))) {
                    Long orgid = dynamicObject.getLong("org.id");
                    orgParam.setId(orgid.longValue());
                }
                if (!Objects.equals("taxpayertype", entity.getString("modifycontexttitleysjbs"))) continue;
                String taxPayertype = entity.getString("modifycontexaftercode");
                if (Objects.equals("ybnsr", taxPayertype)) {
                    propertyMap.put("taxpayertype", "1");
                    continue;
                }
                if (!Objects.equals("xgmnsr", taxPayertype)) continue;
                propertyMap.put("taxpayertype", "2");
            }
            orgParam.setPropertyMap(propertyMap);
            orgParams.add(orgParam);
        }
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.addOrUpdate(orgParams);
    }
}

