/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.taxorg.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.common.util.TreeUtils;
import kd.taxc.taxorg.validator.QuoteOrgEntityEnum;

public class TaxorgQuoteValidator {
    public static final String BOS_ENTITYOBJECT = "bos_entityobject";

    public static QuoteOrgEntityEnum validatorTaxOrgQuote(List<Long> orgIds) {
        List ids = Arrays.stream(QuoteOrgEntityEnum.values()).map(o -> o.getEntityName()).collect(Collectors.toList());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BOS_ENTITYOBJECT, (String)"number,id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (null != collection && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                QFilter[] qFilter;
                String entityName = ((DynamicObject)collection.get(i)).getString("number");
                if (!StringUtil.isNotEmpty((CharSequence)EntityMetadataCache.getDataEntityType((String)entityName).getAlias())) continue;
                QuoteOrgEntityEnum entityEnum = QuoteOrgEntityEnum.getQuoteEntityEnumByEntityName(entityName);
                String[] fields = StringUtil.split((String)entityEnum.getSelectFields(), (String)",");
                QFilter fieldsQ = QFilter.isNotNull((String)"id");
                if (fields.length == 1) {
                    fieldsQ.and(new QFilter(fields[0], "in", orgIds));
                } else if (fields.length > 1) {
                    qFilter = new QFilter(fields[0], "in", orgIds);
                    for (int j = 1; j < fields.length; ++j) {
                        String field = fields[j];
                        qFilter.or(new QFilter(field, "in", orgIds));
                    }
                    fieldsQ.and((QFilter)qFilter);
                } else {
                    fieldsQ.and(QFilter.isNull((String)"id"));
                }
                qFilter = new QFilter[]{fieldsQ};
                if (!QueryServiceHelper.exists((String)entityName, (QFilter[])qFilter)) continue;
                return entityEnum;
            }
        }
        return null;
    }

    public static List<Long> getChildrenNodeIds(List<Long> orgIds) {
        Map<String, Map<String, String>> viewTreeMap = OrgUtils.getAllOrgByViewId(Long.parseLong("40"));
        TreeNode viewRoot = OrgUtils.createTreeNode(viewTreeMap);
        ArrayList childNodes = new ArrayList();
        orgIds.stream().forEach(node -> {
            TreeNode parentNode = viewRoot.getTreeNode(String.valueOf(node), 10);
            childNodes.addAll(TreeUtils.getChildIdList(parentNode));
        });
        List childNodesTemp = childNodes.stream().map(o -> Long.valueOf(o)).collect(Collectors.toList());
        orgIds.addAll(childNodesTemp);
        return orgIds;
    }
}

