/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.common.util.DBUtils;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.OrgUtils;
import kd.taxc.tctb.common.vo.OrgTakeRelationVo;

public class TaxOrgTakeRelationServiceHelper {
    private static final String TCTB_ORG_TAKEDATA = "tctb_org_takedata";
    private static final String ORGRELATION_SELECTSQL = "select fid  from T_ORG_OrgRelation where ftyperelationid = 1234103052718327808 ";
    private static final long TYPERELATION_TAX = 1234103052718327808L;
    private static final String BOS_ORG_ORGRELATION = "bos_org_orgrelation";

    public static List<DynamicObject> getOrgTakeRelation(Long taxOrgId, Date date) {
        if (TaxOrgTakeRelationServiceHelper.isNewOrgrelation()) {
            return TaxOrgTakeRelationServiceHelper.getOrgTakeRelationNew(taxOrgId, date);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (ObjectUtils.isEmpty((Object)taxOrgId)) {
            return list;
        }
        QFilter taxOrgIdQFilter = new QFilter("taxorg", "=", (Object)taxOrgId);
        QFilter startDateQFilter = new QFilter("startdate", "<=", (Object)date);
        if (QueryServiceHelper.exists((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
            DynamicObject[] accountOrgs;
            for (DynamicObject accountObject : accountOrgs = BusinessDataServiceHelper.load((String)TCTB_ORG_TAKEDATA, (String)"accountorg,startdate,enddate", (QFilter[])new QFilter[]{taxOrgIdQFilter, startDateQFilter})) {
                DynamicObject accountOrg = (DynamicObject)accountObject.get("accountorg");
                Date endDate = accountObject.getDate("enddate");
                if (!ObjectUtils.isEmpty((Object)endDate) && endDate.compareTo(date) >= 0) {
                    list.add(accountOrg);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)endDate)) continue;
                list.add(accountOrg);
            }
        } else {
            DynamicObject taxOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxOrgId)});
            list.add(taxOrg);
        }
        return list;
    }

    public static List<DynamicObject> getOrgTakeRelationNew(Long taxOrgId, Date date) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (ObjectUtils.isEmpty((Object)taxOrgId)) {
            return list;
        }
        List orgIds = OrgUnitServiceHelper.getFromOrgs((String)"40", (Long)taxOrgId, (String)"10");
        DynamicObject taxOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIds)});
        list.add(taxOrg);
        return list;
    }

    public static List<Long> getOrgTakeRelation(List<Long> taxOrgId, Date startdate, Date enddate) {
        if (TaxOrgTakeRelationServiceHelper.isNewOrgrelation()) {
            return TaxOrgTakeRelationServiceHelper.getOrgTakeRelationNew(taxOrgId, startdate, enddate);
        }
        List<Long> list = new ArrayList<Long>();
        if (ObjectUtils.isEmpty(taxOrgId)) {
            return list;
        }
        QFilter taxOrgIdQFilter = new QFilter("taxorg", "in", taxOrgId);
        QFilter startDateQFilter = new QFilter("startdate", "<=", (Object)startdate).and(new QFilter("enddate", ">=", (Object)enddate).or(new QFilter("enddate", "is null", null)));
        if (QueryServiceHelper.exists((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
            DynamicObject[] accountOrgs = BusinessDataServiceHelper.load((String)TCTB_ORG_TAKEDATA, (String)"accountorg,startdate,enddate", (QFilter[])new QFilter[]{taxOrgIdQFilter, startDateQFilter});
            list = Arrays.stream(accountOrgs).map(a -> a.getDynamicObject("accountorg").getLong("id")).collect(Collectors.toList());
        } else {
            DynamicObject taxOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", taxOrgId)});
            list.add(null != taxOrg ? taxOrg.getLong("id") : Long.parseLong("0"));
        }
        return list;
    }

    public static List<Long> getOrgTakeRelationNew(List<Long> taxOrgId, Date startdate, Date enddate) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (ObjectUtils.isEmpty(taxOrgId)) {
            return list;
        }
        taxOrgId.stream().forEach(orgId -> list.addAll(OrgUnitServiceHelper.getFromOrgs((String)"40", (Long)orgId, (String)"10")));
        DynamicObject[] taxOrg = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
        if (null != taxOrg && taxOrg.length > 0) {
            List temList = Arrays.stream(taxOrg).map(o -> o.getLong("id")).collect(Collectors.toList());
            list.addAll(temList);
        } else {
            list.add(0L);
        }
        return list;
    }

    public static List<Long> getTaxOrgByAccountingOrgs(List<Long> accountingOrg, Date date) {
        if (TaxOrgTakeRelationServiceHelper.isNewOrgrelation()) {
            return TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrgsNew(accountingOrg, date);
        }
        ArrayList<Long> list = new ArrayList<Long>();
        if (ObjectUtils.isEmpty(accountingOrg)) {
            return list;
        }
        List<Long> taxOrgByAccountingOrg = TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrg(accountingOrg, date);
        if (taxOrgByAccountingOrg != null) {
            list.addAll(taxOrgByAccountingOrg);
        }
        return list;
    }

    public static List<Long> getTaxOrgByAccountingOrgsNew(List<Long> accountingOrg, Date date) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (ObjectUtils.isEmpty(accountingOrg)) {
            return list;
        }
        accountingOrg.stream().forEach(accountingOrgId -> list.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"40", (Long)accountingOrgId)));
        return list;
    }

    public static List<Long> getTaxOrgByAccountingOrg(Long accountingOrg, Date date) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (TaxOrgTakeRelationServiceHelper.isNewOrgrelation()) {
            return TaxOrgTakeRelationServiceHelper.getTaxOrgByAccountingOrgNew(accountingOrg, date);
        }
        if (ObjectUtils.isEmpty((Object)accountingOrg)) {
            return list;
        }
        Map<String, DynamicObject> allOrgByView = OrgUtils.getAllOrgByView(OrgUtils.getDefaultViewSchemaInfoId(), new QFilter("org.id", "=", (Object)accountingOrg));
        if (allOrgByView.get(accountingOrg.toString()) != null) {
            list.add(accountingOrg);
        }
        QFilter taxOrgIdQFilter = new QFilter("accountorg", "=", (Object)accountingOrg);
        QFilter startDateQFilter = new QFilter("startdate", "<=", (Object)date).and(QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)date));
        if (QueryServiceHelper.exists((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
            DynamicObject[] taxOrg = BusinessDataServiceHelper.load((String)TCTB_ORG_TAKEDATA, (String)"taxorg,startdate,enddate", (QFilter[])new QFilter[]{taxOrgIdQFilter, startDateQFilter});
            list.addAll(Arrays.stream(taxOrg).map(a -> a.getLong("taxorg.id")).collect(Collectors.toList()));
        }
        return list;
    }

    public static List<Long> getTaxOrgByAccountingOrgNew(Long accountingOrg, Date date) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (ObjectUtils.isEmpty((Object)accountingOrg)) {
            return list;
        }
        list.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"40", (Long)accountingOrg));
        return list;
    }

    public static List<OrgTakeRelationVo> getAccountingOrgByTaxOrg(Long taxOrgId, Date startDate, Date endDate) {
        if (TaxOrgTakeRelationServiceHelper.isNewOrgrelation()) {
            return TaxOrgTakeRelationServiceHelper.getAccountingOrgByTaxOrgNew(taxOrgId, startDate, endDate);
        }
        ArrayList<OrgTakeRelationVo> list = new ArrayList<OrgTakeRelationVo>();
        if (null == taxOrgId) {
            return list;
        }
        QFilter taxOrgIdQFilter = new QFilter("taxorg", "=", (Object)taxOrgId);
        if (QueryServiceHelper.exists((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
            DynamicObject[] orgTake;
            for (DynamicObject object : orgTake = BusinessDataServiceHelper.load((String)TCTB_ORG_TAKEDATA, (String)"taxorg,accountorg,startdate,enddate", (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
                Date accountEndDate;
                Long taxOrg = object.getDynamicObject("taxorg").getLong("id");
                Long accountOrg = object.getDynamicObject("accountorg").getLong("id");
                Date accountStartDate = object.getDate("startdate");
                Date[] date = DateUtils.getIntersectionDate(startDate, endDate, accountStartDate, accountEndDate = object.getDate("enddate"));
                if (null == date) continue;
                OrgTakeRelationVo vo = new OrgTakeRelationVo(taxOrg, accountOrg, date[0], date[1]);
                list.add(vo);
            }
        } else {
            OrgTakeRelationVo vo = new OrgTakeRelationVo(taxOrgId, taxOrgId, startDate, endDate);
            list.add(vo);
        }
        return list;
    }

    public static List<OrgTakeRelationVo> getAccountingOrgByTaxOrgNew(Long taxOrgId, Date startDate, Date endDate) {
        ArrayList<OrgTakeRelationVo> list = new ArrayList<OrgTakeRelationVo>();
        if (null == taxOrgId) {
            return list;
        }
        List ids = OrgUnitServiceHelper.getFromOrgs((String)"40", (Long)taxOrgId, (String)"10");
        if (null != ids && ids.size() > 0) {
            ids.stream().forEach(accountOrg -> list.add(new OrgTakeRelationVo(taxOrgId, (Long)accountOrg, startDate, endDate)));
        } else {
            OrgTakeRelationVo vo = new OrgTakeRelationVo(taxOrgId, taxOrgId, startDate, endDate);
            list.add(vo);
        }
        return list;
    }

    public static List<OrgTakeRelationVo> getAccountingOrgByTaxOrgBatch(List<OrgTakeRelationVo> relationVos) {
        if (TaxOrgTakeRelationServiceHelper.isNewOrgrelation()) {
            return TaxOrgTakeRelationServiceHelper.getAccountingOrgByTaxOrgBatchNew(relationVos);
        }
        ArrayList<OrgTakeRelationVo> list = new ArrayList<OrgTakeRelationVo>();
        if (ObjectUtils.isEmpty(relationVos)) {
            return list;
        }
        List taxOrgList = relationVos.stream().map(o -> o.getTaxOrgId()).collect(Collectors.toList());
        Map<Long, OrgTakeRelationVo> map = relationVos.stream().collect(Collectors.toMap(o -> o.getTaxOrgId(), b -> b));
        QFilter taxOrgIdQFilter = new QFilter("taxorg", "in", taxOrgList);
        if (QueryServiceHelper.exists((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
            DynamicObject[] orgTake;
            for (DynamicObject object : orgTake = BusinessDataServiceHelper.load((String)TCTB_ORG_TAKEDATA, (String)"taxorg,accountorg,startdate,enddate", (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
                Date[] date;
                Long taxOrg = object.getDynamicObject("taxorg").getLong("id");
                Long accountOrg = object.getDynamicObject("accountorg").getLong("id");
                Date accountStartDate = object.getDate("startdate");
                Date accountEndDate = object.getDate("enddate");
                OrgTakeRelationVo currentVo = map.get(taxOrg);
                if (null == currentVo || null == (date = DateUtils.getIntersectionDate(currentVo.getStartDate(), currentVo.getEndDate(), accountStartDate, accountEndDate))) continue;
                OrgTakeRelationVo vo = new OrgTakeRelationVo(taxOrg, accountOrg, date[0], date[1]);
                list.add(vo);
            }
            List existOrg = Arrays.stream(orgTake).map(o -> o.getDynamicObject("taxorg").getLong("id")).distinct().collect(Collectors.toList());
            List noExistList = relationVos.stream().filter(o -> !existOrg.contains(o.getTaxOrgId())).collect(Collectors.toList());
            list.addAll(noExistList);
        } else {
            list.addAll(relationVos);
        }
        return list;
    }

    public static List<OrgTakeRelationVo> getAccountingOrgByTaxOrgBatchNew(List<OrgTakeRelationVo> relationVos) {
        ArrayList<OrgTakeRelationVo> list = new ArrayList<OrgTakeRelationVo>();
        if (ObjectUtils.isEmpty(relationVos)) {
            return list;
        }
        Map<Long, OrgTakeRelationVo> sourceMap = relationVos.stream().collect(Collectors.toMap(o -> o.getTaxOrgId(), b -> b));
        HashMap map = new HashMap();
        relationVos.stream().forEach(vo -> map.put(vo.getTaxOrgId(), OrgUnitServiceHelper.getFromOrgs((String)"40", (Long)vo.getTaxOrgId(), (String)"10")));
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                Long taxOrgId = (Long)entry.getKey();
                List accountOrgIdList = (List)entry.getValue();
                if (null == accountOrgIdList) continue;
                accountOrgIdList.stream().forEach(id -> list.add(new OrgTakeRelationVo(taxOrgId, (Long)id, ((OrgTakeRelationVo)sourceMap.get(taxOrgId)).getStartDate(), ((OrgTakeRelationVo)sourceMap.get(taxOrgId)).getEndDate())));
            }
        } else {
            list.addAll(relationVos);
        }
        return list;
    }

    public static List<Long> getTaxOrgByAccountingOrg(List<Long> accountingOrgList, Date date) {
        if (ObjectUtils.isEmpty(accountingOrgList)) {
            return null;
        }
        Set<Object> set = new HashSet();
        Map<String, DynamicObject> allOrgByView = OrgUtils.getAllOrgByView(OrgUtils.getLocalDefaultViewId(), new QFilter("org.id", "in", accountingOrgList));
        if (allOrgByView.size() > 0) {
            set = allOrgByView.values().stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        }
        QFilter taxOrgIdQFilter = new QFilter("accountorg", "in", accountingOrgList);
        QFilter startDateQFilter = new QFilter("startdate", "<=", (Object)date).and(QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)date));
        if (QueryServiceHelper.exists((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[]{taxOrgIdQFilter})) {
            DynamicObject[] taxOrg = BusinessDataServiceHelper.load((String)TCTB_ORG_TAKEDATA, (String)"taxorg,startdate,enddate", (QFilter[])new QFilter[]{taxOrgIdQFilter, startDateQFilter});
            set.addAll(Arrays.stream(taxOrg).map(a -> a.getLong("taxorg.id")).collect(Collectors.toSet()));
        }
        return new ArrayList<Long>(set);
    }

    private static boolean isNewOrgrelation() {
        List<Map<String, Object>> list = DBUtils.query(DBRoute.basedata.getRouteKey(), ORGRELATION_SELECTSQL);
        return !CollectionUtils.isEmpty(list);
    }
}

