/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.common.util.StringUtil;

public class TaxOrgUnitServiceHelper {
    private static final String[] ORG_MUSTFIELDS = new String[]{"accountingstandards", "registertype", "registertime", "codeandname", "registeraddress", "actualaddress", "taxoffice"};

    public static List<OrgParam> deleteDuty(List<Long> orgIds, String viewSchemaNumber) {
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>();
        if (null != orgIds) {
            orgIds.stream().forEach(orgId -> {
                OrgParam orgParam = new OrgParam();
                orgParam.setId(orgId.longValue());
                orgParam.setDuty(viewSchemaNumber);
                paramList.add(orgParam);
            });
        }
        OrgUnitServiceHelper.deleteDuty(paramList);
        return paramList;
    }

    public static boolean validationTaxOrgMustInput(IFormView getView, Long orgId, String name, boolean needErrorMsg) {
        String info = name;
        QFilter istaxpayerQ = new QFilter("istaxpayer", "=", (Object)"1");
        QFilter orgQ = new QFilter("org", "=", (Object)orgId);
        if (!QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{istaxpayerQ, orgQ})) {
            if (needErrorMsg) {
                getView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u4e0d\u662f\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u4e0d\u80fd\u8fdb\u884c\u8ba1\u7a0e\u548c\u7533\u62a5\uff0c\u5982\u9700\u64cd\u4f5c\u8bf7\u5c06\u7a0e\u52a1\u7ec4\u7ec7\u8c03\u6574\u4e3a\u7eb3\u7a0e\u4e3b\u4f53\u3002", (String)"TaxOrgUnitServiceHelper_0", (String)"taxc-tctb-common", (Object[])new Object[0]), info));
            }
            return true;
        }
        QFilter taxorgQ = new QFilter("taxorg", "=", (Object)orgId);
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)StringUtil.join((Object[])ORG_MUSTFIELDS, (String)","), (QFilter[])new QFilter[]{taxorgQ});
        if (null == org) {
            if (needErrorMsg) {
                getView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxOrgUnitServiceHelper_1", (String)"taxc-tctb-common", (Object[])new Object[0]), info));
            }
            return true;
        }
        for (String orgMustfield : ORG_MUSTFIELDS) {
            if (!StringUtil.isBlank((CharSequence)org.getString(orgMustfield))) continue;
            if (needErrorMsg) {
                getView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxOrgUnitServiceHelper_2", (String)"taxc-tctb-common", (Object[])new Object[0]), info));
            }
            return true;
        }
        return false;
    }
}

