/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.unittest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.StringUtil;

public class UnitTestCommonUtils {
    public static final void deleteTestData(String entity, QFilter[] qFilter) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)"id", (QFilter[])qFilter);
        if (null != dynamicObjects && dynamicObjects.length > 0) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            for (DynamicObject dynamicObject : dynamicObjects) {
                BusinessDataServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])new Object[]{dynamicObject.get("id")});
            }
        }
    }

    public static final void exist(String entity, QFilter[] qFilter, Consumer consumer, String msg) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)"id", (QFilter[])qFilter);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            consumer.accept(msg);
        }
    }

    public static final String getPageId(String str) {
        Pattern p;
        Matcher m;
        if (Pattern.matches(".*error.*", str)) {
            throw new RuntimeException(str);
        }
        List results = (List)SerializationUtils.fromJsonString((String)str, List.class);
        String pageId = "";
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                if (!(result.get(j) instanceof Map) || !(map = (Map)result.get(j)).containsKey("pageId")) continue;
                pageId = (String)map.get("pageId");
            }
        }
        if (StringUtil.isEmpty((CharSequence)pageId) && (m = (p = Pattern.compile(",\"pageId\":\"(.+?)\"")).matcher(str)).find()) {
            pageId = m.group(1);
        }
        return pageId;
    }

    public static final String getPageId(String str, int seq) {
        if (Pattern.matches(".*error.*", str)) {
            throw new RuntimeException(str);
        }
        String pageId = "";
        Pattern p = Pattern.compile(",\"pageId\":\"(.+?)\"");
        Matcher m = p.matcher(str);
        if (m.find()) {
            pageId = m.group(seq);
        }
        return pageId;
    }

    public static final String getPageId(String str, String formId) {
        Pattern p;
        Matcher m;
        if (Pattern.matches(".*error.*", str)) {
            throw new RuntimeException(str);
        }
        List results = (List)SerializationUtils.fromJsonString((String)str, List.class);
        String pageId = "";
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                if (!(result.get(j) instanceof Map) || !(map = (Map)result.get(j)).containsKey("pageId") || !map.containsKey("formId") || !Objects.equals(formId, map.get("formId"))) continue;
                pageId = (String)map.get("pageId");
            }
        }
        if (StringUtil.isEmpty((CharSequence)pageId) && (m = (p = Pattern.compile(",\"pageId\":\"(.+?)\"")).matcher(str)).find()) {
            pageId = m.group(1);
        }
        return pageId;
    }
}

