/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class SystemParamUtil {
    public static Object getAppParameter(String appNumber, String paramKey) {
        long orgId = RequestContext.get().getOrgId();
        return SystemParamUtil.getAppParameter(appNumber, paramKey, orgId);
    }

    public static Object getAppParameter(String appNumber, String paramKey, long orgId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        apm.setOrgId(Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)paramKey);
    }

    public static void saveAppParameter(String appNumber, Map<String, Object> paramMap) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        long orgId = RequestContext.get().getOrgId();
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        apm.setOrgId(Long.valueOf(orgId));
        apm.setViewType("40");
        SystemParamServiceHelper.saveAppParameter((AppParam)apm, paramMap);
    }

    public static Map<Long, Object> getAppParameterBatch(String appNumber, String paramKey, List<Long> orgIds) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        Map orgFromCache = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)apm, orgIds);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        orgFromCache.forEach((k, v) -> map.put(Long.parseLong(k), v.get(paramKey)));
        return map;
    }

    public static boolean isOverseasTaxOrg(Long orgId) {
        boolean isEnable = false;
        Object overseasTax = SystemParamUtil.getAppParameter("tctb", "enableoverseastax", orgId);
        if (overseasTax instanceof Boolean && ((Boolean)overseasTax).booleanValue()) {
            isEnable = true;
        }
        return isEnable;
    }
}

