/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;

public class TaxValidGetUtils {
    public static List<Long> getValidTaxationsys() {
        TaxResult result = TaxAtionsysDataServiceHelper.queryValidTaxationsys();
        if (result != null && result.isSuccess()) {
            return (List)result.getData();
        }
        return new ArrayList<Long>(0);
    }

    public static Map<Long, DynamicObject> getTaxationsysMap() {
        TaxResult result = TaxAtionsysDataServiceHelper.queryTaxAtionsysByIds(null);
        if (result != null && result.isSuccess()) {
            return ((List)result.getData()).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        }
        return new HashMap<Long, DynamicObject>(0);
    }

    public static List<Long> getValidTaxType(long taxsystemid) {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>();
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("taxationsysid", "=", (Object)taxsystemid).and("activedate", "<=", (Object)new Date());
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"id,number,expdate", (QFilter[])new QFilter[]{filter})) {
            if (bd.getDate("expdate") != null && bd.getDate("expdate").getTime() < new Date().getTime()) continue;
            bids.add(bd.getLong("id"));
        }
        return bids;
    }

    public static String getChinaTaxSystem() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_taxationsys", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"001")});
        if (dynamicObject != null) {
            return dynamicObject.getString("id");
        }
        return null;
    }
}

