/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.baseinfo.item;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.util.TaxValidGetUtils;

public class ProvistonItemPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxtype = (BasedataEdit)this.getControl("taxtype");
        taxtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxsystem = (BasedataEdit)this.getControl("taxsystem");
        taxsystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String sys = this.getModel().getDataEntity().getString("systemset");
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (pkValue != null && !"0".equals(pkValue.toString())) {
            if (StringUtil.isNotEmpty((CharSequence)sys) && "1".equalsIgnoreCase(sys)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "taxsystem", "taxtype", "save"});
            }
            long currUserId = RequestContext.get().getCurrUserId();
            long orgId = RequestContext.get().getOrgId();
            HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"itp", (String)"itp_proviston_item", (String)"4715a0df000000ac", (Long)currUserId);
            if (!allPermOrgsByUserId.hasAllOrgPerm() && !allPermOrgsByUserId.getHasPermOrgs().contains(orgId)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        List validTaxType = null;
        if ("taxtype".equalsIgnoreCase(name)) {
            Object taxsystem = this.getModel().getValue("taxsystem");
            if (taxsystem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"ProvistonItemPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long id = ((DynamicObject)taxsystem).getLong("id");
            validTaxType = TaxValidGetUtils.getValidTaxType((long)id);
        } else if ("taxsystem".equalsIgnoreCase(name)) {
            validTaxType = TaxValidGetUtils.getValidTaxationsys();
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = new QFilter("id", "in", (Object)validTaxType);
        listShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxsystem".equalsIgnoreCase(name)) {
            this.getModel().setValue("taxtype", null);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        if (sourceData.get("number") == null) {
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"itp_proviston_item");
            String number = codeRuleService.readNumber("itp_proviston_item", dataInfo, null);
            sourceData.put("number", number);
        }
    }
}

