/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.baseinfo.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.enums.provision.TaxPlanCfgEnum;
import kd.taxc.tctb.business.provision.ProvisionPlanBusiness;
import kd.taxc.util.TaxValidGetUtils;

public class ProvistonPlanListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        for (QFilter q : filters) {
            if (q.getProperty().equals("planuse")) {
                this.rewritePlanUseFilter(q);
            }
            for (QFilter.QFilterNest nest : q.getNests(true)) {
                QFilter nestQ = nest.getFilter();
                if (!nestQ.getProperty().equals("planuse")) continue;
                this.rewritePlanUseFilter(nestQ);
            }
        }
    }

    private void rewritePlanUseFilter(QFilter q) {
        Object val = q.getValue();
        if (!(val instanceof String)) {
            return;
        }
        String v = (String)val;
        if (v.contains("1") && v.contains("2")) {
            q.__setCP("=");
            q.__setValue((Object)",1,2,");
            q.or("planuse", "=", (Object)",2,1,");
        } else if (v.contains("1")) {
            q.__setCP("like");
            q.__setValue((Object)"%1%");
        } else if (v.contains("2")) {
            q.__setCP("like");
            q.__setValue((Object)"%2%");
        } else {
            q.__setProperty("1");
            q.__setCP("=");
            q.__setValue((Object)1);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("taxsystem.id".equals(args.getFieldName())) {
            Set<String> supportTaxsysNumber = this.getSupportTaxsysNumber();
            args.getQfilters().add(new QFilter("number", "in", supportTaxsysNumber));
        }
    }

    private Set<String> getSupportTaxsysNumber() {
        Set<String> supportTaxsysNumber = Arrays.stream(TaxPlanCfgEnum.values()).map(item -> item.getTaxsysCode()).collect(Collectors.toSet());
        return supportTaxsysNumber;
    }

    private List<Object[]> getSupportTaxsysName() {
        Set<String> supportTaxsysNumber = this.getSupportTaxsysNumber();
        ArrayList<String> nums = new ArrayList<String>(10);
        nums.addAll(supportTaxsysNumber);
        TaxResult r = TaxAtionsysDataServiceHelper.queryTaxAtionsysByNums(nums);
        if (r.isSuccess()) {
            ArrayList<Object[]> list = new ArrayList<Object[]>(10);
            for (DynamicObject dyn : (List)r.getData()) {
                Object[] info = new Object[]{dyn.getLong("id"), dyn.getString("name"), dyn.getString("number")};
                list.add(info);
            }
            return list;
        }
        return new ArrayList<Object[]>(0);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            ListShowParameter listShowParameter;
            String fieldName = column.getFieldName();
            if (!"taxsystem.name".equals(fieldName)) continue;
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            typeColumn.getComboItems().clear();
            List<Object[]> taxsysInfos = this.getSupportTaxsysName();
            taxsysInfos.forEach(info -> typeColumn.getComboItems().add(new ComboItem(new LocaleString((String)info[1]), "" + info[0])));
            boolean needDefault = true;
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            if (showParameter instanceof ListShowParameter && (listShowParameter = (ListShowParameter)showParameter).isLookUp()) {
                needDefault = false;
            }
            if (!needDefault) continue;
            String chinaTaxSystem = TaxValidGetUtils.getChinaTaxSystem();
            typeColumn.setDefaultValue(chinaTaxSystem);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opt = (FormOperate)args.getSource();
        String operateKey = opt.getOperateKey();
        if ("specified_sharing".equalsIgnoreCase(operateKey)) {
            DynamicObject[] plans;
            List ids = Stream.of(args.getListSelectedData().getPrimaryKeyValues()).map(v -> Long.valueOf(v.toString())).collect(Collectors.toList());
            for (DynamicObject plan : plans = ProvisionPlanBusiness.queryProvisionPlanByIds(ids)) {
                if (StringUtil.equalsIgnoreCase((CharSequence)plan.getString("enable"), (CharSequence)"1")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u7528\u7684\u6570\u636e\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ProvistonPlanListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void dealMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if ("specified_sharing".equalsIgnoreCase(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tctb_jtfa_shareplan", (boolean)true);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "specified_sharing"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"specified_sharing") && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            List ids;
            ListSelectedRowCollection returnDataRows = (ListSelectedRowCollection)returnData;
            List sharePlanIds = returnDataRows.stream().map(v -> Long.valueOf(v.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            OperationResult operationResult = ProvisionPlanBusiness.specifiedSharing(sharePlanIds, ids = this.getSelectedRows().stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList()));
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"ProvistonPlanListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            } else {
                String operName = ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848", (String)"ProvistonPlanListPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                this.getView().showOperationResult(operationResult, operName);
            }
        }
    }
}

