/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.baseinfo.plan;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.PermissionUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.enums.provision.TaxPlanCfgEnum;
import kd.taxc.tctb.business.provision.ProvisionPlanBusiness;

public class ProvistonPlanPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String KEY_PLANUSE = "planuse";
    private static final String KEY_TAXSYSTEM = "taxsystem";
    private static final String KEY_TAXTYPE = "taxtype";
    private static final String KEY_TAXAREA = "taxarea";
    private static final String KEY_CYCLE = "cycle";
    private static final String KEY_ISDIMPROVISION = "isdimprovision";
    private static final String KEY_PROVISIONDIMENSION = "provisiondimension";
    private static final String KEY_BUSINESSDIMENSION = "businessdimension";
    private static final String KEY_BOOKTYPE = "booktype";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("startdate", (Object)DateUtils.stringToDate((String)"2000-01-01"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxtype = (BasedataEdit)this.getControl(KEY_TAXTYPE);
        taxtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxsystem = (BasedataEdit)this.getControl(KEY_TAXSYSTEM);
        taxsystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxarea = (BasedataEdit)this.getControl(KEY_TAXAREA);
        taxarea.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit businessdimension = (MulBasedataEdit)this.getControl(KEY_BUSINESSDIMENSION);
        businessdimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.settingCycle();
        this.settingSisdimprovision();
        this.settingTaxArea();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String sys = this.getModel().getDataEntity().getString("systemset");
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (pkValue != null && !"0".equals(pkValue.toString())) {
            if (StringUtil.isNotEmpty((CharSequence)sys) && "1".equalsIgnoreCase(sys)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", KEY_TAXSYSTEM, KEY_TAXTYPE, "method", KEY_CYCLE, KEY_TAXAREA, KEY_BOOKTYPE, "save", KEY_ISDIMPROVISION, KEY_BUSINESSDIMENSION, KEY_PROVISIONDIMENSION, "startdate", "enddate"});
            }
            long currUserId = RequestContext.get().getCurrUserId();
            long orgId = RequestContext.get().getOrgId();
            HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"itp", (String)"itp_proviston_plan", (String)"4715a0df000000ac", (Long)currUserId);
            if (!allPermOrgsByUserId.hasAllOrgPerm() && !allPermOrgsByUserId.getHasPermOrgs().contains(orgId)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"save"});
            }
        }
    }

    private boolean checkPreConditionBeforeF7(BeforeF7SelectEvent evt) {
        boolean b = true;
        String name = evt.getProperty().getName();
        if (KEY_TAXSYSTEM.equals(name)) {
            b = this.checkPreConditionTaxsys();
            if (!b) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u65b9\u6848\u7528\u9014\u201d\u3002", (String)"ProvistonPlanPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        } else if (KEY_TAXTYPE.equals(name) && !(b = this.checkPreConditionTaxtype())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u7a0e\u6536\u5236\u5ea6\u201d\u3002", (String)"ProvistonPlanPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
        return b;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (!this.checkPreConditionBeforeF7(evt)) {
            evt.setCancel(true);
        }
        String name = evt.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (KEY_TAXSYSTEM.equals(name)) {
            String planUse = this.getPlanuseFromView();
            Collection<String> taxsysCodes = this.getUsabaleTaxsys(planUse);
            QFilter qFilter = new QFilter("number", "in", taxsysCodes);
            listShowParameter.getListFilterParameter().setFilter(qFilter);
        } else if (KEY_TAXTYPE.equals(name)) {
            String planUseCode = this.getPlanuseFromView();
            String taxsysCode = this.getTaxsysFromView();
            Collection<String> taxtypeCodes = this.getUsabaleTaxtype(planUseCode, taxsysCode);
            QFilter qFilter = new QFilter("number", "in", taxtypeCodes);
            listShowParameter.getListFilterParameter().setFilter(qFilter);
        } else if (KEY_TAXAREA.equalsIgnoreCase(name)) {
            TaxResult listTaxResult;
            Long countryId;
            DynamicObject taxationsysObj = this.getModel().getDataEntity().getDynamicObject(KEY_TAXSYSTEM);
            List areaGroupIds = null;
            if (taxationsysObj != null && (countryId = Long.valueOf(taxationsysObj.getDynamicObject("countryid").getLong("id"))) != null && countryId != 0L && (listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)countryId)) != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
                areaGroupIds = ((List)listTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(areaGroupIds)) {
                QFilter idQFilter = new QFilter("id", "in", areaGroupIds);
                listShowParameter.getListFilterParameter().setFilter(idQFilter);
            } else {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)-1));
            }
        } else if (KEY_BUSINESSDIMENSION.equalsIgnoreCase(name)) {
            listShowParameter.setMultiSelect(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        this.resetFiledWhenPropertyChanged(name);
        if (KEY_TAXSYSTEM.equalsIgnoreCase(name)) {
            this.settingTaxArea();
        } else if (KEY_TAXTYPE.equalsIgnoreCase(name)) {
            this.settingSisdimprovision();
            this.settingCycle();
        }
    }

    private void settingTaxArea() {
        DynamicObject taxationsysObj = this.getModel().getDataEntity().getDynamicObject(KEY_TAXSYSTEM);
        DynamicObject taxareaObj = this.getModel().getDataEntity().getDynamicObject(KEY_TAXAREA);
        if (taxationsysObj != null) {
            Long taxsysId = taxationsysObj.getLong("id");
            if (taxsysId.compareTo(TaxationsysMappingEnum.CHN.getId()) == 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_TAXAREA});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_TAXAREA});
            }
            if (taxareaObj == null) {
                if (taxsysId.compareTo(TaxationsysMappingEnum.CHN.getId()) == 0) {
                    this.getModel().setValue(KEY_TAXAREA, (Object)1708040530098667520L);
                } else {
                    Long countryId = taxationsysObj.getDynamicObject("countryid").getLong("id");
                    TaxResult listTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaByCountryId((Long)countryId);
                    if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
                        this.getModel().setValue(KEY_TAXAREA, ((DynamicObject)((List)listTaxResult.getData()).get(0)).getDynamicObject("group").getPkValue());
                    }
                }
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_TAXAREA});
        }
    }

    private void resetFiledWhenPropertyChanged(String propertyName) {
        if (KEY_PLANUSE.equals(propertyName)) {
            this.getModel().setValue(KEY_TAXSYSTEM, null);
            this.resetFiledWhenPropertyChanged(KEY_TAXSYSTEM);
        } else if (KEY_TAXSYSTEM.equals(propertyName)) {
            this.getModel().setValue(KEY_TAXTYPE, null);
            this.getModel().setValue(KEY_TAXAREA, null);
            this.resetFiledWhenPropertyChanged(KEY_TAXTYPE);
        } else if (KEY_TAXTYPE.equals(propertyName)) {
            this.getModel().setValue(KEY_ISDIMPROVISION, (Object)false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ISDIMPROVISION});
            this.resetFiledWhenPropertyChanged(KEY_ISDIMPROVISION);
            this.getModel().setValue(KEY_BOOKTYPE, null);
            this.getModel().setValue(KEY_CYCLE, null);
        } else if (KEY_ISDIMPROVISION.equals(propertyName)) {
            this.getModel().setValue(KEY_PROVISIONDIMENSION, null);
            this.resetFiledWhenPropertyChanged(KEY_PROVISIONDIMENSION);
        } else if (KEY_PROVISIONDIMENSION.equals(propertyName)) {
            this.getModel().setValue(KEY_BUSINESSDIMENSION, null);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        if (sourceData.get("number") == null) {
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"itp_proviston_plan");
            String number = codeRuleService.readNumber("itp_proviston_plan", dataInfo, null);
            sourceData.put("number", number);
        }
    }

    private String getPlanuseFromView() {
        return (String)this.getModel().getValue(KEY_PLANUSE);
    }

    private String getTaxsysFromView() {
        DynamicObject dyn = (DynamicObject)this.getModel().getValue(KEY_TAXSYSTEM);
        if (dyn != null) {
            return dyn.getString("number");
        }
        return null;
    }

    private String getTaxtypeFromView() {
        DynamicObject dyn = (DynamicObject)this.getModel().getValue(KEY_TAXTYPE);
        if (dyn != null) {
            return dyn.getString("number");
        }
        return null;
    }

    private boolean checkPreConditionTaxsys() {
        String v = (String)this.getModel().getValue(KEY_PLANUSE);
        return null != v && (v.contains("1") || v.contains("2"));
    }

    private boolean checkPreConditionTaxtype() {
        return null != this.getModel().getValue(KEY_TAXSYSTEM);
    }

    private Collection<String> getUsabaleTaxsys(String planuseCode) {
        return ProvisionPlanBusiness.getUsabaleTaxsys((String)planuseCode);
    }

    private Collection<String> getUsabaleTaxtype(String planuseCode, String taxsysCode) {
        return ProvisionPlanBusiness.getUsabaleTaxtype((String)planuseCode, (String)taxsysCode);
    }

    private TaxPlanCfgEnum getTaxPlanCfgEnumFromView() {
        String planuse = this.getPlanuseFromView();
        String taxsys = this.getTaxsysFromView();
        String taxtype = this.getTaxtypeFromView();
        TaxPlanCfgEnum cfg = TaxPlanCfgEnum.valueOf((String)planuse, (String)taxsys, (String)taxtype);
        return cfg;
    }

    private void settingSisdimprovision() {
        TaxPlanCfgEnum cfg = this.getTaxPlanCfgEnumFromView();
        boolean[] viewCfg = ProvisionPlanBusiness.isdimprovisionCfg((TaxPlanCfgEnum)cfg);
        this.getView().setVisible(Boolean.valueOf(viewCfg[0]), new String[]{KEY_ISDIMPROVISION});
        this.getView().setEnable(Boolean.valueOf(viewCfg[1]), new String[]{KEY_ISDIMPROVISION});
        if (!viewCfg[1]) {
            this.getModel().setValue(KEY_ISDIMPROVISION, (Object)viewCfg[2]);
        }
    }

    private void settingCycle() {
        TaxPlanCfgEnum cfg = this.getTaxPlanCfgEnumFromView();
        boolean[] viewCfg = ProvisionPlanBusiness.cycleCfg((TaxPlanCfgEnum)cfg);
        this.getView().setVisible(Boolean.valueOf(viewCfg[0]), new String[]{KEY_CYCLE});
        this.getView().setEnable(Boolean.valueOf(viewCfg[1]), new String[]{KEY_CYCLE});
        FieldEdit ctrl = (FieldEdit)this.getControl(KEY_CYCLE);
        ctrl.setMustInput(viewCfg[2]);
    }
}

