/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.datasource;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DataSourceEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_NAME = "entityname";
    private static final String SUB_ENTITY_NAME = "subname";
    private static final String TOOL_TBMAIN = "tbmain";
    private static final String TAX_TYPE = "peekrule";
    private static final String HAS_SUBENTITY = "has_subentity";
    private static final String HAS_SUBTIPS = "has_subtips";
    private static final String BAR_SAVE = "bar_save";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TCTB_CUSTOM_DATASOURCE = "tctb_custom_datasource";
    private static final String ACCESSMAP = "accessmap";
    private static final Map<String, Set<String>> dfs = new HashMap<String, Set<String>>(){
        {
            this.put("gl_balance", new HashSet<String>(Arrays.asList("account", "booktype", "period")));
            this.put("gl_voucher", new HashSet<String>(Arrays.asList("account", "booktype", "vouchertype", "period")));
            this.put("entries", new HashSet<String>(Collections.singletonList("account")));
        }
    };
    private static final Map<String, String> field2Entity = new HashMap<String, String>(){
        {
            this.put("booktype", "bd_accountbookstype");
            this.put("account", "bd_accountview");
            this.put("vouchertype", "gl_vouchertype");
            this.put("period", "bd_period");
        }
    };
    private static final Map<String, Set<String>> entity2FilesShow = new HashMap<String, Set<String>>(){
        {
            this.put("bd_accountbookstype", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("bd_accountview", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("gl_vouchertype", new HashSet<String>(Arrays.asList("number", "name")));
            this.put("bd_period", new HashSet<String>(Collections.singletonList("begindate")));
        }
    };
    private static final Map<String, String> ENTITY_V3 = new HashMap<String, String>(){
        {
            this.put("tpo_declare_main_tsc", "tpo_declare_detail_tsc");
            this.put("tpo_declare_main_tsd", "tpo_declare_detail_tsd");
        }
    };
    private static final String MAIN_KEY = "main";
    private static final String SUB_KEY = "sub";
    private static final String BBLX = "bblx";
    private static final String ORGFIELD = "orgfield";
    private static final String DATEFIELD = "datefield";
    private static final String YEARFIELD = "yearfield";
    private static final String MONTHFIELD = "monthfield";
    private static final String ORGDESC = "orgdesc";
    private static final String DATEDESC = "datedesc";
    private static final String YEARDESC = "yeardesc";
    private static final String MONTHDESC = "monthdesc";
    private static final Map<String, String> FIELD_MAP = new HashMap<String, String>(){
        {
            this.put(DataSourceEditPlugin.ORGDESC, DataSourceEditPlugin.ORGFIELD);
            this.put(DataSourceEditPlugin.DATEDESC, DataSourceEditPlugin.DATEFIELD);
            this.put(DataSourceEditPlugin.YEARDESC, DataSourceEditPlugin.YEARFIELD);
            this.put(DataSourceEditPlugin.MONTHDESC, DataSourceEditPlugin.MONTHFIELD);
        }
    };

    public void afterBindData(EventObject e) {
        FieldEdit control;
        DynamicObject dynamicObject;
        BaseView baseView = (BaseView)e.getSource();
        OperationStatus status = baseView.getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTITY_NAME, SUB_ENTITY_NAME});
        }
        if (!(null == (dynamicObject = (DynamicObject)this.getModel().getValue("group")) || "ds_yscj".equalsIgnoreCase(dynamicObject.getString("number")) || "ds_tjsjqs".equalsIgnoreCase(dynamicObject.getString("number")) || "ds_jtsjqs".equalsIgnoreCase(dynamicObject.getString("number")) || null == (control = (FieldEdit)this.getControl(TAX_TYPE)))) {
            control.setMustInput(true);
        }
        this.dealStateField();
    }

    public void afterCopyData(EventObject e) {
        BillModel billModel = (BillModel)e.getSource();
        String bizname = (String)billModel.getValue("bizname");
        this.getModel().setValue("bizname", (Object)(bizname + "_copy"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtil.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save")) {
            DynamicObjectCollection ds;
            String integrityInfo = this.checkFieldIntegrity();
            if (integrityInfo != null) {
                this.getView().showErrorNotification(integrityInfo);
                args.setCancel(true);
                return;
            }
            if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                QFilter q2;
                String bizname = this.getModel().getValue("bizname").toString();
                DynamicObject groupObject = (DynamicObject)this.getModel().getValue("group");
                QFilter q1 = new QFilter("group.id", "=", groupObject.getPkValue());
                DynamicObject d = QueryServiceHelper.queryOne((String)TCTB_CUSTOM_DATASOURCE, (String)"id", (QFilter[])new QFilter[]{q1, q2 = new QFilter("bizname", "=", (Object)bizname)});
                if (d != null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4e1a\u52a1\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DataSourceEditPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), bizname, groupObject.getString("name")));
                    args.setCancel(true);
                    return;
                }
            }
            if ((ds = this.getModel().getEntryEntity(ENTRY_ENTITY)) == null || ds.size() <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u751f\u6210\u6309\u94ae\uff0c\u751f\u6210\u5b9e\u4f53\u5b57\u6bb5\u3002", (String)"DataSourceEditPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String validityInfo = this.checkFieldValidity();
            if (!StringUtils.isBlank((String)validityInfo)) {
                this.getView().showErrorNotification(validityInfo);
                args.setCancel(true);
                return;
            }
            List<String> hintInfo = this.checkAmountIsConfigAccesslogic();
            if (hintInfo.size() > 0) {
                this.showResultMulti(hintInfo);
                args.setCancel(true);
                return;
            }
            String subEntityNumber = (String)this.getModel().getValue(SUB_ENTITY_NAME);
            String hasSubEntity = this.getPageCache().get(HAS_SUBENTITY);
            if (StringUtil.isBlank((CharSequence)subEntityNumber) && StringUtil.isNotBlank((CharSequence)hasSubEntity) && "1".equals(hasSubEntity)) {
                RefObject afterConfirm = new RefObject();
                if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                    this.showConfirmTips();
                    args.setCancel(true);
                }
                operate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ENTITY_NAME, SUB_ENTITY_NAME, ORGDESC, DATEDESC, YEARDESC, MONTHDESC});
        this.addItemClickListeners(new String[]{TOOL_TBMAIN, BAR_SAVE});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ACCESSMAP);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (ENTITY_NAME.equalsIgnoreCase(key)) {
            ListShowParameter listShowParameter = this.createAndSetListShowParameter("bos_formmeta", "bos_devp_formtreelistf7", ResManager.loadKDString((String)"\u901a\u7528\u8868\u5355\u9009\u62e9", (String)"DataSourceEditPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), false);
            if (listShowParameter != null) {
                listShowParameter.setCustomParam("onlyvisible", (Object)Boolean.FALSE);
                listShowParameter.setCustomParam("onlydeployed", (Object)Boolean.FALSE);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formCallBack"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("modeltype", "in", Arrays.asList("BillFormModel", "BaseFormModel")));
                listShowParameter.getListFilterParameter().setQFilters(qFilters);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        } else if (SUB_ENTITY_NAME.equalsIgnoreCase(key)) {
            IDataModel model = this.getModel();
            String mainNumber = (String)model.getValue(ENTITY_NAME);
            if (StringUtils.isBlank((String)mainNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u751f\u6210\u6309\u94ae\uff0c\u751f\u6210\u5b9e\u4f53\u5b57\u6bb5\u3002", (String)"DataSourceEditPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showSubEntityForm(mainNumber);
        } else if (ORGDESC.equals(key) || DATEDESC.equals(key) || YEARDESC.equals(key) || MONTHDESC.equals(key)) {
            IDataModel model = this.getModel();
            String mainNumber = (String)model.getValue(ENTITY_NAME);
            if (StringUtils.isBlank((String)mainNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u751f\u6210\u6309\u94ae\uff0c\u751f\u6210\u5b9e\u4f53\u5b57\u6bb5\u3002", (String)"DataSourceEditPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCustomParam("fieldtype", (Object)key);
            formShowParameter.setCustomParam("fieldkey", (Object)FIELD_MAP.get(key));
            formShowParameter.setCustomParam("entitynumber", (Object)mainNumber);
            Object subEntity = this.getModel().getValue(SUB_ENTITY_NAME);
            if (ObjectUtils.isNotEmpty((Object)subEntity)) {
                formShowParameter.setCustomParam("subentitynumber", subEntity);
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldCallBack"));
            formShowParameter.setFormId("tctb_field_select");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    private void showSubEntityForm(String mainNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("tctb_datasource_subentity");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5173\u8054\u5b50\u5b9e\u4f53", (String)"DataSourceEditPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("mainEntity", (Object)mainNumber);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "subFormCallBack");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BAR_SAVE.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("save", operateOption);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("generate".equalsIgnoreCase(key)) {
            String number = (String)this.getModel().getValue(ENTITY_NAME);
            String subNumber = (String)this.getModel().getValue(SUB_ENTITY_NAME);
            if (StringUtil.isBlank((CharSequence)number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u540d\u79f0\u3002", (String)"DataSourceEditPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getView().getPageCache().get(MAIN_KEY) != null && !number.equals(this.getView().getPageCache().get(MAIN_KEY)) || this.getView().getPageCache().get(SUB_KEY) != null && !subNumber.equals(this.getView().getPageCache().get(SUB_KEY))) {
                this.getModel().deleteEntryData(ENTRY_ENTITY);
            }
            this.getView().getPageCache().put(MAIN_KEY, number);
            this.getView().getPageCache().put(SUB_KEY, subNumber);
            this.createEntry(number, subNumber, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() != null) {
            Map reObj;
            String callBackID = event.getActionId();
            IDataModel model = this.getModel();
            if ("formCallBack".equalsIgnoreCase(callBackID)) {
                ListSelectedRowCollection rt = (ListSelectedRowCollection)event.getReturnData();
                String itemNumber = rt.get(0).getNumber();
                model.setValue(ENTITY_NAME, (Object)itemNumber);
                model.setValue("name", (Object)itemNumber);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)itemNumber);
                Map entityMap = mainEntityType.getAllEntities();
                if (entityMap != null && entityMap.size() > 1) {
                    this.showSubEntityForm(itemNumber);
                }
            } else if ("subFormCallBack".equalsIgnoreCase(callBackID)) {
                JSONObject reObj2 = (JSONObject)event.getReturnData();
                if (reObj2 != null && reObj2.size() > 0) {
                    model.setValue(SUB_ENTITY_NAME, (Object)reObj2.getString("number"));
                }
            } else if ("fieldCallBack".equalsIgnoreCase(callBackID) && (reObj = (Map)event.getReturnData()) != null && reObj.containsKey("fieldtype") && reObj.containsKey("fieldtext")) {
                model.setValue((String)reObj.get("fieldtype"), reObj.get("fieldtext"));
                model.setValue(FIELD_MAP.get(reObj.get("fieldtype")), reObj.get("fieldvalue"));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)property, (CharSequence)ACCESSMAP)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            DynamicObject focusRowObject = this.getModel().getEntryRowEntity(ENTRY_ENTITY, focusRow);
            String fieldname = focusRowObject.getString("fieldname");
            String entityName = (String)this.getModel().getValue(ENTITY_NAME);
            if (StringUtil.isBlank((CharSequence)entityName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u540d\u79f0\u3002", (String)"DataSourceEditPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            IDataEntityProperty dynamicProperty = mainEntityType.findProperty(fieldname);
            if (dynamicProperty instanceof BasedataProp) {
                DynamicObjectCollection entityCol = this.getModel().getEntryEntity(ENTRY_ENTITY);
                List list = Stream.iterate(0, j -> j + 1).limit(entityCol.size()).filter(num -> num != focusRow && ((DynamicObject)entityCol.get(num.intValue())).getLong("accessmap.id") > 0L).map(num -> ((DynamicObject)entityCol.get(num.intValue())).getLong("accessmap.id")).collect(Collectors.toList());
                if (ObjectUtils.isNotEmpty(list)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0%s\u4e2d\uff1a\u53ea\u80fd\u6709\u4e00\u4e2a\u5b57\u6bb5\u8bbe\u7f6e\u201c\u53d6\u6570\u6620\u5c04\u201d\u3002", (String)"DataSourceEditPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entityName));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                BasedataProp basedataProp = (BasedataProp)dynamicProperty;
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6620\u5c04\u5173\u7cfb", (String)"DataSourceEditPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                QFilter mapobjectQ = new QFilter("mapobject", "=", (Object)basedataProp.getBaseEntityId());
                listShowParameter.getListFilterParameter().setFilter(mapobjectQ);
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u540d\u79f0%s\u4e2d\uff1a\u53ea\u6709\u5b57\u6bb5\u7c7b\u578b\u662f\u201c\u57fa\u7840\u8d44\u6599\u201d\u7684\u5b57\u6bb5\u624d\u53ef\u4ee5\u8bbe\u7f6e\u53d6\u6570\u6620\u5c04\u3002", (String)"DataSourceEditPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), entityName));
                beforeF7SelectEvent.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        ArrayList<String> fieldList;
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (ENTITY_NAME.equals(propertyName)) {
            this.getModel().setValue(SUB_ENTITY_NAME, (Object)"");
            this.getModel().setValue(BBLX, null);
            this.clearFields();
            if (StringUtil.isEmpty((CharSequence)((String)changeData.getNewValue()))) {
                this.getModel().setValue(ENTITY_NAME, (Object)"");
                this.getModel().setValue("name", (Object)"");
            }
            String groupNumber = ((DynamicObject)this.getModel().getValue("group")).getString("number");
            BasedataEdit bblxEdit = (BasedataEdit)this.getView().getControl(BBLX);
            if ("ds_yscj".equalsIgnoreCase(groupNumber) || "ds_tjsjqs".equalsIgnoreCase(groupNumber) || "ds_nsqs".equalsIgnoreCase(groupNumber)) {
                if (EntityV3Constant.ENTITY_V3.containsKey(changeData.getNewValue())) {
                    bblxEdit.setMustInput(true);
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{BBLX});
                } else {
                    bblxEdit.setMustInput(false);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{BBLX});
                }
            } else {
                bblxEdit.setMustInput(false);
            }
            if (EntityV3Constant.ENTITY_V3.containsKey(changeData.getNewValue())) {
                IDataEntityProperty orgProp;
                IDataEntityProperty skssqzProp = MetadataUtil.findProp((String)((String)changeData.getNewValue()), (String)"skssqz");
                if (skssqzProp != null) {
                    this.getModel().setValue(DATEFIELD, (Object)"skssqz");
                    this.getModel().setValue(DATEDESC, (Object)skssqzProp.getDisplayName().getLocaleValue());
                }
                if ((orgProp = MetadataUtil.findProp((String)((String)changeData.getNewValue()), (String)"org")) != null) {
                    this.getModel().setValue(ORGFIELD, (Object)"org");
                    this.getModel().setValue(ORGDESC, (Object)orgProp.getDisplayName().getLocaleValue());
                }
            }
            this.getView().getPageCache().put(MAIN_KEY, String.valueOf(changeData.getOldValue()));
        }
        if (SUB_ENTITY_NAME.equals(propertyName)) {
            if (StringUtil.isEmpty((CharSequence)((String)changeData.getNewValue()))) {
                this.getModel().setValue(SUB_ENTITY_NAME, (Object)"");
            }
            this.getView().getPageCache().put(SUB_KEY, String.valueOf(changeData.getOldValue()));
            this.clearFields();
        }
        if (ORGFIELD.equals(propertyName)) {
            boolean isClear = EmptyCheckUtils.isEmpty((Object)changeData.getNewValue());
            String fieldName = (String)changeData.getNewValue();
            if (isClear) {
                fieldName = (String)changeData.getOldValue();
            }
            this.setFieldProperties("orgstate", fieldName, null, isClear);
        }
        if (DATEFIELD.equals(propertyName)) {
            fieldList = new ArrayList<String>();
            fieldList.add("yearstate");
            fieldList.add("monthstate");
            if (EmptyCheckUtils.isNotEmpty((Object)changeData.getNewValue())) {
                this.getModel().setValue(YEARFIELD, null);
                this.getModel().setValue(MONTHFIELD, null);
                this.getModel().setValue(YEARDESC, null);
                this.getModel().setValue(MONTHDESC, null);
            }
            boolean isClear = EmptyCheckUtils.isEmpty((Object)changeData.getNewValue());
            String fieldName = (String)changeData.getNewValue();
            if (isClear) {
                fieldName = (String)changeData.getOldValue();
            }
            this.setFieldProperties("datastate", fieldName, fieldList, isClear);
        }
        if (YEARFIELD.equals(propertyName) || MONTHFIELD.equals(propertyName)) {
            String property;
            fieldList = new ArrayList();
            fieldList.add("datastate");
            String string = property = YEARFIELD.equals(propertyName) ? "yearstate" : "monthstate";
            if (EmptyCheckUtils.isNotEmpty((Object)changeData.getNewValue())) {
                this.getModel().setValue(DATEFIELD, null);
                this.getModel().setValue(DATEDESC, null);
            }
            boolean isClear = EmptyCheckUtils.isEmpty((Object)changeData.getNewValue());
            String fieldName = (String)changeData.getNewValue();
            if (isClear) {
                fieldName = (String)changeData.getOldValue();
            }
            this.setFieldProperties(property, fieldName, fieldList, isClear);
        }
        if ((YEARDESC.equals(propertyName) || MONTHDESC.equals(propertyName) || ORGDESC.equals(propertyName) || DATEDESC.equals(propertyName)) && EmptyCheckUtils.isEmpty((Object)changeData.getNewValue())) {
            this.getModel().setValue(FIELD_MAP.get(propertyName), null);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)ACCESSMAP) && ObjectUtils.isNotEmpty((Object)(newValue = changeData.getNewValue()))) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            this.getModel().setValue("wherestate", (Object)"0", focusRow);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"wherestate")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            DynamicObject focusRowObject = this.getModel().getEntryRowEntity(ENTRY_ENTITY, focusRow);
            Object newValue2 = changeData.getNewValue();
            if (newValue2 instanceof Boolean && ((Boolean)newValue2).booleanValue() && ObjectUtils.isNotEmpty((Object)focusRowObject.getString(ACCESSMAP))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u8bbe\u7f6e\u53d6\u6570\u6620\u5c04\uff0c\u4e0d\u80fd\u6253\u5f00\u8fc7\u6ee4\u6761\u4ef6\u5f00\u5173\u3002", (String)"DataSourceEditPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("wherestate", (Object)"0", focusRow);
            }
        }
    }

    private void clearFields() {
        this.getModel().setValue(ORGFIELD, null);
        this.getModel().setValue(DATEFIELD, null);
        this.getModel().setValue(YEARFIELD, null);
        this.getModel().setValue(MONTHFIELD, null);
        this.getModel().setValue(ORGDESC, null);
        this.getModel().setValue(DATEDESC, null);
        this.getModel().setValue(YEARDESC, null);
        this.getModel().setValue(MONTHDESC, null);
    }

    private void setFieldProperties(String propertyName, int rowIndex, List<String> fieldList, boolean isclear) {
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < ds.size(); ++i) {
            if (i == rowIndex && !isclear) {
                this.getModel().setValue(propertyName, (Object)Boolean.TRUE, i);
            } else {
                this.getModel().setValue(propertyName, (Object)Boolean.FALSE, i);
            }
            if (fieldList == null) continue;
            for (String itemName : fieldList) {
                this.getModel().setValue(itemName, (Object)Boolean.FALSE, i);
            }
        }
    }

    private void setFieldProperties(String propertyName, String fieldName, List<String> fieldList, boolean isclear) {
        Optional<DynamicObject> fieldObj;
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (CollectionUtils.isNotEmpty((Collection)ds) && (fieldObj = ds.stream().filter(o -> StringUtil.equals((CharSequence)fieldName, (CharSequence)o.getString("fieldname"))).findFirst()).isPresent()) {
            int rowIndex = fieldObj.get().getInt("seq") - 1;
            this.setFieldProperties(propertyName, rowIndex, fieldList, isclear);
        }
    }

    protected ListShowParameter createAndSetListShowParameter(String billFormId, String fromId, String caption, boolean isMultiSelect) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)billFormId, (boolean)isMultiSelect);
        para.setCaption(caption);
        para.setFormId(fromId);
        return para;
    }

    private List<String> checkAmountIsConfigAccesslogic() {
        ArrayList<String> hintList = new ArrayList<String>();
        String groupNumber = ((DynamicObject)this.getModel().getValue("group")).getString("number");
        if (!StringUtil.equalsIgnoreCase((CharSequence)groupNumber, (CharSequence)"ds_nsqs")) {
            return hintList;
        }
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < ds.size(); ++i) {
            DynamicObject d = (DynamicObject)ds.get(i);
            if (!d.getBoolean("isamount") || !StringUtil.isBlank((CharSequence)d.getString("accesslogic"))) continue;
            hintList.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a", (String)"DataSourceEditPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), i + 1).concat(d.getString("bizsubname")).concat(ResManager.loadKDString((String)"\u4e3a\u91d1\u989d\u5b57\u6bb5\u5fc5\u987b\u8bbe\u7f6e\u53d6\u6570\u903b\u8f91", (String)"DataSourceEditPlugin_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0])));
        }
        return hintList;
    }

    private void showResultMulti(List<String> hintList) {
        if (hintList.size() == 1) {
            this.getView().showTipNotification(hintList.get(0));
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(false);
            parameters.setCustomParam("operateName", (Object)"");
            parameters.setCustomParam("title", (Object)"");
            parameters.setCustomParam("errorMsg", hintList);
            this.getView().showForm(parameters);
        }
    }

    private void dealStateField() {
        DynamicObjectCollection entryObjs = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_ENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryObjs)) {
            Optional<DynamicObject> orgfield = entryObjs.stream().filter(o -> o.getBoolean("orgstate")).findFirst();
            Optional<DynamicObject> datefield = entryObjs.stream().filter(o -> o.getBoolean("datastate")).findFirst();
            Optional<DynamicObject> yearfield = entryObjs.stream().filter(o -> o.getBoolean("yearstate")).findFirst();
            Optional<DynamicObject> monthfield = entryObjs.stream().filter(o -> o.getBoolean("monthstate")).findFirst();
            if (orgfield.isPresent()) {
                this.getModel().setValue(ORGDESC, orgfield.get().get("bizsubname"), orgfield.get().getInt("seq") - 1);
                this.getModel().setValue(ORGFIELD, orgfield.get().get("fieldname"), orgfield.get().getInt("seq") - 1);
            }
            if (datefield.isPresent()) {
                this.getModel().setValue(DATEFIELD, datefield.get().get("fieldname"), datefield.get().getInt("seq") - 1);
                this.getModel().setValue(DATEDESC, datefield.get().get("bizsubname"), datefield.get().getInt("seq") - 1);
            }
            if (yearfield.isPresent()) {
                this.getModel().setValue(YEARFIELD, yearfield.get().get("fieldname"), yearfield.get().getInt("seq") - 1);
                this.getModel().setValue(YEARDESC, yearfield.get().get("bizsubname"), yearfield.get().getInt("seq") - 1);
            }
            if (monthfield.isPresent()) {
                this.getModel().setValue(MONTHFIELD, monthfield.get().get("fieldname"), monthfield.get().getInt("seq") - 1);
                this.getModel().setValue(MONTHDESC, monthfield.get().get("bizsubname"), monthfield.get().getInt("seq") - 1);
            }
        }
    }

    private void createEntry(String main, String sub, String parentFieldName) {
        boolean flag;
        if (StringUtils.isNotEmpty((String)main) && !(flag = this.entry(main, sub, parentFieldName))) {
            this.entry(sub, "", parentFieldName);
        }
    }

    private boolean entry(String entryId, String sub, String parentFieldName) {
        if (StringUtils.isEmpty((String)entryId)) {
            return false;
        }
        Map<String, DynamicObject> map = this.getEntryList();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryId);
        boolean flag = false;
        Map entityMap = mainEntityType.getAllEntities();
        if (entityMap.size() > 1) {
            this.getPageCache().put(HAS_SUBENTITY, "1");
        } else {
            this.getPageCache().put(HAS_SUBENTITY, "0");
        }
        ArrayList<String> subEntityName = new ArrayList<String>();
        for (Map.Entry entry : entityMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!flag && key.equals(sub)) {
                flag = true;
            }
            EntityType entityType = (EntityType)entry.getValue();
            if (key.equals(entryId) || key.equals(sub)) {
                DataEntityPropertyCollection pros = entityType.getProperties();
                for (IDataEntityProperty property : pros) {
                    Set<String> fieldsShow = entity2FilesShow.get(key);
                    if (null != fieldsShow && !fieldsShow.contains(property.getName())) continue;
                    this.setColumnValue(property, map, key, parentFieldName);
                }
                continue;
            }
            subEntityName.add(entityType.getDisplayName().toString());
        }
        if (subEntityName.size() > 0) {
            StringBuilder subBuiler = new StringBuilder();
            subBuiler.append(ResManager.loadKDString((String)"\u672a\u5173\u8054\u8868\u5355\uff1a", (String)"DataSourceEditPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            subBuiler.append(StringUtil.join(subEntityName, (String)","));
            this.getPageCache().put(HAS_SUBTIPS, subBuiler.toString());
        } else {
            this.getPageCache().put(HAS_SUBTIPS, "");
        }
        return flag;
    }

    private void setColumnValue(IDataEntityProperty property, Map<String, DynamicObject> map, String key, String parentFieldName) {
        String bizsubname;
        String descrice;
        if (property instanceof EntryProp || null == property.getDisplayName()) {
            return;
        }
        String fieldname = null == parentFieldName ? property.getName() : parentFieldName + "." + property.getName();
        boolean isamount = false;
        boolean orgstate = false;
        boolean datestate = false;
        boolean yearstate = false;
        boolean monthstate = false;
        if (this.needExpand(key, fieldname)) {
            this.createEntry(field2Entity.get(fieldname), "", fieldname);
            return;
        }
        Class propertyType = property.getPropertyType();
        if (null != property.getDisplayName()) {
            IDataEntityType parent = property.getParent().getParent();
            if (parent != null) {
                descrice = property.getParent().getDisplayName().getLocaleValue() + "." + property.getDisplayName().getLocaleValue();
                bizsubname = property.getParent().getDisplayName().getLocaleValue() + "." + property.getDisplayName().getLocaleValue();
            } else {
                descrice = property.getDisplayName().getLocaleValue();
                bizsubname = property.getDisplayName().getLocaleValue();
            }
        } else {
            descrice = fieldname;
            bizsubname = fieldname;
        }
        String entityName = (String)this.getModel().getValue(ENTITY_NAME);
        if (ENTITY_V3.containsKey(entityName)) {
            if (StringUtil.equals((CharSequence)fieldname, (CharSequence)"column")) {
                isamount = true;
            }
        } else if (propertyType.isAssignableFrom(BigDecimal.class)) {
            isamount = true;
        }
        if (this.getModel().getValue(ORGDESC) != null && StringUtil.equals((CharSequence)((String)this.getModel().getValue(ORGFIELD)), (CharSequence)fieldname)) {
            orgstate = true;
        }
        if (this.getModel().getValue(DATEDESC) != null && StringUtil.equals((CharSequence)((String)this.getModel().getValue(DATEFIELD)), (CharSequence)fieldname)) {
            datestate = true;
        }
        if (this.getModel().getValue(YEARDESC) != null && StringUtil.equals((CharSequence)((String)this.getModel().getValue(YEARFIELD)), (CharSequence)fieldname)) {
            yearstate = true;
        }
        if (this.getModel().getValue(MONTHDESC) != null && StringUtil.equals((CharSequence)((String)this.getModel().getValue(MONTHFIELD)), (CharSequence)fieldname)) {
            monthstate = true;
        }
        HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>();
        booleanMap.put("isamount", isamount);
        booleanMap.put("orgstate", orgstate);
        booleanMap.put("datestate", datestate);
        booleanMap.put("yearstate", yearstate);
        booleanMap.put("monthstate", monthstate);
        if (null == map.get(this.getkey(key, fieldname))) {
            this.setValue(key, fieldname, descrice, bizsubname, booleanMap);
        }
    }

    private boolean needExpand(String key, String fieldname) {
        if ("entries".equals(key)) {
            return "gl_voucher".equals(this.getPageCache().get(MAIN_KEY)) && "account".equals(fieldname);
        }
        Set<String> fields = dfs.get(key);
        return null != fields && fields.contains(fieldname);
    }

    private void setValue(String entityname, String fieldname, String descrice, String subname, Map<String, Boolean> booleanMap) {
        boolean isamount = booleanMap.get("isamount") != false;
        boolean orgstate = booleanMap.get("orgstate") != false;
        boolean datestate = booleanMap.get("datestate") != false;
        boolean yearstate = booleanMap.get("yearstate") != false;
        boolean monthstate = booleanMap.get("monthstate") != false;
        int index = this.getModel().createNewEntryRow(ENTRY_ENTITY);
        this.getModel().setValue("fieldsubname", (Object)entityname, index);
        this.getModel().setValue("fieldname", (Object)fieldname, index);
        this.getModel().setValue("descrice", (Object)descrice, index);
        this.getModel().setValue("bizsubname", (Object)subname, index);
        this.getModel().setValue("state", (Object)"1", index);
        this.getModel().setValue("isamount", (Object)isamount, index);
        this.getModel().setValue("orgstate", (Object)orgstate, index);
        this.getModel().setValue("datastate", (Object)datestate, index);
        this.getModel().setValue("yearstate", (Object)yearstate, index);
        this.getModel().setValue("monthstate", (Object)monthstate, index);
        if (isamount) {
            this.getModel().setValue("accesslogic", (Object)"bqhj", index);
        }
        this.getModel().setValue("wherestate", (Object)"0", index);
    }

    private void setValue(String entityname, String fieldname, String descrice, String subname, Boolean amountfield) {
        int index = this.getModel().createNewEntryRow(ENTRY_ENTITY);
        this.getModel().setValue("fieldsubname", (Object)entityname, index);
        this.getModel().setValue("fieldname", (Object)fieldname, index);
        this.getModel().setValue("descrice", (Object)descrice, index);
        this.getModel().setValue("bizsubname", (Object)subname, index);
        this.getModel().setValue("state", (Object)"1", index);
        this.getModel().setValue("isamount", (Object)amountfield, index);
        if (amountfield.booleanValue()) {
            this.getModel().setValue("accesslogic", (Object)"bqhj", index);
        }
        this.getModel().setValue("wherestate", (Object)"0", index);
    }

    private Map<String, DynamicObject> getEntryList() {
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject d : ds) {
            map.put(this.getkey(d.getString("fieldsubname"), d.getString("fieldname")), d);
        }
        return map;
    }

    private String getkey(String fieldsubname, String fieldname) {
        return fieldsubname + "_" + fieldname;
    }

    private void showConfirmTips() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BAR_SAVE, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DataSourceEditPlugin_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DataSourceEditPlugin_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String tipInfo = this.getPageCache().get(HAS_SUBTIPS);
        String msg = ResManager.loadKDString((String)"\u5b58\u5728\u5173\u8054\u8868\u5355\u672a\u9009\u62e9\uff0c\u786e\u5b9a\u4e0d\u5173\u8054\u5417\uff1f", (String)"DataSourceEditPlugin_15", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, tipInfo, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private String checkFieldValidity() {
        DynamicObjectCollection ds = this.getModel().getEntryEntity(ENTRY_ENTITY);
        boolean orgStatus = false;
        boolean timeStatus = false;
        boolean yearStatus = false;
        boolean mouthStatus = false;
        for (DynamicObject d : ds) {
            if (d.getBoolean("orgstate")) {
                orgStatus = true;
            }
            if (d.getBoolean("datastate")) {
                timeStatus = true;
            }
            if (d.getBoolean("yearstate")) {
                yearStatus = true;
            }
            if (!d.getBoolean("monthstate")) continue;
            mouthStatus = true;
        }
        if (!orgStatus) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u7ec4\u7ec7\u5b57\u6bb5\u201d\u3002", (String)"DataSourceEditPlugin_16", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        if (!(timeStatus || yearStatus || mouthStatus)) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u65f6\u95f4\u5b57\u6bb5\u201d\u6216\u201c\u5e74\u4efd\u5b57\u6bb5\u201d\u3001\u201c\u6708\u4efd\u5b57\u6bb5\u201d\u3002", (String)"DataSourceEditPlugin_17", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        if (!timeStatus && !yearStatus) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5e74\u4efd\u5b57\u6bb5\u201d\u3002", (String)"DataSourceEditPlugin_18", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        if (!timeStatus && !mouthStatus) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u6708\u4efd\u5b57\u6bb5\u201d\u3002", (String)"DataSourceEditPlugin_19", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkFieldIntegrity() {
        DynamicObjectCollection taxTypes;
        String groupNumber;
        String entityName;
        StringBuilder tipInfo = new StringBuilder();
        String name = this.getModel().getValue("bizname").toString();
        if (StringUtils.isEmpty((String)name)) {
            tipInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u4e1a\u52a1\u540d\u79f0\u3001", (String)"DataSourceEditPlugin_20", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), tipInfo));
        }
        if (StringUtils.isEmpty((String)(entityName = (String)this.getModel().getValue(ENTITY_NAME)))) {
            tipInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u8868\u5355\u3001", (String)"DataSourceEditPlugin_21", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), tipInfo));
        }
        if (!"ds_yscj".equalsIgnoreCase(groupNumber = ((DynamicObject)this.getModel().getValue("group")).getString("number")) && !"ds_tjsjqs".equalsIgnoreCase(groupNumber) && !"ds_jtsjqs".equalsIgnoreCase(groupNumber) && EmptyCheckUtils.isEmpty((Object)(taxTypes = (DynamicObjectCollection)this.getModel().getValue(TAX_TYPE)))) {
            tipInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u9002\u7528\u53d6\u6570\u89c4\u5219\u3001", (String)"DataSourceEditPlugin_22", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), tipInfo));
        }
        if (tipInfo.length() > 0) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\uff1a", (String)"DataSourceEditPlugin_23", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            errorMsg.append(tipInfo.substring(0, tipInfo.length() - 1));
            return errorMsg.toString();
        }
        return null;
    }
}

