/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.datasource;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.New;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.taxc.common.constant.TemplateTypeConstant;

public class DataSourceListPlugin
extends AbstractTreeListPlugin {
    private static final String TREE_BTN = "flexpanel_treebtn";
    private static final String DS_YSCJ = "ds_yscj";
    private static final String TAXTYPE = "taxtype";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{TREE_BTN});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof New) {
            TreeNode treeNode;
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeModel().getRoot();
            if (root == (treeNode = root.getTreeNode(currentNodeId, 20))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7ec4\u8282\u70b9", (String)"DataSourceListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject data = e.getRowData();
        if (TAXTYPE.equals(columnDesc.getKey()) && DS_YSCJ.equals(data.getString("group.number"))) {
            e.setFormatValue((Object)TemplateTypeConstant.getMap().getOrDefault(data.getString(TAXTYPE), ResManager.loadKDString((String)"\u5143\u7d20\u62bd\u68c0", (String)"DataSourceListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0])));
        }
    }
}

