/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.taxc.common.json.JsonUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.enums.FieldTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class TaxcChooseFieldPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    public static final String FormId_SelectField = "botp_selectfield";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_IsMulti = "ismulti";
    public static final String CustParamKey_SelectedNodeIds = "nodeids";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    private static final String CACHEKEY_SELECTE_DNODEIDS = "nodeids";
    private static final String CACHEKEY_SELECTE_NODE_TEXT = "focus_node_text";
    public static final String Key_btnOK = "btnok";
    public static final String Key_btnCancel = "btncancel";
    public static final String Key_TreeView = "tv_fields";
    public static final String Key_SearchField = "searchfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl(Key_SearchField);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillTreeNodes();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = this.getPageCache().get("nodeids");
            String text = this.getPageCache().get(CACHEKEY_SELECTE_NODE_TEXT);
            String fieldtype = (String)this.getView().getFormShowParameter().getCustomParam("fieldtype");
            if (EmptyCheckUtils.isNotEmpty((Object)text)) {
                Map focusNode = (Map)JsonUtil.fromJson((String)text, Map.class);
                if (focusNode != null && !((Boolean)focusNode.get("isParent")).booleanValue()) {
                    HashMap<String, String> returnMap = new HashMap<String, String>();
                    if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                        returnMap.put("fieldtype", fieldtype);
                        returnMap.put("fieldvalue", currNodeId);
                        if (StringUtils.isNotBlank((CharSequence)text)) {
                            returnMap.put("fieldtext", (String)focusNode.get("text"));
                        }
                        this.getView().returnDataToParent(returnMap);
                        this.getView().close();
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u8282\u70b9", (String)"TaxcChooseFieldPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u8282\u70b9", (String)"TaxcChooseFieldPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        TreeView treeView = (TreeView)e.getSource();
        Map focusNode = treeView.getTreeState().getFocusNode();
        this.getPageCache().put("nodeids", currNodeId);
        if (focusNode != null) {
            this.getPageCache().put(CACHEKEY_SELECTE_NODE_TEXT, JsonUtil.toJson((Object)focusNode));
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String fieldtype = (String)this.getView().getFormShowParameter().getCustomParam("fieldtype");
        TreeView treeView = (TreeView)e.getSource();
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (focusNode != null && !((Boolean)focusNode.get("isParent")).booleanValue()) {
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                returnMap.put("fieldtype", fieldtype);
                returnMap.put("fieldvalue", currNodeId);
                if (focusNode != null) {
                    returnMap.put("fieldtext", (String)focusNode.get("text"));
                }
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u8282\u70b9", (String)"TaxcChooseFieldPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put("nodeids", cacheNodeIds);
    }

    private void fillTreeNodes() {
        TreeNode rootNode = this.buildTreeNode();
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, rootNode);
        }
    }

    private TreeNode buildTreeNode() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
        String subEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("subentitynumber");
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isBlank((CharSequence)json)) {
            if (StringUtils.isNotBlank((CharSequence)entitynumber)) {
                PropTreeBuildOption option = new PropTreeBuildOption();
                option.setIncludePKField(false);
                option.setIncludeBDRefProp(false);
                if (StringUtils.isBlank((CharSequence)subEntityNumber)) {
                    option.setCurrentEntity(entitynumber);
                    option.setIncludeChildEntity(false);
                }
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)entitynumber);
                rootNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
            } else {
                this.addTreeRootNode();
            }
        } else {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        this.dealMatchProp(rootNode, entitynumber);
        return rootNode;
    }

    private void dealMatchProp(TreeNode treeNode, String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String fieldtype = (String)this.getView().getFormShowParameter().getCustomParam("fieldtype");
        String subEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("subentitynumber");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldtype) && CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            Iterator iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                List children;
                TreeNode node = (TreeNode)iterator.next();
                IDataEntityProperty prop = mainEntityType.findProperty(node.getId());
                if (CollectionUtils.isEmpty((Collection)node.getChildren())) {
                    if (StringUtils.equals((CharSequence)fieldtype, (CharSequence)"orgdesc")) {
                        if (!(prop instanceof OrgProp)) {
                            iterator.remove();
                        }
                    } else {
                        Class classType = FieldTypeEnum.getClassTypeByfieldType((String)fieldtype);
                        if (classType != null && !classType.isInstance(prop)) {
                            iterator.remove();
                        }
                    }
                } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)subEntityNumber) && !StringUtils.equals((CharSequence)subEntityNumber, (CharSequence)node.getId()) && !StringUtils.equals((CharSequence)node.getId(), (CharSequence)"billhead")) {
                    iterator.remove();
                }
                if (CollectionUtils.isNotEmpty((Collection)(children = node.getChildren()))) {
                    this.dealMatchProp(node, entityNumber);
                }
                node.setChildren(children);
                if (!StringUtils.equals((CharSequence)subEntityNumber, (CharSequence)node.getId()) || !CollectionUtils.isEmpty((Collection)children)) continue;
                iterator.remove();
            }
        }
    }

    private void multiSelect(TreeView tree, TreeNode rootNode) {
        tree.setMulti(true);
        String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam("nodeids");
        if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
            this.getPageCache().put("nodeids", cacheNodeIds);
            String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
            ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
            for (String nodeId : arr) {
                TreeNode node = rootNode.getTreeNode(nodeId, 5);
                if (node == null) continue;
                selectedNodes.add(node);
            }
            if (selectedNodes.size() > 0) {
                tree.checkNodes(selectedNodes);
            }
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"TaxcChooseFieldPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(root);
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_IsMulti);
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)Key_SearchField, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        TreeNode treeNode = this.buildTreeNode();
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        if (StringUtils.isNotBlank((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
        }
        tree.updateNode(treeNode);
        if (this.isMultiSelected()) {
            this.multiSelect(tree, treeNode);
        }
    }

    private List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(this.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }
}

