/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.home;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.common.showpage.PageShowCommon;

public class CollectCardPlugin
extends AbstractFormPlugin {
    private static final String KEY_CONTENT_COLLECT = "collectflex";
    private static final String KEY_CONTENT_TCVAT = "tcvatflex";
    private static final String KEY_CONTENT_INCOME = "incomeflex";
    private static final String FIELD_EFFECTDATE = "effectdate";
    private static final String FIELD_INVALIDDATE = "invaliddate";
    private static final String KEY_COLLENT_NUM = "collect_num";
    private static final String KEY_TCVAT_NUM = "tcvat_num";
    private static final String KEY_INCOME_NUM = "income_num";

    private static String getKeyTipMsg() {
        return ResManager.loadKDString((String)"\u6b64\u6c47\u603b\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80\u201c\u7a0e\u52a1\u7ec4\u7ec7>\u6c47\u603b\u65b9\u6848\u201d\u68c0\u67e5\u6b64\u65b9\u6848\u7684\u914d\u7f6e\u60c5\u51b5\u3002", (String)"CollectCardPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_CONTENT_COLLECT, KEY_CONTENT_INCOME, KEY_CONTENT_TCVAT, KEY_COLLENT_NUM, KEY_TCVAT_NUM, KEY_INCOME_NUM});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        if (KEY_CONTENT_COLLECT.equals(key) || KEY_COLLENT_NUM.equals(key)) {
            QFilter status = new QFilter("status", "=", (Object)"2");
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tctb_org_group_latest", (IFormView)view, null, null, (QFilter)status);
        } else if (KEY_CONTENT_TCVAT.equals(key) || KEY_CONTENT_INCOME.equals(key) || KEY_TCVAT_NUM.equals(key) || KEY_INCOME_NUM.equals(key)) {
            QFilter q3;
            Date now = new Date();
            QFilter q1 = new QFilter("status", "=", (Object)"2");
            QFilter q2 = QFilter.isNull((String)FIELD_INVALIDDATE).or(new QFilter(FIELD_EFFECTDATE, "<=", (Object)now).and(FIELD_INVALIDDATE, ">=", (Object)now));
            List<Long> pkId = this.getPkId(new QFilter[]{q1, q2, q3 = KEY_CONTENT_TCVAT.equals(key) || KEY_TCVAT_NUM.equals(key) ? new QFilter("taxtype", "=", (Object)"zzs") : new QFilter("taxtype", "=", (Object)"qysds")});
            if (ObjectUtils.isEmpty(pkId)) {
                view.getParentView().showTipNotification(CollectCardPlugin.getKeyTipMsg(), Integer.valueOf(8000));
                view.sendFormAction(view.getParentView());
                return;
            }
            QFilter filter = new QFilter("id", "in", pkId);
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tctb_org_group_latest", (IFormView)view, null, null, (QFilter)filter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    private void init() {
        Date now = new Date();
        QFilter q1 = new QFilter("status", "=", (Object)"2");
        QFilter q2 = QFilter.isNull((String)FIELD_INVALIDDATE).or(new QFilter(FIELD_EFFECTDATE, "<=", (Object)now).and(FIELD_INVALIDDATE, ">=", (Object)now));
        String collSize = this.getSize(new QFilter[]{q1, q2});
        ((Label)this.getControl(KEY_COLLENT_NUM)).setText(collSize);
        QFilter q3 = new QFilter("taxtype", "=", (Object)"zzs");
        ((Label)this.getControl(KEY_TCVAT_NUM)).setText(this.getOrgNum(new QFilter[]{q1, q2, q3}, "zzs"));
        QFilter q4 = new QFilter("taxtype", "=", (Object)"qysds");
        ((Label)this.getControl(KEY_INCOME_NUM)).setText(this.getOrgNum(new QFilter[]{q1, q2, q4}, "qysds"));
    }

    private String getSize(QFilter[] qfs) {
        DynamicObjectCollection dcoll = QueryServiceHelper.query((String)"tctb_org_group_latest", (String)"status", (QFilter[])qfs);
        int size = 0;
        if (dcoll != null && !dcoll.isEmpty()) {
            size = dcoll.size();
        }
        return String.valueOf(size);
    }

    private String getOrgNum(QFilter[] qfs, String type) {
        AtomicInteger size = new AtomicInteger(0);
        DynamicObject[] dobj = BusinessDataServiceHelper.load((String)"tctb_org_group_latest", (String)"id,orgrow", (QFilter[])qfs);
        if (dobj != null && dobj.length > 0) {
            Arrays.stream(dobj).forEach(o -> {
                DynamicObjectCollection ecoll = o.getDynamicObjectCollection("orgrow");
                if (ecoll != null && !ecoll.isEmpty()) {
                    size.getAndAdd(ecoll.size());
                }
            });
        }
        return String.valueOf(size.get());
    }

    private List<Long> getPkId(QFilter[] qfs) {
        DynamicObject[] dobj = BusinessDataServiceHelper.load((String)"tctb_org_group_latest", (String)"id", (QFilter[])qfs);
        List<Long> pkids = new ArrayList<Long>();
        if (dobj != null && dobj.length > 0) {
            pkids = Arrays.stream(dobj).map(o -> o.getLong("id")).collect(Collectors.toList());
        }
        return pkids;
    }
}

