/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.license;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseApplyService;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseService;

public class LicenseApplyEditPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntries();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.innerLoadData();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isAfterConfirm;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (("submit".equalsIgnoreCase(operationKey) || "audit".equalsIgnoreCase(operationKey)) && !(isAfterConfirm = operate.getOption().tryGetVariableValue("afterconfirm", new RefObject()))) {
            this.showConfirms(operationKey);
            args.setCancel(true);
            return;
        }
    }

    protected void showConfirms(String operationKey) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operationKey, (IFormPlugin)this);
        this.getView().showConfirm(this.getConfirmMsg(operationKey), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if ("submit".equalsIgnoreCase(e.getCallBackId()) && isOK) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        } else if ("audit".equalsIgnoreCase(e.getCallBackId()) && isOK) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("audit", operateOption);
        }
    }

    protected void innerLoadData() {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        List orgIds = entries.stream().map(v -> v.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        Map orgMap = TaxcLicenseApplyService.getOrgMap(orgIds);
        Long orgId = null;
        DynamicObject entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (DynamicObject)entries.get(i);
            orgId = entry.getDynamicObject("org").getLong("id");
            if (orgMap.get(orgId) == null) continue;
            this.getModel().setValue("unifiedsocialcode", (Object)((DynamicObject)orgMap.get(orgId)).getString("unifiedsocialcode"), i);
        }
    }

    protected void initEntries() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List ids = (List)showParameter.getCustomParam("ids");
        String groupid = (String)showParameter.getCustomParam("groupid");
        if (ObjectUtils.isEmpty((Object)ids) || StringUtils.isEmpty((CharSequence)groupid)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5206\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"LicenseApplyEditPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject group = TaxcLicenseService.queryTaxLicenseGroupById((Long)Long.parseLong(groupid));
        DynamicObject[] coll = TaxcLicenseService.queryTaxLicenseByIds((List)ids);
        List orgIds = Stream.of(coll).map(v -> v.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
        Map orgMap = TaxcLicenseApplyService.getOrgMap(orgIds);
        int[] newEntryRow = this.getModel().batchCreateNewEntryRow("entryentity", coll.length);
        DynamicObject entry = null;
        Long orgId = null;
        for (int index : newEntryRow) {
            entry = coll[index];
            orgId = entry.getDynamicObject("orgid").getLong("id");
            this.getModel().setValue("org", (Object)entry.getDynamicObject("orgid"), index);
            if (orgMap.get(orgId) != null) {
                this.getModel().setValue("unifiedsocialcode", (Object)((DynamicObject)orgMap.get(orgId)).getString("unifiedsocialcode"), index);
            }
            this.getModel().setValue("applystatus", (Object)LicenseApplyEditPlugin.getApplyStatus(entry.getString("licensestatus")), index);
            this.getModel().setValue("group", (Object)group, index);
            this.getModel().setValue("licenseid", (Object)entry.getLong("id"), index);
        }
    }

    protected String getConfirmMsg(String operationKey) {
        DynamicObject obj = this.getModel().getDataEntity(true);
        Map<String, List<DynamicObject>> groupMap = obj.getDynamicObjectCollection("entryentity").stream().collect(Collectors.groupingBy(entry -> entry.getString("applystatus")));
        List applyList = groupMap.getOrDefault("A", new ArrayList(1));
        List cancelList = groupMap.getOrDefault("B", new ArrayList(1));
        StringBuilder msg = new StringBuilder();
        if (applyList.size() > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u7533\u8bf7\u5355\u4e2d\u6709%s\u4e2a\u7ec4\u7ec7\u7533\u8bf7\u6388\u6743\uff0c\u6388\u6743\u540e\u5c06\u65e0\u6cd5\u4fee\u6539\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff0c\u8bf7\u786e\u4fdd\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u7684\u51c6\u786e\u6027\u3002", (String)"LicenseApplyEditPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), applyList.size()));
        }
        if (cancelList.size() > 0) {
            if (msg.length() > 0) {
                msg.append("\\r\\n");
            }
            msg.append(String.format(ResManager.loadKDString((String)"\u5ba1\u6279\u7533\u8bf7\u5355\u4e2d\u6709%s\u4e2a\u7ec4\u7ec7\u7533\u8bf7\u6ce8\u9500\uff0c\u6ce8\u9500\u540e\u5c06\u5bfc\u81f4\u65e0\u6cd5\u4f7f\u7528\u7a0e\u52a1\u4e91\u7684\u6240\u6709\u529f\u80fd\uff0c\u4e14\u65e0\u6cd5\u6062\u590d\u3002", (String)"LicenseApplyEditPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), cancelList.size()));
        }
        if ("submit".equalsIgnoreCase(operationKey)) {
            msg.append(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u63d0\u4ea4\u5417\uff1f", (String)"LicenseApplyEditPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else if ("audit".equalsIgnoreCase(operationKey)) {
            msg.append(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5ba1\u6838\u901a\u8fc7\u5417\uff1f", (String)"LicenseApplyEditPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static String getApplyStatus(String licensestatus) {
        String applystatus = "A";
        if ("A".equals(licensestatus)) {
            applystatus = "A";
        } else if ("B".equals(licensestatus)) {
            applystatus = "B";
        }
        return applystatus;
    }
}

