/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.license;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseBusiness;
import kd.taxc.tctb.formplugin.license.LicenseGroupListView;

public class LicenseGroupListPlugin
extends StandardTreeListPlugin {
    private LicenseGroupListView treeListView = new LicenseGroupListView();
    private ITreeModel treeModel;

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        e.setView((AbstractTreeListView)this.treeListView);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel", "searchap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
    }

    protected ITreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = this.getTreeListView().getTreeModel();
        }
        return this.treeModel;
    }

    public void initializeTree(EventObject e) {
        TreeNode root = this.getTreeModel().createRootNode();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public void itemClick(ItemClickEvent e) {
        String itemKey = e.getItemKey();
        if ("baritemap1".equals(itemKey)) {
            this.refreshTreeView();
        }
    }

    protected void refreshTreeView() {
        this.getTreeListView().focusRootNode();
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode(this.getTreeModel().getCurrentNodeId());
        this.getTreeListView().getTreeView().updateNode(node);
        this.getTreeListView().getTreeView().focusNode(node);
        this.getTreeListView().getTreeView().treeNodeClick(node.getParentid(), node.getId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (key.equals("addapply")) {
            this.addLicenseApply();
        } else if (key.equals("viewapply")) {
            this.viewLicenseApply();
        }
    }

    protected void addLicenseApply() {
        if (!this.checkBeforeAddLicenseApply()) {
            return;
        }
        List<Long> ids = this.getSelectIds();
        String nodeId = this.getNodeId(this.getTreeModel());
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tctb_license_apply");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("ids", ids);
        showParameter.setCustomParam("groupid", (Object)nodeId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addLicenseApply"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void viewLicenseApply() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("tctb_license_apply");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewLicenseApply"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("addLicenseApply".equals(e.getActionId()) || "viewLicenseApply".equals(e.getActionId())) {
            TreeNode node = this.getTreeListView().getTreeModel().refreshNode(this.getTreeModel().getCurrentNodeId());
            this.getTreeListView().getTreeView().updateNode(node);
            this.getTreeListView().getTreeView().focusNode(node);
            this.getTreeListView().getTreeView().treeNodeClick(node.getParentid(), node.getId());
        }
    }

    protected List<Long> getSelectIds() {
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection listSelectedRowCollection = listView.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow listRow : listSelectedRowCollection) {
            ids.add((Long)listRow.getPrimaryKeyValue());
        }
        return ids;
    }

    protected boolean checkBeforeAddLicenseApply() {
        String nodeId;
        String rootid = this.getTreeModel().getRoot().getId();
        if (rootid.equals(nodeId = this.getNodeId(this.getTreeModel()))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u5e94\u5206\u7ec4\uff0c\u624d\u80fd\u6388\u6743\u3002", (String)"LicenseGroupListPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return false;
        }
        List<Long> ids = this.getSelectIds();
        DynamicObject[] coll = TaxcLicenseBusiness.queryTaxLicenseByIds(ids);
        Map<String, List<DynamicObject>> groupMap = Stream.of(coll).collect(Collectors.groupingBy(obj -> obj.getString("licensestatus")));
        List canceledList = groupMap.getOrDefault("C", new ArrayList(1));
        if (canceledList.size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u4e86\u72b6\u6001\u662f\u201c\u5df2\u6ce8\u9500\u201d\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u5bf9\u201c\u5df2\u6ce8\u9500\u201d\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LicenseGroupListPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return false;
        }
        Optional checkUnifiedsocialcodeOpt = TaxcLicenseBusiness.checkUnifiedsocialcode((DynamicObject[])coll);
        if (checkUnifiedsocialcodeOpt.isPresent()) {
            this.getView().showMessage((String)checkUnifiedsocialcodeOpt.get());
            return false;
        }
        Optional checkOnTheWayOpt = TaxcLicenseBusiness.checkOnTheWay(ids);
        if (checkOnTheWayOpt.isPresent()) {
            this.getView().showMessage((String)checkOnTheWayOpt.get());
            return false;
        }
        List cancelList = groupMap.getOrDefault("B", new ArrayList(1));
        int applyCount = ids.size() - cancelList.size();
        Optional checkLicenseEnoughOpt = TaxcLicenseBusiness.checkLicenseEnough((Long)Long.parseLong(nodeId), (int)applyCount, (int)cancelList.size());
        if (checkLicenseEnoughOpt.isPresent()) {
            this.getView().showMessage((String)checkLicenseEnoughOpt.get());
            return false;
        }
        return true;
    }

    private String getNodeId(ITreeModel tree) {
        String nodeId = (String)tree.getCurrentNodeId();
        if (nodeId.startsWith("38")) {
            nodeId = "38";
        }
        return nodeId;
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        super.treeNodeClick(treenodeevent);
        this.getPageCache().put("licTreeFocusNode", treenodeevent.getNodeId() + "");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainlower"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
        if (e.getSource() instanceof ListView) {
            TreeNode root;
            TreeNode treeNode;
            String nodeId = "38";
            if (this.getTreeModel().getGroupProp() != null && null != (treeNode = (root = this.getTreeModel().getRoot()).getTreeNode(nodeId))) {
                this.getTreeModel().setCurrentNodeId((Object)nodeId);
                this.getTreeListView().getTreeView().updateNode(treeNode);
                this.getTreeListView().getTreeView().focusNode(treeNode);
                this.getTreeListView().getTreeView().treeNodeClick(treeNode.getParentid(), treeNode.getId());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("orgid.number");
        e.getQFilters().add(new QFilter("ver", "=", (Object)TaxcLicenseBusiness.getLicenseVersion()));
        e.getQFilters().add(new QFilter("orgid", "!=", (Object)0));
        List list = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
        QFilter viewOrgsQ = new QFilter("orgid", "in", (Object)list);
        e.getCustomQFilters().add(viewOrgsQ);
        super.setFilter(e);
    }
}

