/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.license;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.list.query.QueryFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctb.business.taxclicense.TaxcLicenseBusiness;

public class LiscenseListModel
extends TreeListModel {
    private String BASTAX_TAXORG = "bastax_taxorg";
    private String pageId;
    private ListViewPluginProxy proxy;
    private TreeNode rootNode;
    private String rootNodeCacheKey;
    private IPageCache pageCache;
    private Object currentNodeId;

    public TreeNode getRoot() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        String rootNodeStr = this.pageCache.get(this.rootNodeCacheKey);
        if (StringUtils.isNotBlank((CharSequence)rootNodeStr)) {
            this.rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
        }
        return this.rootNode;
    }

    public LiscenseListModel(String pageId, EntityType dataEntityType) {
        super(pageId, dataEntityType);
        this.pageId = pageId;
        this.rootNodeCacheKey = String.format("%s.root", pageId);
    }

    private TreeNode getTreeNode(Object nodeId) {
        if (this.getRoot() == null) {
            return this.createRootNode();
        }
        return this.getRoot().getTreeNode(nodeId.toString(), 10);
    }

    public TreeNode refreshNode(Object nodeId) {
        TreeNode node = this.getTreeNode(nodeId);
        if (node == null) {
            return node;
        }
        RefreshNodeEvent e = new RefreshNodeEvent((Object)this, nodeId);
        this.proxy.fireRefreshNode(e);
        List<TreeNode> list = e.getChildNodes();
        if (list == null) {
            list = this.getTreeNodeChildNodes(nodeId, node.getLongNumber());
        }
        if (list.size() > 0) {
            node.setChildren(list);
        } else {
            node.setChildren(null);
        }
        this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)this.rootNode));
        return node;
    }

    public List<QFilter> getTreeFilter() {
        List filter = super.getTreeFilter();
        if (TaxcLicenseBusiness.isQuotationMode()) {
            filter.add(new QFilter("ver", "=", (Object)"4.0"));
        } else {
            filter.add(new QFilter("ver", "=", (Object)"3.0"));
        }
        return filter;
    }

    public List<TreeNode> getTreeNodeChildNodes(Object parentId, String longNumber) {
        GroupProp group = this.getGroupProp();
        if (group == null || parentId == null) {
            return new ArrayList<TreeNode>();
        }
        IQuery query = QueryFactory.createQuery();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.BASTAX_TAXORG, (String)"id,unifiedsocialcode", null);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject d : doc) {
            map.put(d.getString("id"), d);
        }
        HashMap hashMap = new HashMap();
        if (this.isRootTreeNode(parentId)) {
            List list = query.getGroupNodes(group, this.getTreeFilter(), this.getTextFormat(), null, null, hashMap);
            TaxcLicenseBusiness.delDate();
            return this.createTree(list, parentId, map);
        }
        boolean existParentFiled = false;
        for (IDataEntityProperty prop : group.getEntityType().getProperties()) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            existParentFiled = true;
            break;
        }
        if (!existParentFiled && "3.0".equals(TaxcLicenseBusiness.getLicenseVersion())) {
            return new ArrayList<TreeNode>();
        }
        List list = query.getGroupNodes(group, this.getTreeFilter(), this.getTextFormat(), null, null, hashMap);
        return this.createTree(list, parentId, map);
    }

    private List<TreeNode> createTree(List<TreeNode> list, Object parentId, Map<String, DynamicObject> map) {
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(16);
        Collections.sort(list, new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                if (Long.parseLong(o1.getId()) > Long.parseLong(o2.getId())) {
                    return 1;
                }
                if (Long.parseLong(o1.getId()) == Long.parseLong(o2.getId())) {
                    return 0;
                }
                return -1;
            }
        });
        Iterator<TreeNode> it = list.iterator();
        Map gmLicense = TaxcLicenseBusiness.getAppPurchaseQuantity();
        while (it.hasNext()) {
            TreeNode treeNode = it.next();
            TaxcLicenseBusiness.syncData((String)treeNode.getId());
            if (treeNode.getId().equals("38") || treeNode.getId().equals("34") || treeNode.getId().equals("35") || treeNode.getId().equals("37")) {
                this.getLicenseNum(treeNode);
            } else if (treeNode.getId().startsWith("380") || treeNode.getId().startsWith("381")) {
                if (null != gmLicense.get(treeNode.getId())) {
                    this.changeParenId("38", treeNode, treeNodeMap);
                }
                it.remove();
            } else if (treeNode.getId().startsWith("390")) {
                if (TaxcLicenseBusiness.isFeaturesPurchaseQuantityByNodeId((String)treeNode.getId())) {
                    this.changeParenId("39", treeNode, treeNodeMap);
                }
                it.remove();
            } else {
                treeNode.setParentid(parentId.toString());
            }
            treeNodeMap.put(treeNode.getId(), treeNode);
        }
        if (!this.isRootTreeNode(parentId)) {
            for (TreeNode t : list) {
                if (!t.getId().equals(parentId)) continue;
                if (null == t.getChildren()) {
                    return new ArrayList<TreeNode>();
                }
                return t.getChildren();
            }
            return new ArrayList<TreeNode>();
        }
        return list;
    }

    private void changeParenId(String parenid, TreeNode treeNode, Map<String, TreeNode> treeNodeMap) {
        treeNode.setParentid(parenid);
        TreeNode pTreeNode = treeNodeMap.get(parenid);
        ArrayList<TreeNode> childList = pTreeNode.getChildren();
        if (childList == null) {
            childList = new ArrayList<TreeNode>();
        }
        childList.add(treeNode);
        pTreeNode.setChildren(childList);
    }

    public TreeNode getLicenseNum(TreeNode treeNode) {
        String groupId = treeNode.getId();
        if (null == groupId) {
            return null;
        }
        DynamicObject group = TaxcLicenseBusiness.queryTaxLicenseGroupById((Long)Long.valueOf(groupId));
        int assignedCount = TaxcLicenseBusiness.getLicenseEmpowerQuantity((String)groupId);
        int totalCount = TaxcLicenseBusiness.getLicensePurchaseQuantity((String)groupId);
        if (TaxcLicenseBusiness.isQuotationMode()) {
            if (group != null && "38".equals(groupId)) {
                treeNode.setText(group.getString("name") + "(" + assignedCount + "/" + totalCount + ")");
            } else {
                String text = treeNode.getText();
                treeNode.setText(text);
            }
        } else if (group != null) {
            treeNode.setText(group.getString("name") + "(" + assignedCount + "/" + totalCount + ")");
        } else {
            treeNode.setText(treeNode.getText() + "(" + assignedCount + "/" + totalCount + ")");
        }
        return treeNode;
    }

    private boolean isRootTreeNode(Object nodeId) {
        if (this.getRoot() == null) {
            return false;
        }
        return this.getRoot().getId().compareTo(nodeId.toString()) == 0;
    }

    public void setCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    private IPageCache getPageCache() {
        if (this.pageCache == null) {
            this.pageCache = new PageCache(this.pageId);
        }
        return this.pageCache;
    }

    public void setPluginProxy(ListViewPluginProxy proxy) {
        this.proxy = proxy;
    }

    public Object getCurrentNodeId() {
        if (this.currentNodeId == null) {
            this.currentNodeId = this.pageCache.get(String.format("%s.currentnodeid", this.pageId));
        }
        return this.currentNodeId;
    }

    public void setCurrentNodeId(Object currentNodeId) {
        this.currentNodeId = currentNodeId;
        this.pageCache.put(String.format("%s.currentnodeid", this.pageId), currentNodeId.toString());
    }

    public void setRoot(TreeNode root) {
        this.rootNode = root;
        this.pageCache.put(this.rootNodeCacheKey, SerializationUtils.toJsonString((Object)root));
    }

    public QFilter getListFilter() {
        String currNodeId;
        if (this.currentNodeId == null) {
            return null;
        }
        BuildTreeListFilterEvent args = new BuildTreeListFilterEvent((Object)this, this.currentNodeId);
        this.proxy.fireBuildTreeListFilter(args);
        if (args.isCancel()) {
            if (!args.getFilters().isEmpty()) {
                return (QFilter)args.getFilters().get(0);
            }
            return null;
        }
        GroupProp prop = this.getGroupProp();
        if (prop == null || this.isRootTreeNode(this.currentNodeId)) {
            return new QFilter("ver", "=", (Object)TaxcLicenseBusiness.getLicenseVersion());
        }
        Class pkClass = prop.getDynamicComplexPropertyType().getPrimaryKey().getPropertyType();
        boolean number = pkClass == Integer.TYPE || pkClass == Integer.class || pkClass == Long.TYPE || pkClass == Long.class;
        String string = currNodeId = number ? Long.valueOf(Long.parseLong(String.valueOf(this.currentNodeId))) : this.currentNodeId.toString();
        if (TaxcLicenseBusiness.isQuotationMode()) {
            if (!"38".equals(currNodeId.toString()) && !currNodeId.toString().startsWith("39")) {
                return new QFilter(prop.getName(), "=", (Object)currNodeId).or(new QFilter(prop.getName(), "=", (Object)38));
            }
            return new QFilter(prop.getName(), "=", (Object)currNodeId);
        }
        return new QFilter(prop.getName(), "=", (Object)currNodeId);
    }
}

