/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.time.LocalDate;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.common.util.DateUtils;

public class DeductionRatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            this.setDefaultValue(org.getLong("id"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date startdate;
        LocalDate startLocalDate;
        String key = e.getProperty().getName();
        if ("org".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.setDefaultValue(org.getLong("id"));
        }
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("datestart".equals(key) && newValue != null && !DateUtils.isFirstOrLastDay((String)"start", (LocalDate)(startLocalDate = DateUtils.date2LocalDate((Date)(startdate = (Date)newValue))))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u6708\u521d1\u53f7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DeductionRatePlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void setDefaultValue(Long orgid) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgid)});
        if (null == this.getModel().getValue("name")) {
            this.getModel().setValue("name", dyo.get("name"));
        }
        DynamicObject taxorg = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)MetadataUtil.getAllSubFieldString((String)"bastax_taxorg"), (QFilter[])new QFilter[]{orgFilter});
        if (null == this.getModel().getValue("taxorg")) {
            this.getModel().setValue("taxorg", (Object)taxorg.getLong("id"));
        }
        if (null == this.getModel().getValue("istaxpayer")) {
            this.getModel().setValue("istaxpayer", taxorg.get("istaxpayer"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"org"});
        BasedataEdit accountorgBase = (BasedataEdit)this.getView().getControl("org");
        accountorgBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter istaxpayer = new QFilter("istaxpayer", "=", (Object)"1");
        QFilter enable = new QFilter("status", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id", (QFilter[])new QFilter[]{istaxpayer, enable});
        List orgid = query.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        customQFilters.add(new QFilter("id", "in", orgid));
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        Map org = (Map)sourceData.get("org");
        Long orgid = (Long)org.get("id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"bos_org", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgid)});
        if (null == dyo) {
            return;
        }
        this.getModel().setValue("name", dyo.get("name"));
        DynamicObject taxorg = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)MetadataUtil.getAllSubFieldString((String)"bastax_taxorg"), (QFilter[])new QFilter[]{orgFilter});
        this.getModel().setValue("taxorg", (Object)taxorg.getLong("id"));
        this.getModel().setValue("istaxpayer", taxorg.get("istaxpayer"));
    }
}

