/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.taxc.common.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class HjbhsEntryList
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String caption = (String)e.getFormShowParameter().getCustomParam("caption");
        if (StringUtil.isNotBlank((CharSequence)caption)) {
            e.getFormShowParameter().setCaption(caption);
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = this.getCustomerFilter();
        if (qFilter != null) {
            e.getQFilters().add(qFilter);
        }
    }

    public void packageData(PackageDataEvent e) {
        Date now = new Date();
        DynamicObject dynObj = e.getRowData();
        Date validFrom = dynObj.getDate("startdate");
        Date expired = dynObj.getDate("enddate");
        if (validFrom == null && expired == null) {
            dynObj.set("status", (Object)ResManager.loadKDString((String)"\u53ef\u7528", (String)"HjbhsEntryList_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else if (validFrom == null && expired.compareTo(now) >= 0) {
            dynObj.set("status", (Object)ResManager.loadKDString((String)"\u53ef\u7528", (String)"HjbhsEntryList_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else if (expired == null && validFrom.compareTo(now) <= 0) {
            dynObj.set("status", (Object)ResManager.loadKDString((String)"\u53ef\u7528", (String)"HjbhsEntryList_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else if (validFrom != null && expired != null && validFrom.compareTo(now) <= 0 && expired.compareTo(now) >= 0) {
            dynObj.set("status", (Object)ResManager.loadKDString((String)"\u53ef\u7528", (String)"HjbhsEntryList_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        } else {
            dynObj.set("status", (Object)ResManager.loadKDString((String)"\u7981\u7528", (String)"HjbhsEntryList_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public List<ListField> getListFields() {
                ListField validfrom = new ListField("startdate");
                validfrom.setListFieldKey("startdate");
                validfrom.setFieldName("startdate");
                validfrom.setEntityName("tctb_hjbhs_entry");
                ListField expired = new ListField("enddate");
                expired.setListFieldKey("enddate");
                expired.setFieldName("enddate");
                expired.setEntityName("tctb_hjbhs_entry");
                List listFields = super.getListFields();
                listFields.add(validfrom);
                listFields.add(expired);
                return listFields;
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                DynamicObjectType dot = data.getDynamicObjectType();
                DynamicSimpleProperty status = new DynamicSimpleProperty("status", String.class, (Object)"");
                dot.addProperty((DynamicProperty)status);
                data.sort(Comparator.comparingInt(this::enableSort));
                return data;
            }

            private int enableSort(DynamicObject dynObj) {
                Date validFrom = dynObj.getDate("startdate");
                Date expired = dynObj.getDate("enddate");
                Date now = new Date();
                if (validFrom == null && expired == null) {
                    return 0;
                }
                if (validFrom == null && expired.compareTo(now) >= 0) {
                    return 0;
                }
                if (expired == null && validFrom.compareTo(now) <= 0) {
                    return 0;
                }
                if (validFrom != null && expired != null && validFrom.compareTo(now) <= 0 && expired.compareTo(now) >= 0) {
                    return 0;
                }
                return 1;
            }
        });
    }

    private QFilter getCustomerFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String number = (String)customParams.get("number");
        String enable = (String)customParams.get("enable");
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)number)) {
            qFilter = new QFilter("number", "in", (Object)Arrays.stream(number.split(",")).toArray());
        }
        if (StringUtils.isNotBlank((CharSequence)enable)) {
            if (qFilter == null) {
                qFilter = new QFilter("enable", "in", (Object)Arrays.stream(enable.split(",")).toArray());
            } else {
                qFilter.and(new QFilter("enable", "in", (Object)Arrays.stream(enable.split(",")).toArray()));
            }
        }
        return qFilter;
    }
}

