/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.common.plugin.AbstractOrgGroupSelectPlugin;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.StringUtil;
import kd.taxc.tctb.business.taxcmain.TaxcMainBusiness;

public class OrgGroupSelectPlugin
extends AbstractOrgGroupSelectPlugin {
    private static final String TREE_RIGHT = "tree_right";

    public boolean exceedLevle(TreeNode node, int maxLevle, int currLevel) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            return maxLevle < currLevel;
        }
        for (TreeNode child : node.getChildren()) {
            boolean result = this.exceedLevle(child, maxLevle, currLevel + 1);
            if (!result) continue;
            return result;
        }
        return false;
    }

    public boolean verifyOrg(String taxType, TreeNode node) {
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            return this.verify(Long.valueOf(node.getId()), node.getText(), taxType);
        }
        if (!this.verify(Long.valueOf(node.getId()), node.getText(), taxType)) {
            return false;
        }
        for (TreeNode child : node.getChildren()) {
            boolean result = this.verifyOrg(taxType, child);
            if (result) continue;
            return false;
        }
        return true;
    }

    public boolean verify(Long orgId, String orgName, String taxType) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgId);
        orgFilter.and(new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId()));
        DynamicObject taxMainInfo = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)"categoryentryentity.taxtype,categoryentryentity.enable", (QFilter[])orgFilter.toArray());
        if (taxMainInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4f01\u4e1a\u8bf7\u5148\u5728\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"OrgGroupSelectPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[]{orgName}));
            return false;
        }
        DynamicObjectCollection categoryEntryEntitys = taxMainInfo.getDynamicObjectCollection("categoryentryentity");
        boolean taxpanel = false;
        for (DynamicObject categoryEntryEntity : categoryEntryEntitys) {
            if ("sljsjj".equals(taxType) && StringUtil.equalsIgnoreCase((CharSequence)categoryEntryEntity.getString("taxtype"), (CharSequence)"qtsf")) {
                taxpanel = true;
                if (StringUtil.equalsIgnoreCase((CharSequence)categoryEntryEntity.getString("enable"), (CharSequence)"0")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4f01\u4e1a\u8bf7\u5148\u5728\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"OrgGroupSelectPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[]{orgName}));
                    return false;
                }
            }
            if (!"cwbb".equals(taxType) || !StringUtil.equalsIgnoreCase((CharSequence)categoryEntryEntity.getString("taxtype"), (CharSequence)"cwbb")) continue;
            taxpanel = true;
            if (!StringUtil.equalsIgnoreCase((CharSequence)categoryEntryEntity.getString("enable"), (CharSequence)"0")) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4f01\u4e1a\u8bf7\u5148\u5728\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"OrgGroupSelectPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[]{orgName}));
            return false;
        }
        if (!taxpanel) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4f01\u4e1a\u8bf7\u5148\u5728\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u201d\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"OrgGroupSelectPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[]{orgName}));
            return false;
        }
        if (taxType.equalsIgnoreCase("cwbb")) {
            return true;
        }
        QFilter taxcateFilter = new QFilter("number", "=", (Object)"0089");
        DynamicObject waterConstructionFund = BusinessDataServiceHelper.loadSingle((String)"tpo_zspm", (String)"id", (QFilter[])taxcateFilter.toArray());
        String waterConstructionFundID = waterConstructionFund.getString("id");
        DynamicObject qtsfInfo = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)"qtsfentity.collectrate,qtsfentity.effectivestart,qtsfentity.effectiveend", (QFilter[])orgFilter.toArray());
        DynamicObjectCollection zspms = qtsfInfo.getDynamicObjectCollection("qtsfentity");
        boolean contain = false;
        ArrayList<DynamicObject> waterConFundZspm = new ArrayList<DynamicObject>();
        for (DynamicObject zspm : zspms) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)zspm.getDynamicObject("collectrate").getString("id"), (CharSequence)waterConstructionFundID)) continue;
            contain = true;
            waterConFundZspm.add(zspm);
        }
        if (!contain) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u9700\u5148\u5728\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u5176\u4ed6\u7a0e\u8d39\u201d\u4e2d\u7ef4\u62a4\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u3002", (String)"OrgGroupSelectPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[]{orgName}));
            return false;
        }
        boolean valid = false;
        for (DynamicObject zspm : waterConFundZspm) {
            Date effectivestart = zspm.getDate("effectivestart");
            Date effectiveend = zspm.getDate("effectiveend");
            Date effectdate = (Date)this.getView().getParentView().getModel().getValue("effectdate");
            Date invaliddate = (Date)this.getView().getParentView().getModel().getValue("invaliddate");
            if (effectiveend != null && invaliddate != null && DateUtils.isEffectiveDate((Date)effectdate, (Date)invaliddate, (Date)effectivestart, (Date)effectiveend)) {
                valid = true;
                continue;
            }
            if (effectiveend != null || effectdate == null || !effectivestart.before(effectdate) && effectivestart.getTime() != effectdate.getTime()) continue;
            valid = true;
        }
        if (!valid) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u603b\u65b9\u6848\u7684\u6709\u6548\u671f\u8d77\u6b62\u4e0d\u5728\u201c\u57fa\u7840\u8bbe\u7f6e>\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406>\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f>\u7a0e\u79cd\u4fe1\u606f>\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u201d\u7684\u201c\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u201d\u6709\u6548\u671f\u8d77\u6b62\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"OrgGroupSelectPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[]{orgName}));
            return false;
        }
        return true;
    }

    public boolean validate() {
        TreeNode root = this.getRoot(TREE_RIGHT);
        List childList = root.getChildren();
        if (childList == null || childList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u7ec4\u7ec7\u3002", (String)"OrgGroupSelectPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ((childList = childList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getText()) && StringUtils.isNotBlank((CharSequence)x.getLongText())).collect(Collectors.toList())).size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a1\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSelectPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            return false;
        }
        String taxType = (String)this.getView().getParentView().getModel().getValue("taxtype");
        int maxlevle = 2;
        if ("qysds".equals(taxType) || "zzs".equals(taxType) || "sljsjj".equals(taxType) || "cwbb".equals(taxType)) {
            maxlevle = 3;
        }
        for (TreeNode node : childList) {
            if (node.getChildren() == null || node.getChildren().isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4e0b\u7ea7\u673a\u6784\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSelectPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean result = this.exceedLevle(node, maxlevle, 1);
            if (result) {
                if ("qysds".equals(taxType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u6c47\u603b\u5173\u7cfb\u6700\u591a\u5141\u8bb8\u5efa\u7acb\u4e09\u7ea7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSelectPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if ("zzs".equals(taxType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u6c47\u603b\u5173\u7cfb\u6700\u591a\u5141\u8bb8\u5efa\u7acb\u4e09\u7ea7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSelectPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if ("sljsjj".equals(taxType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u6c47\u603b\u5173\u7cfb\u6700\u591a\u5141\u8bb8\u5efa\u7acb\u4e09\u7ea7\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"OrgGroupSelectPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if ("cwbb".equals(taxType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868\u6c47\u603b\u5173\u7cfb\u6700\u591a\u5141\u8bb8\u5efa\u7acb\u4e09\u7ea7\uff0c\u8bf7\u8c03\u6574\u540e\u4fdd\u5b58\u3002", (String)"OrgGroupSelectPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            if (!"sljsjj".equals(taxType) && !"cwbb".equals(taxType) || this.verifyOrg(taxType, node)) continue;
            return false;
        }
        if ("qysds".equals(taxType) && !this.verifyCit()) {
            return false;
        }
        this.getView().returnDataToParent(childList);
        return true;
    }

    protected Map<String, String> goClickValidatorResult(List<String> selectIds) {
        String taxType = (String)this.getView().getParentView().getModel().getValue("taxtype");
        Map<String, String> validatorResult = new HashMap<String, String>(10);
        if ("qysds".equals(taxType)) {
            List orgIds = selectIds.stream().map(v -> Long.parseLong(v)).distinct().collect(Collectors.toList());
            DynamicObject[] objects = TaxcMainBusiness.loadTaxcMainQysdsByOrgIds(orgIds, (Long)TaxationsysMappingEnum.CHN.getId());
            validatorResult = Stream.of(objects).filter(obj -> {
                DynamicObjectCollection taxTypes = obj.getDynamicObjectCollection("categoryentryentity");
                if (taxTypes.size() > 0) {
                    DynamicObject taxTypeObj = (DynamicObject)taxTypes.get(0);
                    return "jmqy".equals(taxTypeObj.getString("residenttype")) && "hdzs".equals(taxTypeObj.getString("levytype"));
                }
                return false;
            }).collect(Collectors.toMap(k -> k.getString("taxorg.org.id"), v -> v.getString("taxorg.org.name").concat(ResManager.loadKDString((String)"\u4e3a\u5c45\u6c11\u4f01\u4e1a\u6838\u5b9a\u5f81\u6536\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\u3002", (String)"OrgGroupSelectPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]))));
        }
        return validatorResult;
    }

    private boolean verifyCit() {
        TreeNode root = this.getRoot(TREE_RIGHT);
        List orgs = this.getTreeOrg(root);
        orgs = orgs.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x)).collect(Collectors.toList());
        Map map = this.getTreeOrgMap(root);
        DynamicObject[] objects = TaxcMainBusiness.loadTaxcMainQysdsByOrgNums(orgs, (Long)TaxationsysMappingEnum.CHN.getId());
        List jmqyhdzsOrgList = Stream.of(objects).filter(obj -> {
            DynamicObjectCollection taxTypes = obj.getDynamicObjectCollection("categoryentryentity");
            if (taxTypes.size() > 0) {
                DynamicObject taxTypeObj = (DynamicObject)taxTypes.get(0);
                return "jmqy".equals(taxTypeObj.getString("residenttype")) && "hdzs".equals(taxTypeObj.getString("levytype"));
            }
            return false;
        }).map(v -> v.getString("taxorg.org.name")).collect(Collectors.toList());
        if (jmqyhdzsOrgList.size() > 0) {
            String message = StringUtils.join((Object[])jmqyhdzsOrgList.toArray(), (char)'\u3001').concat(ResManager.loadKDString((String)"\u4e3a\u5c45\u6c11\u4f01\u4e1a\u6838\u5b9a\u5f81\u6536\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\u3002", (String)"OrgGroupSelectPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(message);
            return false;
        }
        return true;
    }
}

