/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.common.util.DateUtils;
import kd.taxc.common.util.DynamicObjectCollectionUtil;
import kd.taxc.common.util.EmptyCheckUtils;
import kd.taxc.common.util.PermissionUtils;

public class OrgTakeRelationPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(OrgTakeRelationPlugin.class);
    protected static final String TCTB_ORG_TAKEDATA = "tctb_org_takedata";
    private static final String TAXORG_ENTITY = "taxorg_entity";
    private static final String ACCOUNTORG_ENTITY = "accountorg_entity";
    private static final String ITEM_SAVE = "item_save";
    private static final String ITEM_CLOSE = "item_close";
    private static final String TAXORG = "taxorg";
    private static final String ACCOUNTORG = "accountorg";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String CMBORGTYPE = "cmborgtype";
    private static final String TAXORG_DEL = "taxorg_del";
    private static final String ACCOUNTORG_DEL = "accountorg_del";
    private static final Map<String, String> KEY_MAP = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)OrgTakeRelationPlugin.ITEM_SAVE)) {
                    OrgTakeRelationPlugin.this.save();
                } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)OrgTakeRelationPlugin.ITEM_CLOSE)) {
                    OrgTakeRelationPlugin.this.beforeClosed();
                }
            }
        });
        OrgEdit taxOrgEdit = (OrgEdit)this.getControl(TAXORG);
        taxOrgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List permOrgs = OrgTakeRelationPlugin.this.getPermOrgs();
                if (!ObjectUtils.isEmpty((Object)permOrgs)) {
                    QFilter filter = new QFilter("id", "in", (Object)permOrgs);
                    beforeF7SelectEvent.getCustomQFilters().add(filter);
                }
                DynamicObjectCollection taxOrgs = OrgTakeRelationPlugin.this.getModel().getEntryEntity(OrgTakeRelationPlugin.TAXORG_ENTITY);
                HashSet ids = DynamicObjectCollectionUtil.getPkValueSet((DynamicObjectCollection)taxOrgs, (String)OrgTakeRelationPlugin.this.getPointId(OrgTakeRelationPlugin.TAXORG));
                QFilter idFilter = new QFilter("id", "not in", (Object)ids);
                beforeF7SelectEvent.getCustomQFilters().add(idFilter);
            }
        });
        taxOrgEdit.addAfterF7SelectListener(new AfterF7SelectListener(){

            public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
                OrgTakeRelationPlugin.this.doRepetitionOrgCheck(afterF7SelectEvent, OrgTakeRelationPlugin.TAXORG_ENTITY, OrgTakeRelationPlugin.TAXORG, false);
                DynamicObjectCollection taxOrgCollection = OrgTakeRelationPlugin.this.getModel().getEntryEntity(OrgTakeRelationPlugin.TAXORG_ENTITY);
                for (int i = 0; i < taxOrgCollection.size(); ++i) {
                    DynamicObject taxOrg = (DynamicObject)taxOrgCollection.get(i);
                    Long taxorgId = taxOrg.getLong(OrgTakeRelationPlugin.this.getPointId(OrgTakeRelationPlugin.TAXORG));
                    List list = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList(taxorgId), (String)"10");
                    if (ObjectUtils.isEmpty((Object)list)) continue;
                    OrgTakeRelationPlugin.this.getModel().setEntryCurrentRowIndex(OrgTakeRelationPlugin.TAXORG_ENTITY, i);
                    DynamicObjectCollection accountEntity = OrgTakeRelationPlugin.this.getModel().getEntryEntity(OrgTakeRelationPlugin.ACCOUNTORG_ENTITY);
                    if (!taxorgId.equals(0L) && (ObjectUtils.isEmpty((Object)accountEntity) || !ObjectUtils.isEmpty((Object)accountEntity) && accountEntity.isEmpty())) {
                        OrgTakeRelationPlugin.this.getModel().deleteEntryData(OrgTakeRelationPlugin.ACCOUNTORG_ENTITY);
                        int subRowIndex = OrgTakeRelationPlugin.this.getModel().createNewEntryRow(OrgTakeRelationPlugin.ACCOUNTORG_ENTITY);
                        OrgTakeRelationPlugin.this.getModel().setValue(OrgTakeRelationPlugin.ACCOUNTORG, (Object)taxorgId, subRowIndex);
                        OrgTakeRelationPlugin.this.getModel().setValue(OrgTakeRelationPlugin.STARTDATE, (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)"2000-01-01")), subRowIndex);
                        OrgTakeRelationPlugin.this.getView().setEnable(Boolean.valueOf(false), subRowIndex, new String[]{OrgTakeRelationPlugin.ACCOUNTORG});
                        OrgTakeRelationPlugin.this.getView().setEnable(Boolean.valueOf(false), subRowIndex, new String[]{OrgTakeRelationPlugin.STARTDATE});
                        OrgTakeRelationPlugin.this.getView().setEnable(Boolean.valueOf(false), subRowIndex, new String[]{OrgTakeRelationPlugin.ENDDATE});
                        OrgTakeRelationPlugin.this.getModel().setValue(OrgTakeRelationPlugin.CMBORGTYPE, (Object)10);
                    }
                    if (ObjectUtils.isEmpty((Object)taxorgId) || taxorgId.equals(0L)) continue;
                    OrgTakeRelationPlugin.this.getView().setEnable(Boolean.valueOf(false), i, new String[]{OrgTakeRelationPlugin.TAXORG});
                }
                EntryGrid orgList = (EntryGrid)OrgTakeRelationPlugin.this.getControl(OrgTakeRelationPlugin.TAXORG_ENTITY);
                int orgCount = OrgTakeRelationPlugin.this.getModel().getEntryRowCount(OrgTakeRelationPlugin.TAXORG_ENTITY);
                if (orgCount > 0) {
                    orgList.selectRows(orgCount - 1);
                }
            }
        });
        OrgEdit accountOrgEdit = (OrgEdit)this.getControl(ACCOUNTORG);
        accountOrgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                DynamicObject taxOrg;
                EntryGrid taxOrgs = (EntryGrid)OrgTakeRelationPlugin.this.getControl(OrgTakeRelationPlugin.TAXORG_ENTITY);
                int[] taxIds = taxOrgs.getSelectRows();
                if (taxIds.length > 0 && !ObjectUtils.isEmpty((Object)(taxOrg = OrgTakeRelationPlugin.this.getModel().getEntryRowEntity(OrgTakeRelationPlugin.TAXORG_ENTITY, taxIds[0]))) && !ObjectUtils.isEmpty((Object)taxOrg.getString(OrgTakeRelationPlugin.this.getPointId(OrgTakeRelationPlugin.TAXORG)))) {
                    QFilter filter = new QFilter("id", "!=", (Object)taxOrg.getLong(OrgTakeRelationPlugin.this.getPointId(OrgTakeRelationPlugin.TAXORG)));
                    beforeF7SelectEvent.getCustomQFilters().add(filter);
                    beforeF7SelectEvent.getFormShowParameter().setCustomParam("initOrgFuncId", (Object)"10");
                }
            }
        });
        accountOrgEdit.addAfterF7SelectListener(new AfterF7SelectListener(){

            public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
                OrgTakeRelationPlugin.this.doRepetitionOrgCheck(afterF7SelectEvent, OrgTakeRelationPlugin.ACCOUNTORG_ENTITY, OrgTakeRelationPlugin.ACCOUNTORG, true);
            }
        });
        BasedataEdit cmborgtypeEdit = (BasedataEdit)this.getControl(CMBORGTYPE);
        cmborgtypeEdit.addBeforeF7SelectListener(evt -> {
            int row = evt.getRow();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ACCOUNTORG, row);
            if (null == org) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u5143\u3002", (String)"OrgTakeRelationPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object orgid = org.getPkValue();
            org = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
            String ffieldnames = this.getPageCache().get(String.valueOf(orgid));
            if (StringUtils.isBlank((CharSequence)ffieldnames)) {
                DynamicObject[] allOrgBiz = BusinessDataServiceHelper.load((String)"bos_org_biz", (String)"ffieldname", null);
                StringBuilder sb = new StringBuilder();
                for (DynamicObject orgBiz : allOrgBiz) {
                    String ffieldname = orgBiz.getString("ffieldname");
                    if (!StringUtils.isNotBlank((CharSequence)ffieldname) || !org.getBoolean(ffieldname)) continue;
                    sb.append(ffieldname);
                    if (sb.length() <= 0) continue;
                    sb.append(",");
                }
                ffieldnames = sb.substring(0, sb.length() - 1);
                this.getPageCache().put(String.valueOf(orgid), ffieldnames);
            }
            evt.addCustomQFilter(new QFilter("ffieldname", "in", (Object)ffieldnames.split(",")));
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof NewEntry && StringUtils.equalsIgnoreCase((CharSequence)"newentry", (CharSequence)((NewEntry)args.getSource()).getOperateKey())) {
            EntryGrid orgList = (EntryGrid)this.getControl(TAXORG_ENTITY);
            int[] indexs = orgList.getSelectRows();
            if (indexs.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgTakeRelationPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject taxOrg = this.getModel().getEntryRowEntity(TAXORG_ENTITY, indexs[0]);
            if (!ObjectUtils.isEmpty((Object)taxOrg) && ObjectUtils.isEmpty((Object)taxOrg.get(TAXORG))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgTakeRelationPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (EmptyCheckUtils.isNotEmpty((Object)key)) {
            this.handleDataByItemKey(KEY_MAP.getOrDefault(key, ""));
        }
    }

    private void handleDataByItemKey(String itemKey) {
        int[] indexs;
        EntryGrid orgList;
        ConfirmCallBackListener confirmCallBackListener;
        if (itemKey.equals(TAXORG_DEL)) {
            confirmCallBackListener = new ConfirmCallBackListener(itemKey, this.getForm());
            orgList = (EntryGrid)this.getControl(TAXORG_ENTITY);
            indexs = orgList.getSelectRows();
            if (indexs == null || indexs.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OrgTakeRelationPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isTip = false;
            for (int rowId : indexs) {
                DynamicObject row = (DynamicObject)this.getModel().getEntryEntity(TAXORG_ENTITY).get(rowId);
                DynamicObjectCollection accountOrgs = row.getDynamicObjectCollection(ACCOUNTORG_ENTITY);
                if (ObjectUtils.isEmpty((Object)accountOrgs) || accountOrgs.size() <= 0) continue;
                isTip = true;
            }
            if (isTip) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5b58\u5728\u88ab\u6c47\u603b\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u6c47\u603b\u53d6\u6570\u5173\u7cfb\u5417\uff1f", (String)"OrgTakeRelationPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBackListener);
            } else {
                this.getModel().deleteEntryRows(TAXORG_ENTITY, indexs);
            }
        }
        if (itemKey.equals(ACCOUNTORG_DEL)) {
            confirmCallBackListener = new ConfirmCallBackListener(itemKey, this.getForm());
            orgList = (EntryGrid)this.getControl(ACCOUNTORG_ENTITY);
            indexs = orgList.getSelectRows();
            if (indexs.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OrgTakeRelationPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Integer> delList = new ArrayList<Integer>(8);
            for (int index : indexs) {
                DynamicObject accountOrg = this.getModel().getEntryRowEntity(ACCOUNTORG_ENTITY, index);
                if (!ObjectUtils.isEmpty((Object)accountOrg.getString(this.getPointId(ACCOUNTORG)))) continue;
                delList.add(index);
            }
            if (delList.size() == indexs.length) {
                this.getModel().deleteEntryRows(ACCOUNTORG_ENTITY, delList.stream().mapToInt(Integer::intValue).toArray());
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u6838\u7b97\u7ec4\u7ec7\u540e\uff0c\u53d6\u6570\u65f6\u5c06\u4e0d\u518d\u53d6\u5230\u8be5\u7ec4\u7ec7\u6570\u636e\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"OrgTakeRelationPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBackListener);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)STARTDATE, (CharSequence)fieldKey)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (ObjectUtils.isEmpty((Object)newValue)) {
                int currentIndex = e.getChangeSet()[0].getRowIndex();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6570\u6709\u6548\u671f\u8d77\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                this.getModel().getEntryRowEntity(ACCOUNTORG_ENTITY, currentIndex).set(STARTDATE, oldValue);
                return;
            }
            this.propertyChangedTip(e);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ENDDATE, (CharSequence)fieldKey)) {
            this.propertyChangedTip(e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)TAXORG_DEL)) {
            if (MessageBoxResult.Yes.getValue() == messageBoxClosedEvent.getResult().getValue()) {
                EntryGrid orgList = (EntryGrid)this.getControl(TAXORG_ENTITY);
                int[] indexs = orgList.getSelectRows();
                this.getModel().deleteEntryRows(TAXORG_ENTITY, indexs);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ACCOUNTORG_DEL)) {
            if (MessageBoxResult.Yes.getValue() == messageBoxClosedEvent.getResult().getValue()) {
                EntryGrid taxOrgs = (EntryGrid)this.getControl(TAXORG_ENTITY);
                int[] taxIds = taxOrgs.getSelectRows();
                DynamicObject taxOrg = this.getModel().getEntryRowEntity(TAXORG_ENTITY, taxIds[0]);
                this.getModel().setEntryCurrentRowIndex(TAXORG_ENTITY, taxIds[0]);
                EntryGrid accountOrgs = (EntryGrid)this.getControl(ACCOUNTORG_ENTITY);
                int[] accountIds = accountOrgs.getSelectRows();
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < accountIds.length; ++i) {
                    DynamicObject accountOrg = this.getModel().getEntryRowEntity(ACCOUNTORG_ENTITY, accountIds[i]);
                    if (StringUtils.equalsIgnoreCase((CharSequence)taxOrg.getString(this.getPointId(TAXORG)), (CharSequence)accountOrg.getString(this.getPointId(ACCOUNTORG)))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u540c\u4e00\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002\u5982\u9700\u89e3\u9664\u53d6\u6570\u5173\u7cfb\uff0c\u8bf7\u5728\u5de6\u4fa7\u5217\u8868\u5220\u9664\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgTakeRelationPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    list.add(accountIds[i]);
                }
                this.getModel().deleteEntryRows(ACCOUNTORG_ENTITY, list.stream().mapToInt(Integer::intValue).toArray());
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ITEM_CLOSE) && MessageBoxResult.Yes.getValue() == messageBoxClosedEvent.getResult().getValue()) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.reloadAllInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid orgList = (EntryGrid)this.getControl(TAXORG_ENTITY);
        int orgCount = this.getModel().getEntryRowCount(TAXORG_ENTITY);
        if (orgCount > 0) {
            orgList.selectRows(0);
        }
    }

    private boolean propertyChangedTip(PropertyChangedArgs e) {
        boolean isInclude = false;
        int currentIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject currentRow = e.getChangeSet()[0].getDataEntity();
        Date curStartDate = DateUtils.getFirstDateOfMonth((Date)currentRow.getDate(STARTDATE));
        Date curEndDate = ObjectUtils.isEmpty((Object)currentRow.getDate(ENDDATE)) ? null : DateUtils.getLastDateOfMonth((Date)currentRow.getDate(ENDDATE));
        String orgId = currentRow.getString("accountorg.id");
        int size = this.getModel().getEntryRowCount(ACCOUNTORG_ENTITY);
        for (int i = 0; i < size; ++i) {
            Date enddate;
            DynamicObject orgObject = (DynamicObject)this.getModel().getValue(ACCOUNTORG, i);
            if (ObjectUtils.isEmpty((Object)orgObject) || !StringUtils.equalsIgnoreCase((CharSequence)orgId, (CharSequence)orgObject.getString("id")) || currentIndex == i) continue;
            Date startdate = DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue(STARTDATE, i)));
            Date date = enddate = ObjectUtils.isEmpty((Object)this.getModel().getValue(ENDDATE, i)) ? null : DateUtils.getLastDateOfMonth((Date)((Date)this.getModel().getValue(ENDDATE, i)));
            if (ObjectUtils.isEmpty((Object)startdate) && (ObjectUtils.isEmpty((Object)enddate) || !ObjectUtils.isEmpty((Object)enddate) && !ObjectUtils.isEmpty((Object)curStartDate) && curStartDate.compareTo(enddate) <= 0)) {
                isInclude = true;
                break;
            }
            if (ObjectUtils.isEmpty((Object)curStartDate) && (ObjectUtils.isEmpty((Object)curEndDate) || !ObjectUtils.isEmpty((Object)curEndDate) && !ObjectUtils.isEmpty((Object)startdate) && startdate.compareTo(curEndDate) <= 0)) {
                isInclude = true;
                break;
            }
            if (ObjectUtils.isEmpty((Object)startdate) || ObjectUtils.isEmpty((Object)curStartDate) || !DateUtils.isEffectiveDate((Date)startdate, (Date)curStartDate, (Date)curEndDate) && !DateUtils.isEffectiveDate((Date)curStartDate, (Date)startdate, (Date)enddate)) continue;
            isInclude = true;
            break;
        }
        if (isInclude) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6709\u6548\u671f\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\uff1a", (String)"OrgTakeRelationPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]).concat(currentRow.getString("accountorg.name")));
        }
        return isInclude;
    }

    private void beforeClosed() {
        if (this.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"OrgTakeRelationPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"OrgTakeRelationPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OrgTakeRelationPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            this.getView().close();
        }
    }

    protected void reloadAllInfo() {
        this.refreshForm();
        this.selectOrgListRow(0);
    }

    private void selectOrgListRow(int rowIndex) {
        EntryGrid eg = (EntryGrid)this.getControl(TAXORG_ENTITY);
        int entryCount = this.getModel().getEntryRowCount(TAXORG_ENTITY);
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        eg.selectRows(rowIndex);
        eg.getEntryState().selectRow(rowIndex);
        eg.getEntryState().setFocusRow(rowIndex);
        eg.entryRowClick(Integer.valueOf(rowIndex));
    }

    private String getSelectedField() {
        StringBuilder selectedField = new StringBuilder("id").append(",").append(TAXORG).append(",").append(ACCOUNTORG).append(",").append(STARTDATE).append(",").append(ENDDATE).append(",").append(CMBORGTYPE);
        return selectedField.toString();
    }

    private final void refreshForm() {
        DynamicObject[] orgTakeDataCollection = BusinessDataServiceHelper.load((String)TCTB_ORG_TAKEDATA, (String)this.getSelectedField(), (QFilter[])new QFilter[0]);
        LinkedHashMap<Long, Set> taxOrgMap = new LinkedHashMap<Long, Set>(10);
        for (int i = 0; i < orgTakeDataCollection.length; ++i) {
            Long taxorgId = orgTakeDataCollection[i].getLong(this.getPointId(TAXORG));
            Object id = orgTakeDataCollection[i].get("id");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ACCOUNTORG, orgTakeDataCollection[i].getLong(this.getPointId(ACCOUNTORG)));
            map.put(STARTDATE, orgTakeDataCollection[i].getDate(STARTDATE));
            map.put(ENDDATE, orgTakeDataCollection[i].getDate(ENDDATE));
            map.put(CMBORGTYPE, orgTakeDataCollection[i].getLong(this.getPointId(CMBORGTYPE)));
            map.put("id", id);
            taxOrgMap.computeIfAbsent(taxorgId, k -> new LinkedHashSet()).add(map);
        }
        this.getModel().deleteEntryData(TAXORG_ENTITY);
        for (Map.Entry entry : taxOrgMap.entrySet()) {
            Long taxOrgId = (Long)entry.getKey();
            Set accountOrgs = (Set)entry.getValue();
            int rowIndex = this.getModel().createNewEntryRow(TAXORG_ENTITY);
            this.getModel().setValue(TAXORG, (Object)taxOrgId, rowIndex);
            this.getModel().setEntryCurrentRowIndex(TAXORG_ENTITY, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{TAXORG});
            for (Map accountOrg : accountOrgs) {
                int subRowIndex = this.getModel().createNewEntryRow(ACCOUNTORG_ENTITY);
                this.getModel().setValue(ACCOUNTORG, accountOrg.get(ACCOUNTORG), subRowIndex);
                this.getModel().setValue(STARTDATE, accountOrg.get(STARTDATE), subRowIndex);
                this.getModel().setValue(ENDDATE, accountOrg.get(ENDDATE), subRowIndex);
                this.getModel().setValue(CMBORGTYPE, accountOrg.get(CMBORGTYPE), subRowIndex);
                this.getModel().setValue("id", accountOrg.get("id"), subRowIndex);
                if (!taxOrgId.equals(accountOrg.get(ACCOUNTORG))) continue;
                this.getView().setEnable(Boolean.valueOf(false), subRowIndex, new String[]{ACCOUNTORG});
                this.getView().setEnable(Boolean.valueOf(false), subRowIndex, new String[]{STARTDATE});
                this.getView().setEnable(Boolean.valueOf(false), subRowIndex, new String[]{ENDDATE});
            }
        }
        this.getView().updateView(ACCOUNTORG_ENTITY);
    }

    private void save() {
        boolean validateResult = this.validate();
        if (!validateResult) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                int entryRowCount = this.getModel().getEntryRowCount(TAXORG_ENTITY);
                ArrayList<DynamicObject> forSaveObjArr = new ArrayList<DynamicObject>(10);
                ArrayList<Object> oldIds = new ArrayList<Object>(10);
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setEntryCurrentRowIndex(TAXORG_ENTITY, i);
                    DynamicObject taxorg = (DynamicObject)this.getModel().getValue(TAXORG, i);
                    int subAccountOrgCount = this.getModel().getEntryRowCount(ACCOUNTORG_ENTITY);
                    for (int j = 0; j < subAccountOrgCount; ++j) {
                        this.getModel().setEntryCurrentRowIndex(ACCOUNTORG_ENTITY, j);
                        DynamicObject accountorg = (DynamicObject)this.getModel().getValue(ACCOUNTORG, j);
                        Date startdate = DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue(STARTDATE, j)));
                        Date enddate = DateUtils.getLastDateOfMonth((Date)((Date)this.getModel().getValue(ENDDATE, j)));
                        Object cmborgtype = this.getModel().getValue(CMBORGTYPE, j);
                        Object id = this.getModel().getValue("id", j);
                        DynamicObject taxOrgObj = BusinessDataServiceHelper.newDynamicObject((String)TCTB_ORG_TAKEDATA);
                        if (!ObjectUtils.isEmpty((Object)id)) {
                            taxOrgObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)TCTB_ORG_TAKEDATA);
                            oldIds.add(id);
                        }
                        taxOrgObj.set(TAXORG, (Object)taxorg);
                        taxOrgObj.set(ACCOUNTORG, (Object)accountorg);
                        taxOrgObj.set(STARTDATE, (Object)startdate);
                        taxOrgObj.set(ENDDATE, (Object)enddate);
                        taxOrgObj.set(CMBORGTYPE, cmborgtype);
                        forSaveObjArr.add(taxOrgObj);
                    }
                }
                if (!ObjectUtils.isEmpty(forSaveObjArr) && forSaveObjArr.size() > 0) {
                    DeleteServiceHelper.delete((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[]{new QFilter("id", "not in", oldIds)});
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)forSaveObjArr.get(0)).getDataEntityType(), (Object[])forSaveObjArr.toArray());
                } else {
                    List list = QueryServiceHelper.queryPrimaryKeys((String)TCTB_ORG_TAKEDATA, (QFilter[])new QFilter[0], null, (int)-1);
                    DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)TCTB_ORG_TAKEDATA), (Object[])list.toArray());
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OrgTakeRelationPlugin_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                EntryGrid taxOrgs = (EntryGrid)this.getControl(TAXORG_ENTITY);
                int[] taxIds = taxOrgs.getSelectRows();
                this.refreshForm();
                if (!ObjectUtils.isEmpty((Object)taxIds)) {
                    this.selectOrgListRow(taxIds[0]);
                }
                this.getModel().setDataChanged(false);
            }
            catch (Throwable e1) {
                LOGGER.error(e1);
                h.markRollback();
                throw e1;
            }
        }
    }

    private boolean validate() {
        DynamicObjectCollection taxOrgCollection = this.getModel().getEntryEntity(TAXORG_ENTITY);
        for (int i = 0; i < taxOrgCollection.size(); ++i) {
            DynamicObject taxOrg = (DynamicObject)taxOrgCollection.get(i);
            String taxOrgName = taxOrg.getString("taxorg.name");
            if (StringUtils.isBlank((CharSequence)taxOrgName)) {
                String info = ResManager.loadKDString((String)"\u7b2c", (String)"OrgTakeRelationPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) + String.valueOf(i + 1) + ResManager.loadKDString((String)"\u884c\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(info);
                return false;
            }
            DynamicObjectCollection accountorgs = taxOrg.getDynamicObjectCollection(ACCOUNTORG_ENTITY);
            if (accountorgs.size() == 0) {
                String info = ResManager.loadKDString((String)"\u7b2c", (String)"OrgTakeRelationPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) + String.valueOf(i + 1) + ResManager.loadKDString((String)"\u884c\u7684  ", (String)"OrgTakeRelationPlugin_14", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) + taxOrgName + ResManager.loadKDString((String)" \u672a\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OrgTakeRelationPlugin_15", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(info);
                return false;
            }
            for (int j = 0; j < accountorgs.size(); ++j) {
                DynamicObject accountorg = (DynamicObject)accountorgs.get(j);
                String accountOrgId = accountorg.getString(this.getPointId(ACCOUNTORG));
                String cmborgtypeId = accountorg.getString(this.getPointId(CMBORGTYPE));
                String accountOrgName = accountorg.getString("accountorg.name");
                Date startdate = DateUtils.getFirstDateOfMonth((Date)accountorg.getDate(STARTDATE));
                Date enddate = DateUtils.getLastDateOfMonth((Date)accountorg.getDate(ENDDATE));
                if (ObjectUtils.isEmpty((Object)accountOrgId)) {
                    this.showOrgDateNotification(i, taxOrgName, "", ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_16", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (ObjectUtils.isEmpty((Object)cmborgtypeId)) {
                    this.showOrgDateNotification(j, taxOrgName, ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"OrgTakeRelationPlugin_17", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_16", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (ObjectUtils.isEmpty((Object)startdate)) {
                    this.showOrgDateNotification(i, taxOrgName, accountOrgName, ResManager.loadKDString((String)"\u53d6\u6570\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_18", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (null != enddate && startdate.compareTo(enddate) >= 0) {
                    this.showOrgDateNotification(i, taxOrgName, accountOrgName, ResManager.loadKDString((String)"\u53d6\u6570\u6709\u6548\u671f\u6b62\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u53d6\u6570\u6709\u6548\u671f\u8d77\u3002", (String)"OrgTakeRelationPlugin_19", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                boolean isEffective = false;
                for (int k = 0; k < accountorgs.size(); ++k) {
                    DynamicObject comOrg = (DynamicObject)accountorgs.get(k);
                    String comOrgId = comOrg.getString(this.getPointId(ACCOUNTORG));
                    Date comStartdate = DateUtils.getFirstDateOfMonth((Date)comOrg.getDate(STARTDATE));
                    Date comEnddate = DateUtils.getLastDateOfMonth((Date)comOrg.getDate(ENDDATE));
                    if (!StringUtils.equalsIgnoreCase((CharSequence)accountOrgId, (CharSequence)comOrgId) || k == j) continue;
                    if (ObjectUtils.isEmpty((Object)comStartdate)) {
                        this.showOrgDateNotification(i, taxOrgName, accountOrgName, ResManager.loadKDString((String)"\u53d6\u6570\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_18", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (Objects.isNull(enddate) && Objects.isNull(comEnddate)) {
                        isEffective = true;
                        break;
                    }
                    if (!DateUtils.isEffectiveDate((Date)startdate, (Date)comStartdate, (Date)comEnddate) && !DateUtils.isEffectiveDate((Date)comStartdate, (Date)startdate, (Date)enddate)) continue;
                    isEffective = true;
                    break;
                }
                if (isEffective) {
                    this.showOrgDateNotification(i, taxOrgName, accountOrgName, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u53d6\u6570\u6709\u6548\u671f\u3002", (String)"OrgTakeRelationPlugin_20", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                    return false;
                }
                for (int ic = 0; ic < taxOrgCollection.size(); ++ic) {
                    DynamicObject comTaxOrg = (DynamicObject)taxOrgCollection.get(ic);
                    String comTaxOrgName = comTaxOrg.getString("taxorg.name");
                    if (StringUtils.isBlank((CharSequence)comTaxOrgName)) {
                        String info = ResManager.loadKDString((String)"\u7b2c", (String)"OrgTakeRelationPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) + String.valueOf(ic + 1) + ResManager.loadKDString((String)"\u884c\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_13", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(info);
                        return false;
                    }
                    if (ic == i) continue;
                    DynamicObjectCollection comAccountorgs = comTaxOrg.getDynamicObjectCollection(ACCOUNTORG_ENTITY);
                    for (int jc = 0; jc < comAccountorgs.size(); ++jc) {
                        DynamicObject comOrg = (DynamicObject)comAccountorgs.get(jc);
                        String comOrgId = comOrg.getString(this.getPointId(ACCOUNTORG));
                        String comAccountOrgName = comOrg.getString("accountorg.name");
                        Date comStartdate = DateUtils.getFirstDateOfMonth((Date)comOrg.getDate(STARTDATE));
                        Date comEnddate = DateUtils.getLastDateOfMonth((Date)comOrg.getDate(ENDDATE));
                        if (ObjectUtils.isEmpty((Object)comStartdate)) {
                            this.showOrgDateNotification(i, comTaxOrgName, comAccountOrgName, ResManager.loadKDString((String)"\u53d6\u6570\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTakeRelationPlugin_18", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                            return false;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)accountOrgId, (CharSequence)comOrgId)) continue;
                        if (Objects.isNull(enddate) && Objects.isNull(comEnddate)) {
                            isEffective = true;
                            break;
                        }
                        if (!DateUtils.isEffectiveDate((Date)startdate, (Date)comStartdate, (Date)comEnddate) && !DateUtils.isEffectiveDate((Date)comStartdate, (Date)startdate, (Date)enddate)) continue;
                        isEffective = true;
                        break;
                    }
                    if (!isEffective) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7(%1$s,%2$s)\u4e0b\u5b58\u5728\u6709\u6548\u671f\u76f8\u540c\u7684\u6838\u7b97\u7ec4\u7ec7\uff1a%3$s", (String)"OrgTakeRelationPlugin_21", (String)"taxc-tctb-formplugin", (Object[])new Object[0]), taxOrgName, comTaxOrgName, accountOrgName));
                    return false;
                }
            }
        }
        return true;
    }

    private String getPointId(String name) {
        return name + ".id";
    }

    private void doRepetitionOrgCheck(AfterF7SelectEvent afterF7SelectEvent, String entity, String field, boolean isCheckDate) {
        ListSelectedRowCollection listSelectedRows = afterF7SelectEvent.getListSelectedRowCollection();
        List inputValues = afterF7SelectEvent.getInputValues();
        ArrayList<String> duplicateOrg = new ArrayList<String>(8);
        if (!CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            for (ListSelectedRow selectedRow : listSelectedRows) {
                String itemId = String.valueOf(selectedRow.getPrimaryKeyValue());
                DynamicObject org = this.isDuplicateOrg(itemId, entity, field, isCheckDate);
                if (org == null) continue;
                duplicateOrg.add(org.getString("number") + org.getString("name"));
            }
        } else if (CollectionUtils.isEmpty((Collection)listSelectedRows) && !ObjectUtils.isEmpty((Object)inputValues)) {
            for (Object id : inputValues) {
                DynamicObject org = this.isDuplicateOrg(String.valueOf(id), entity, field, isCheckDate);
                if (org == null) continue;
                duplicateOrg.add(org.getString("number") + org.getString("name"));
            }
        }
        this.showOrgNotification(duplicateOrg, entity, field);
    }

    private void showOrgNotification(List<String> list, String entity, String field) {
        if (list.size() > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append(StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)TAXORG_ENTITY) ? ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7a0e\u52a1\u7ec4\u7ec7:", (String)"OrgTakeRelationPlugin_22", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u6709\u6548\u671f\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\uff1a", (String)"OrgTakeRelationPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            msg.append(StringUtils.join((Object[])list.toArray(), (String)"\u3001"));
            String message = msg.toString();
            this.getView().showTipNotification(message);
        }
    }

    private void showOrgDateNotification(int i, String taxOrgName, String accountOrgName, String message) {
        String info = ResManager.loadKDString((String)"\u7b2c", (String)"OrgTakeRelationPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) + String.valueOf(i + 1) + ResManager.loadKDString((String)"\u884c\u7684\u7a0e\u52a1\u7ec4\u7ec7", (String)"OrgTakeRelationPlugin_23", (String)"taxc-tctb-formplugin", (Object[])new Object[0]) + taxOrgName + accountOrgName + message;
        this.getView().showTipNotification(info);
    }

    private DynamicObject isDuplicateOrg(String id, String entity, String field, boolean isCheckDate) {
        EntryGrid orgList = (EntryGrid)this.getControl(TAXORG_ENTITY);
        DynamicObject taxOrg = this.getModel().getEntryRowEntity(TAXORG_ENTITY, orgList.getSelectRows()[0]);
        int size = this.getModel().getEntryRowCount(entity);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            DynamicObject orgObject = (DynamicObject)this.getModel().getValue(field, i);
            if (ObjectUtils.isEmpty((Object)orgObject) || !id.equalsIgnoreCase(orgObject.getString("id"))) continue;
            ++count;
            if (isCheckDate) {
                Date startdate = ObjectUtils.isEmpty((Object)this.getModel().getValue(STARTDATE, i)) ? null : DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue(STARTDATE, i)));
                Date enddate = ObjectUtils.isEmpty((Object)this.getModel().getValue(ENDDATE, i)) ? null : DateUtils.getLastDateOfMonth((Date)((Date)this.getModel().getValue(ENDDATE, i)));
                Date addStartDate = new Date();
                if (!ObjectUtils.isEmpty((Object)startdate) && !DateUtils.isEffectiveDate((Date)addStartDate, (Date)startdate, (Date)enddate)) {
                    --count;
                } else if (ObjectUtils.isEmpty((Object)startdate) && !ObjectUtils.isEmpty((Object)enddate) && addStartDate.compareTo(enddate) > 0) {
                    --count;
                }
            }
            if (count <= 1) continue;
            if (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)TAXORG)) {
                this.getModel().deleteEntryRow(entity, i);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)field, (CharSequence)ACCOUNTORG) && StringUtils.equalsIgnoreCase((CharSequence)taxOrg.getString(this.getPointId(TAXORG)), (CharSequence)id)) {
                this.getModel().deleteEntryRow(entity, i);
            }
            return orgObject;
        }
        return null;
    }

    private List<Long> getPermOrgs() {
        List orgIds = null;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm() && hasPermOrgResult.getHasPermOrgs().size() > 0) {
            orgIds = hasPermOrgResult.getHasPermOrgs();
        }
        return orgIds;
    }

    private IFormPlugin getForm() {
        return this;
    }

    static {
        KEY_MAP.put("donothingdeleteentry_tax", TAXORG_DEL);
        KEY_MAP.put("donothingdeleteentry", ACCOUNTORG_DEL);
    }
}

