/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctb.formplugin.org;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.common.util.DateUtils;

public class TaxApitudeDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SOFTWARE = "RJJCDLQY";
    private static final String SERVICE = "JSXJXFWQY";
    private static final String AREA = "SSYHQYLX";
    private static final String TEC = "GXJSQYLX";
    private static final String OTHER = "QTZZQYLX";
    private static final String OK = "btnok";
    private static final String CERTIFICATE_PANEL = "flexpanelap7";
    private static final String YXSY_PANEL = "flexpanelap6";
    private static final String WEST_COMPANY_NUMBER = "SSYHQYLXFTA001";
    private static final String XINJIANG_COMPANY_NUMBER = "SSYHQYLXFTA002";
    private static final String ANIMATION_COMPANY_NUMBER = "QTZZQYLXETC001";
    private static final Map<String, String> APITUDE2COMPANY_TYPE = new HashMap<String, String>(){
        {
            this.put("1", TaxApitudeDialogPlugin.SOFTWARE);
            this.put("2", TaxApitudeDialogPlugin.SERVICE);
            this.put("3", TaxApitudeDialogPlugin.AREA);
            this.put("4", TaxApitudeDialogPlugin.TEC);
            this.put("5", TaxApitudeDialogPlugin.OTHER);
        }
    };
    private static final Set<String> SPECIAL_COMPANY_TYPE = new HashSet<String>(){
        {
            this.add("RJJCDLQY110");
            this.add("RJJCDLQY120");
            this.add("RJJCDLQY130");
            this.add("RJJCDLQY140");
            this.add("RJJCDLQY150");
            this.add("RJJCDLQY210");
            this.add("RJJCDLQY311");
            this.add("RJJCDLQY321");
            this.add("RJJCDLQY400");
            this.add("RJJCDLQY500");
            this.add("RJJCDLQY600");
            this.add(TaxApitudeDialogPlugin.ANIMATION_COMPANY_NUMBER);
            this.add(TaxApitudeDialogPlugin.XINJIANG_COMPANY_NUMBER);
        }
    };

    public void afterCreateNewData(EventObject e) {
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        if (index != null) {
            IDataModel model = this.getView().getParentView().getModel();
            this.updateValues(model, index);
            DynamicObject companytype = (DynamicObject)model.getValue("companytype", index.intValue());
            if (null != companytype) {
                this.setVisibleByCompanyType(companytype.getString("number"));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL, "profitmyear", "profittype", YXSY_PANEL});
        }
    }

    private void updateValues(IDataModel parentModel, Integer index) {
        this.getModel().setValue("apitudetype", parentModel.getValue("apitudetype", index.intValue()));
        this.getModel().setValue("companytype", parentModel.getValue("companytype", index.intValue()));
        this.getModel().setValue("apitudestartdate", parentModel.getValue("apitudestartdate", index.intValue()));
        this.getModel().setValue("apitudeenddate", parentModel.getValue("apitudeenddate", index.intValue()));
        String profitmyear = (String)parentModel.getValue("profitmyear", index.intValue());
        if (StringUtils.isNotBlank((CharSequence)profitmyear)) {
            this.getModel().setValue("profitmyear", (Object)DateUtils.stringToDate((String)profitmyear, (String)"yyyy"));
        }
        this.getModel().setValue("yxsy", parentModel.getValue("yxsy", index.intValue()));
        this.getModel().setValue("profittype", parentModel.getValue("profittype", index.intValue()));
        this.getModel().setValue("issuedate", parentModel.getValue("issuedate", index.intValue()));
        this.getModel().setValue("certificateno", parentModel.getValue("certificateno", index.intValue()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OK});
        BasedataEdit tablefield = (BasedataEdit)this.getControl("companytype");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals("companytype")) {
            IDataModel model = this.getModel();
            String apitudeType = (String)model.getValue("apitudetype");
            String companyType = APITUDE2COMPANY_TYPE.get(apitudeType);
            QFilter id = new QFilter("parentnumber", "=", (Object)companyType);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (OK.equals(key)) {
            DynamicObject companyTypeDyo;
            String apitudetype = (String)this.getModel().getValue("apitudetype");
            String error = this.checkFields(apitudetype, companyTypeDyo = (DynamicObject)this.getModel().getValue("companytype"));
            if (null != error) {
                this.getView().showErrorNotification(error);
                return;
            }
            IDataModel parentModel = this.getView().getParentView().getModel();
            Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
            if (index != null) {
                this.setParentModelValues(parentModel, index);
                this.getView().close();
            } else {
                this.getView().returnDataToParent(this.getReturnData());
                this.getView().close();
            }
        }
    }

    private Map<String, Object> getReturnData() {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("apitudetype", this.getModel().getValue("apitudetype"));
        returnMap.put("companytype", this.getModel().getValue("companytype"));
        returnMap.put("apitudestartdate", this.getModel().getValue("apitudestartdate"));
        returnMap.put("apitudeenddate", this.getModel().getValue("apitudeenddate"));
        returnMap.put("yxsy", this.getModel().getValue("yxsy"));
        returnMap.put("profitmyear", DateUtils.format((Date)((Date)this.getModel().getValue("profitmyear")), (String)"yyyy"));
        returnMap.put("profittype", this.getModel().getValue("profittype"));
        returnMap.put("issuedate", this.getModel().getValue("issuedate"));
        returnMap.put("certificateno", this.getModel().getValue("certificateno"));
        return returnMap;
    }

    private void setParentModelValues(IDataModel parentModel, Integer index) {
        parentModel.setValue("apitudetype", this.getModel().getValue("apitudetype"), index.intValue());
        parentModel.setValue("companytype", this.getModel().getValue("companytype"), index.intValue());
        parentModel.setValue("apitudestartdate", this.getModel().getValue("apitudestartdate"), index.intValue());
        parentModel.setValue("apitudeenddate", this.getModel().getValue("apitudeenddate"), index.intValue());
        parentModel.setValue("yxsy", this.getModel().getValue("yxsy"), index.intValue());
        parentModel.setValue("profitmyear", (Object)DateUtils.format((Date)((Date)this.getModel().getValue("profitmyear")), (String)"yyyy"), index.intValue());
        parentModel.setValue("profittype", this.getModel().getValue("profittype"), index.intValue());
        parentModel.setValue("issuedate", this.getModel().getValue("issuedate", index.intValue()));
        parentModel.setValue("certificateno", this.getModel().getValue("certificateno", index.intValue()));
    }

    private String checkFields(String apitudetype, DynamicObject companyTypeDyo) {
        if (apitudetype == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u8d28\u7c7b\u578b\u3002", (String)"TaxApitudeDialogPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        if (companyTypeDyo == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f01\u4e1a\u7c7b\u578b\u3002", (String)"TaxApitudeDialogPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        Date startDate = (Date)this.getModel().getValue("apitudestartdate");
        if (startDate == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u671f\u8d77\u3002", (String)"TaxApitudeDialogPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        Date endDate = (Date)this.getModel().getValue("apitudeenddate");
        if (endDate != null) {
            if (startDate.compareTo(endDate) > 0) {
                return ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u6b62\u3002", (String)"TaxApitudeDialogPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            }
            if (DateUtils.getDayDiff((Date)startDate, (Date)endDate) < 364) {
                return ResManager.loadKDString((String)"\u8d44\u8d28\u6709\u6548\u671f\u4e0d\u5f97\u5c0f\u4e8e1\u5e74", (String)"TaxApitudeDialogPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            }
        }
        String companyType = companyTypeDyo.getString("parentnumber") + companyTypeDyo.getString("number");
        String error = null;
        switch (apitudetype) {
            case "1": {
                error = this.checkProfitYear();
                if (null != error) {
                    return error;
                }
            }
            case "3": {
                if (XINJIANG_COMPANY_NUMBER.equals(companyType) && null != (error = this.checkProfitYear())) {
                    return error;
                }
                Date validfrom = companyTypeDyo.getDate("validfrom");
                Date expired = companyTypeDyo.getDate("expired");
                if (expired != null && endDate != null && DateUtils.isEffectiveDate((Date)startDate, (Date)endDate, (Date)validfrom, (Date)expired) || expired == null && startDate != null && (validfrom.before(startDate) || validfrom.getTime() == startDate.getTime())) break;
                return ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u6b62\u65f6\u95f4\u4e0d\u80fd\u8d85\u51fa\u7a0e\u6536\u4f18\u60e0\u6709\u6548\u671f", (String)"TaxApitudeDialogPlugin_12", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            }
            case "4": {
                boolean isShanghai;
                DynamicObject company = (DynamicObject)this.getModel().getValue("companytype");
                boolean bl = isShanghai = company != null && "HT002".equalsIgnoreCase(company.getString("number"));
                if (isShanghai && null != (error = this.checkProfitYear())) {
                    return error;
                }
                Object issueDate = this.getModel().getValue("issuedate");
                if (issueDate == null) {
                    return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u8bc1\u65f6\u95f4", (String)"TaxApitudeDialogPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
                }
                Object certificateNo = this.getModel().getValue("certificateno");
                if (certificateNo != null) break;
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bc1\u4e66\u7f16\u53f7", (String)"TaxApitudeDialogPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            }
            case "5": {
                if (!ANIMATION_COMPANY_NUMBER.equals(companyType) || null == (error = this.checkProfitYear())) break;
                return error;
            }
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        int count = parentModel.getEntryRowCount("apitudeentryentity");
        Integer index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        int pyxsyCount = 0;
        int specialPyxsyCount = 0;
        int westPyxsyCount = 0;
        if (((Boolean)this.getModel().getValue("yxsy")).booleanValue()) {
            if (WEST_COMPANY_NUMBER.equals(companyType)) {
                ++westPyxsyCount;
            } else if (SPECIAL_COMPANY_TYPE.contains(companyType)) {
                ++specialPyxsyCount;
            } else {
                ++pyxsyCount;
            }
        }
        for (int i = 0; i < count; ++i) {
            Date currentEnd;
            Date currentStart;
            Date exsitEnd;
            Date exsitStart;
            if (null != index && i == index || null == parentModel.getValue("companytype", i)) continue;
            String existcompanyType = ((DynamicObject)parentModel.getValue("companytype", i)).getString("number");
            Long id = ((DynamicObject)parentModel.getValue("companytype", i)).getLong("id");
            DynamicObject dyn = this.getDyn(id);
            String existParentnumber = dyn.getString("parentnumber");
            existcompanyType = existParentnumber + existcompanyType;
            if (companyType.equals(existcompanyType) && !DateUtils.checkTimeRepeat((Date)(exsitStart = (Date)parentModel.getValue("apitudestartdate", i)), (Date)(exsitEnd = (Date)parentModel.getValue("apitudeenddate", i)), (Date)(currentStart = (Date)this.getModel().getValue("apitudestartdate")), (Date)(currentEnd = (Date)this.getModel().getValue("apitudeenddate")))) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u8d77\u6b62\u65f6\u95f4\u5185\u5df2\u5b58\u5728\u76f8\u540c\u4f01\u4e1a\u7c7b\u578b", (String)"TaxApitudeDialogPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
            }
            if (!((Boolean)parentModel.getValue("yxsy", i)).booleanValue()) continue;
            if (WEST_COMPANY_NUMBER.equals(existcompanyType)) {
                ++westPyxsyCount;
                continue;
            }
            if (SPECIAL_COMPANY_TYPE.contains(existcompanyType)) {
                ++specialPyxsyCount;
                continue;
            }
            ++pyxsyCount;
        }
        if (pyxsyCount + specialPyxsyCount + westPyxsyCount <= 1 || pyxsyCount == 0 && specialPyxsyCount == 1 && westPyxsyCount == 1) {
            return null;
        }
        return ResManager.loadKDString((String)"\u5b58\u5728\u5176\u4ed6\u76f8\u51b2\u7a81\u7684\u4f18\u5148\u9002\u7528\u4f18\u60e0\u653f\u7b56", (String)"TaxApitudeDialogPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
    }

    private String checkProfitYear() {
        Date profitmyear = (Date)this.getModel().getValue("profitmyear");
        if (profitmyear == null) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f00\u59cb\u8ba1\u7b97\u4f18\u60e0\u5e74\u5ea6\u201d\u3002", (String)"TaxApitudeDialogPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("apitudetype".equals(key) || "companytype".equals(key)) {
            DynamicObject companyType = (DynamicObject)this.getModel().getValue("companytype");
            this.clearData(key);
            this.setVisibleByCompanyType(null == companyType ? null : companyType.getString("number"));
            this.fillProfitType((String)this.getModel().getValue("apitudetype"), companyType);
        }
    }

    private void fillProfitType(String apitudeType, DynamicObject companyType) {
        if (null == apitudeType || null == companyType) {
            return;
        }
        if (TEC.equals(companyType.getString("parentnumber"))) {
            boolean isShanghai = "HT002".equalsIgnoreCase(companyType.getString("number"));
            if (!isShanghai) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"profitmyear"});
                this.getModel().setValue("profitmyear", null);
                this.getModel().setValue("profittype", (Object)ResManager.loadKDString((String)"\u8d44\u8d28\u671f\u5185\u51cf\u630915%\u7a0e\u7387", (String)"TaxApitudeDialogPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"profitmyear"});
                this.getModel().setValue("profittype", (Object)ResManager.loadKDString((String)"\u4e24\u514d\u4e09\u51cf\u534a\u3001\u8d44\u8d28\u671f\u5185\u51cf\u630915%\u7a0e\u7387", (String)"TaxApitudeDialogPlugin_11", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getModel().setValue("profittype", (Object)companyType.getString("desc"));
        }
    }

    private void clearData(String key) {
        if ("apitudetype".equals(key)) {
            this.getModel().setValue("companytype", null);
        }
        this.getModel().setValue("issuedate", null);
        this.getModel().setValue("certificateno", null);
        this.getModel().setValue("profitmyear", null);
        this.getModel().setValue("profittype", null);
        this.getModel().setValue("yxsy", null);
    }

    private void setVisibleByCompanyType(String companytype) {
        String val = (String)this.getModel().getValue("apitudetype");
        if (null == val) {
            return;
        }
        switch (val) {
            case "1": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"profitmyear", "profittype", YXSY_PANEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL});
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"profittype", YXSY_PANEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL, "profitmyear"});
                break;
            }
            case "3": {
                if (XINJIANG_COMPANY_NUMBER.equals(companytype) || "FTA002".equalsIgnoreCase(companytype)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"profitmyear", "profittype", YXSY_PANEL});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL, "profitmyear"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"profittype", YXSY_PANEL});
                break;
            }
            case "4": {
                boolean isShanghai = "HT002".equalsIgnoreCase(companytype);
                if (!isShanghai) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"profitmyear"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"profitmyear"});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{CERTIFICATE_PANEL, "profittype", YXSY_PANEL});
                break;
            }
            case "5": {
                if (ANIMATION_COMPANY_NUMBER.equals(companytype) || "ETC001".equals(companytype)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"profitmyear", "profittype", YXSY_PANEL});
                    break;
                }
                if ("ETC002".equals(companytype) || "ETC003".equals(companytype) || "ETC004".equals(companytype) || "ETC009".equals(companytype)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL, "profitmyear"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"profittype", YXSY_PANEL});
                    break;
                }
                if ("ETC005".equals(companytype) || "ETC006".equals(companytype) || "ETC007".equals(companytype) || "ETC008".equals(companytype) || "ETC099".equals(companytype)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL, "profitmyear", YXSY_PANEL});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"profittype"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{CERTIFICATE_PANEL, "profitmyear", YXSY_PANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"profittype", "profitmyear"});
                break;
            }
        }
    }

    private DynamicObject getDyn(Long id) {
        return BusinessDataServiceHelper.loadSingle((String)"tpo_tccit_bizdef_entry", (String)"parentnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }
}

